/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.codeStyle.GroovyCodeStyleSettings;
import org.jetbrains.plugins.groovy.formatter.GeeseUtil;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class ConvertFromGeeseBracesIntention
extends Intention {
    private static final Logger LOG = Logger.getInstance(ConvertFromGeeseBracesIntention.class);
    private static final PsiElementPredicate MY_PREDICATE = new PsiElementPredicate(){

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            if (element.getLanguage() != GroovyLanguage.INSTANCE) {
                return false;
            }
            if (!((GroovyCodeStyleSettings)CodeStyleSettingsManager.getInstance((Project)element.getProject()).getCurrentSettings().getCustomSettings(GroovyCodeStyleSettings.class)).USE_FLYING_GEESE_BRACES) {
                return false;
            }
            if (PsiImplUtil.isWhiteSpaceOrNls(element)) {
                element = PsiTreeUtil.prevLeaf((PsiElement)element);
            }
            if (!GeeseUtil.isClosureRBrace(element)) {
                return false;
            }
            String text = element.getContainingFile().getText();
            PsiElement first = element;
            PsiElement last = element;
            PsiElement cur = ConvertFromGeeseBracesIntention.getNext(element);
            while (GeeseUtil.isClosureRBrace(cur)) {
                if (!StringUtil.contains((CharSequence)text, (int)last.getTextRange().getEndOffset(), (int)cur.getTextRange().getStartOffset(), (char)'\n')) {
                    return true;
                }
                last = cur;
                cur = ConvertFromGeeseBracesIntention.getNext(cur);
            }
            cur = ConvertFromGeeseBracesIntention.getPrev(element);
            while (GeeseUtil.isClosureRBrace(cur)) {
                if (!StringUtil.contains((CharSequence)text, (int)cur.getTextRange().getEndOffset(), (int)first.getTextRange().getStartOffset(), (char)'\n')) {
                    return true;
                }
                first = cur;
                cur = ConvertFromGeeseBracesIntention.getPrev(cur);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/style/ConvertFromGeeseBracesIntention$1", "satisfiedBy"));
        }
    };

    @Nullable
    private static PsiElement getPrev(PsiElement element) {
        PsiElement prev = PsiUtil.getPreviousNonWhitespaceToken(element);
        if (prev != null && prev.getNode().getElementType() == GroovyTokenTypes.mNLS) {
            prev = PsiUtil.getPreviousNonWhitespaceToken(prev);
        }
        return prev;
    }

    @Nullable
    private static PsiElement getNext(PsiElement element) {
        PsiElement next = GeeseUtil.getNextNonWhitespaceToken(element);
        if (next != null && next.getNode().getElementType() == GroovyTokenTypes.mNLS) {
            next = GeeseUtil.getNextNonWhitespaceToken(next);
        }
        return next;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            ConvertFromGeeseBracesIntention.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ConvertFromGeeseBracesIntention.$$$reportNull$$$0(1);
        }
        if (PsiImplUtil.isWhiteSpaceOrNls(element)) {
            element = PsiTreeUtil.prevLeaf((PsiElement)element);
        }
        LOG.assertTrue(GeeseUtil.isClosureRBrace(element));
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiFile file = element.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        PsiElement first = null;
        PsiElement last = null;
        PsiElement cur = element;
        while (GeeseUtil.isClosureRBrace(cur)) {
            last = cur;
            cur = ConvertFromGeeseBracesIntention.getNext(cur);
        }
        cur = element;
        while (GeeseUtil.isClosureRBrace(cur)) {
            first = cur;
            cur = ConvertFromGeeseBracesIntention.getPrev(cur);
        }
        LOG.assertTrue(first != null);
        LOG.assertTrue(last != null);
        RangeMarker rangeMarker = document.createRangeMarker(first.getTextRange().getStartOffset(), last.getTextRange().getEndOffset());
        String text = document.getText();
        PsiElement cur2 = ConvertFromGeeseBracesIntention.getPrev(last);
        while (GeeseUtil.isClosureRBrace(cur2)) {
            int offset = last.getTextRange().getStartOffset();
            if (!StringUtil.contains((CharSequence)text, (int)cur2.getTextRange().getEndOffset(), (int)offset, (char)'\n')) {
                document.insertString(offset, (CharSequence)"\n");
            }
            last = cur2;
            cur2 = ConvertFromGeeseBracesIntention.getPrev(cur2);
        }
        CodeStyleManager.getInstance((Project)project).reformatText(file, rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = MY_PREDICATE;
        if (psiElementPredicate == null) {
            ConvertFromGeeseBracesIntention.$$$reportNull$$$0(2);
        }
        return psiElementPredicate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/style/ConvertFromGeeseBracesIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/style/ConvertFromGeeseBracesIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

