/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ParenthesesUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyConstantExpressionEvaluator;

public class SimplifyTernaryOperatorIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            SimplifyTernaryOperatorIntention.$$$reportNull$$$0(0);
        }
        if (project == null) {
            SimplifyTernaryOperatorIntention.$$$reportNull$$$0(1);
        }
        if (!(element instanceof GrConditionalExpression)) {
            throw new IncorrectOperationException("Not invoked on a conditional");
        }
        GrConditionalExpression condExp = (GrConditionalExpression)element;
        GrExpression thenBranch = condExp.getThenBranch();
        GrExpression elseBranch = condExp.getElseBranch();
        Object thenVal = GroovyConstantExpressionEvaluator.evaluate(thenBranch);
        if (Boolean.TRUE.equals(thenVal) && elseBranch != null) {
            GrExpression conditionExp = condExp.getCondition();
            String conditionExpText = SimplifyTernaryOperatorIntention.getStringToPutIntoOrExpression(conditionExp);
            String elseExpText = SimplifyTernaryOperatorIntention.getStringToPutIntoOrExpression(elseBranch);
            String newExp = conditionExpText + "||" + elseExpText;
            SimplifyTernaryOperatorIntention.manageReplace(editor, condExp, conditionExpText, newExp);
            return;
        }
        Object elseVal = GroovyConstantExpressionEvaluator.evaluate(elseBranch);
        if (Boolean.FALSE.equals(elseVal) && thenBranch != null) {
            GrExpression conditionExp = condExp.getCondition();
            String conditionExpText = SimplifyTernaryOperatorIntention.getStringToPutIntoAndExpression(conditionExp);
            String thenExpText = SimplifyTernaryOperatorIntention.getStringToPutIntoAndExpression(thenBranch);
            String newExp = conditionExpText + "&&" + thenExpText;
            SimplifyTernaryOperatorIntention.manageReplace(editor, condExp, conditionExpText, newExp);
        }
    }

    private static void manageReplace(Editor editor, GrConditionalExpression condExp, String conditionExpText, String newExp) {
        int caretOffset = conditionExpText.length() + 2;
        GrExpression expressionFromText = GroovyPsiElementFactory.getInstance(editor.getProject()).createExpressionFromText(newExp, condExp.getContext());
        expressionFromText = (GrExpression)condExp.replace(expressionFromText);
        editor.getCaretModel().moveToOffset(expressionFromText.getTextOffset() + caretOffset);
    }

    @NotNull
    private static String getStringToPutIntoAndExpression(GrExpression expression) {
        String expressionText = expression.getText();
        if (ParenthesesUtils.AND_PRECEDENCE < ParenthesesUtils.getPrecedence(expression)) {
            expressionText = "(" + expressionText + ")";
        }
        String string = expressionText;
        if (string == null) {
            SimplifyTernaryOperatorIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static String getStringToPutIntoOrExpression(GrExpression expression) {
        String expressionText = expression.getText();
        if (ParenthesesUtils.OR_PRECEDENCE < ParenthesesUtils.getPrecedence(expression)) {
            expressionText = "(" + expressionText + ")";
        }
        String string = expressionText;
        if (string == null) {
            SimplifyTernaryOperatorIntention.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(element instanceof GrConditionalExpression)) {
                    return false;
                }
                GrConditionalExpression condExp = (GrConditionalExpression)element;
                PsiType condType = condExp.getType();
                if (condType == null || !PsiType.BOOLEAN.isConvertibleFrom(condType)) {
                    return false;
                }
                GrExpression thenBranch = condExp.getThenBranch();
                GrExpression elseBranch = condExp.getElseBranch();
                Object thenVal = GroovyConstantExpressionEvaluator.evaluate(thenBranch);
                if (Boolean.TRUE.equals(thenVal) && elseBranch != null) {
                    return true;
                }
                Object elseVal = GroovyConstantExpressionEvaluator.evaluate(elseBranch);
                return thenBranch != null && Boolean.FALSE.equals(elseVal);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/control/SimplifyTernaryOperatorIntention$1", "satisfiedBy"));
            }
        };
        if (psiElementPredicate == null) {
            SimplifyTernaryOperatorIntention.$$$reportNull$$$0(4);
        }
        return psiElementPredicate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/control/SimplifyTernaryOperatorIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/control/SimplifyTernaryOperatorIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringToPutIntoAndExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringToPutIntoOrExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

