/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gpp;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.findUsages.LiteralConstructorReference;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;

public class GppTypeConverter
extends GrTypeConverter {
    @Override
    public boolean isApplicableTo(@NotNull GrTypeConverter.ApplicableTo position) {
        if (position == null) {
            GppTypeConverter.$$$reportNull$$$0(0);
        }
        return position == GrTypeConverter.ApplicableTo.ASSIGNMENT;
    }

    @Override
    @Nullable
    public ConversionResult isConvertibleEx(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GroovyPsiElement context, @NotNull GrTypeConverter.ApplicableTo currentPosition) {
        if (targetType == null) {
            GppTypeConverter.$$$reportNull$$$0(1);
        }
        if (actualType == null) {
            GppTypeConverter.$$$reportNull$$$0(2);
        }
        if (context == null) {
            GppTypeConverter.$$$reportNull$$$0(3);
        }
        if (currentPosition == null) {
            GppTypeConverter.$$$reportNull$$$0(4);
        }
        if (context instanceof GrListOrMap && context.getReference() instanceof LiteralConstructorReference && ((LiteralConstructorReference)context.getReference()).getConstructedClassType() != null) {
            return null;
        }
        if (actualType instanceof GrTupleType) {
            PsiType tupleComponent;
            PsiType[] parameters;
            GrTupleType tupleType = (GrTupleType)actualType;
            PsiType expectedComponent = PsiUtil.extractIterableTypeParameter((PsiType)targetType, (boolean)false);
            if (expectedComponent != null && GppTypeConverter.isMethodCallConversion(context) && (parameters = tupleType.getParameters()).length == 1 && (tupleComponent = parameters[0]) != null && TypesUtil.canAssign(expectedComponent, tupleComponent, context, GrTypeConverter.ApplicableTo.ASSIGNMENT) == ConversionResult.OK && GppTypeConverter.hasDefaultConstructor(targetType)) {
                return ConversionResult.OK;
            }
        }
        return null;
    }

    public static boolean isClosureOverride(PsiType[] methodParameters, GrClosureType closureType, GroovyPsiElement context) {
        GrSignature signature = closureType.getSignature();
        return methodParameters != null && GrClosureSignatureUtil.isSignatureApplicable(signature, methodParameters, context);
    }

    public static boolean hasDefaultConstructor(PsiType type) {
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type);
        return psiClass != null && PsiUtil.hasDefaultConstructor((PsiClass)psiClass, (boolean)true, (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentPosition";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/gpp/GppTypeConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableTo";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isConvertibleEx";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

