/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter.blocks;

import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiErrorElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.formatter.AlignmentProvider;
import org.jetbrains.plugins.groovy.formatter.FormattingContext;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlock;
import org.jetbrains.plugins.groovy.formatter.processors.GroovyWrappingProcessor;

public class ParameterListBlock
extends GroovyBlock {
    private final List<Block> mySubBlocks;
    private final TextRange myTextRange;

    @Override
    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            ParameterListBlock.$$$reportNull$$$0(0);
        }
        return textRange;
    }

    public ParameterListBlock(@NotNull Indent indent, @Nullable Wrap wrap, @NotNull FormattingContext context, @NotNull ASTNode leftParenth, @NotNull ASTNode parameterList, @Nullable ASTNode rightParenth, @NotNull List<ASTNode> astNodes) {
        if (indent == null) {
            ParameterListBlock.$$$reportNull$$$0(1);
        }
        if (context == null) {
            ParameterListBlock.$$$reportNull$$$0(2);
        }
        if (leftParenth == null) {
            ParameterListBlock.$$$reportNull$$$0(3);
        }
        if (parameterList == null) {
            ParameterListBlock.$$$reportNull$$$0(4);
        }
        if (astNodes == null) {
            ParameterListBlock.$$$reportNull$$$0(5);
        }
        super(parameterList, indent, wrap, context);
        this.mySubBlocks = new ArrayList<Block>();
        this.mySubBlocks.add(new GroovyBlock(leftParenth, Indent.getNoneIndent(), Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), this.myContext));
        boolean unfinished = ParameterListBlock.isParameterListUnfinished(this.myNode);
        if (this.myContext.getSettings().ALIGN_MULTILINE_PARAMETERS) {
            AlignmentProvider.Aligner aligner = this.myContext.getAlignmentProvider().createAligner(false);
            for (ASTNode node : astNodes) {
                aligner.append(node.getPsi());
            }
            if (rightParenth != null && unfinished) {
                aligner.append(rightParenth.getPsi());
            }
        }
        GroovyWrappingProcessor wrappingProcessor = new GroovyWrappingProcessor(this);
        for (ASTNode childNode : astNodes) {
            this.mySubBlocks.add(new GroovyBlock(childNode, Indent.getContinuationIndent(), wrappingProcessor.getChildWrap(childNode), this.myContext));
        }
        if (rightParenth != null) {
            this.mySubBlocks.add(new GroovyBlock(rightParenth, unfinished ? Indent.getContinuationIndent() : Indent.getNoneIndent(), Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), this.myContext));
            if (!unfinished && this.myContext.getSettings().ALIGN_MULTILINE_METHOD_BRACKETS) {
                this.myContext.getAlignmentProvider().addPair(leftParenth, rightParenth, false);
            }
        }
        this.myTextRange = TextRange.create((int)this.mySubBlocks.get(0).getTextRange().getStartOffset(), (int)this.mySubBlocks.get(this.mySubBlocks.size() - 1).getTextRange().getEndOffset());
    }

    @Override
    @NotNull
    public List<Block> getSubBlocks() {
        List<Block> list = this.mySubBlocks;
        if (list == null) {
            ParameterListBlock.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static boolean isParameterListUnfinished(ASTNode parameterList) {
        ASTNode last = parameterList.getLastChildNode();
        return last instanceof PsiErrorElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/formatter/blocks/ParameterListBlock";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftParenth";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/formatter/blocks/ParameterListBlock";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBlocks";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

