/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.light.LightMemberReference;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.findUsages.GroovyScopeUtil;
import org.jetbrains.plugins.groovy.findUsages.LiteralConstructorSearcher;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;

public class GroovyConstructorUsagesSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public static final Key<Set<PsiClass>> LITERALLY_CONSTRUCTED_CLASSES = Key.create((String)"LITERALLY_CONSTRUCTED_CLASSES");

    public GroovyConstructorUsagesSearcher() {
        super(true);
    }

    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters p, @NotNull Processor<? super PsiReference> consumer) {
        if (p == null) {
            GroovyConstructorUsagesSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            GroovyConstructorUsagesSearcher.$$$reportNull$$$0(1);
        }
        GroovyConstructorUsagesSearcher.processConstructorUsages(p.getMethod(), p.getEffectiveSearchScope(), consumer, p.getOptimizer(), !p.isStrictSignatureSearch());
    }

    static void processConstructorUsages(final PsiMethod constructor, SearchScope searchScope, final Processor<? super PsiReference> consumer, SearchRequestCollector collector, boolean includeOverloads) {
        if (!constructor.isConstructor()) {
            return;
        }
        PsiClass clazz = constructor.getContainingClass();
        if (clazz == null) {
            return;
        }
        SearchScope onlyGroovy = GroovyScopeUtil.restrictScopeToGroovyFiles(searchScope, GroovyScopeUtil.getEffectiveScope(constructor));
        Set processed = (Set)collector.getSearchSession().getUserData(LITERALLY_CONSTRUCTED_CLASSES);
        if (processed == null) {
            processed = ContainerUtil.newConcurrentSet();
            collector.getSearchSession().putUserData(LITERALLY_CONSTRUCTED_CLASSES, (Object)processed);
        }
        if (!processed.add(clazz)) {
            return;
        }
        if (clazz.isEnum() && clazz instanceof GroovyPsiElement) {
            for (PsiField field : clazz.getFields()) {
                PsiReference ref;
                if (!(field instanceof GrEnumConstant) || (ref = field.getReference()) == null || !ref.isReferenceTo((PsiElement)constructor) || consumer.process((Object)ref)) continue;
                return;
            }
        }
        LiteralConstructorSearcher literalProcessor = new LiteralConstructorSearcher(constructor, consumer, includeOverloads);
        Processor newExpressionProcessor = grNewExpression -> {
            PsiMethod resolvedConstructor = grNewExpression.resolveMethod();
            if (includeOverloads || constructor.getManager().areElementsEquivalent((PsiElement)resolvedConstructor, (PsiElement)constructor)) {
                return consumer.process((Object)grNewExpression.getReferenceElement());
            }
            return true;
        };
        GroovyConstructorUsagesSearcher.processGroovyClassUsages(clazz, onlyGroovy, collector, (Processor<GrNewExpression>)newExpressionProcessor, literalProcessor);
        if (clazz instanceof GrTypeDefinition && !GroovyConstructorUsagesSearcher.processConstructors(constructor, consumer, clazz, true)) {
            return;
        }
        DirectClassInheritorsSearch.search((PsiClass)clazz, (SearchScope)onlyGroovy).forEach((Processor)new ReadActionProcessor<PsiClass>(){

            public boolean processInReadAction(PsiClass inheritor) {
                return !(inheritor instanceof GrTypeDefinition) || GroovyConstructorUsagesSearcher.processConstructors(constructor, (Processor<? super PsiReference>)consumer, inheritor, false);
            }
        });
    }

    public static void processGroovyClassUsages(PsiClass clazz, SearchScope scope, SearchRequestCollector collector, Processor<GrNewExpression> newExpressionProcessor, LiteralConstructorSearcher literalProcessor) {
        ReferencesSearch.searchOptimized((PsiElement)clazz, (SearchScope)scope, (boolean)false, (SearchRequestCollector)collector, (boolean)true, (ref, collector1) -> {
            PsiElement element = ref.getElement();
            return !(element instanceof GrCodeReferenceElement) || GroovyConstructorUsagesSearcher.processGroovyConstructorUsages((GrCodeReferenceElement)element, newExpressionProcessor, literalProcessor);
        });
    }

    private static boolean processGroovyConstructorUsages(GrCodeReferenceElement element, Processor<GrNewExpression> newExpressionProcessor, final LiteralConstructorSearcher literalProcessor) {
        PsiElement parent = element.getParent();
        if (parent instanceof GrAnonymousClassDefinition) {
            parent = parent.getParent();
        }
        if (parent instanceof GrNewExpression) {
            return newExpressionProcessor.process((Object)((GrNewExpression)parent));
        }
        if (parent instanceof GrTypeElement) {
            GrTypeCastExpression cast;
            GrTypeElement typeElement = (GrTypeElement)parent;
            PsiElement grandpa = typeElement.getParent();
            if (grandpa instanceof GrVariableDeclaration) {
                GrVariable variable;
                GrVariable[] vars = ((GrVariableDeclaration)grandpa).getVariables();
                if (vars.length == 1 && !GroovyConstructorUsagesSearcher.checkLiteralInstantiation((variable = vars[0]).getInitializerGroovy(), literalProcessor)) {
                    return false;
                }
            } else if (grandpa instanceof GrMethod) {
                GrMethod method = (GrMethod)grandpa;
                if (typeElement == method.getReturnTypeElementGroovy()) {
                    ControlFlowUtils.visitAllExitPoints(method.getBlock(), new ControlFlowUtils.ExitPointVisitor(){

                        @Override
                        public boolean visitExitPoint(Instruction instruction, @Nullable GrExpression returnValue) {
                            return GroovyConstructorUsagesSearcher.checkLiteralInstantiation(returnValue, literalProcessor);
                        }
                    });
                }
            } else if (grandpa instanceof GrTypeCastExpression ? (cast = (GrTypeCastExpression)grandpa).getCastTypeElement() == typeElement && !GroovyConstructorUsagesSearcher.checkLiteralInstantiation(cast.getOperand(), literalProcessor) : grandpa instanceof GrSafeCastExpression && (cast = (GrSafeCastExpression)grandpa).getCastTypeElement() == typeElement && !GroovyConstructorUsagesSearcher.checkLiteralInstantiation(cast.getOperand(), literalProcessor)) {
                return false;
            }
        }
        return true;
    }

    private static boolean checkLiteralInstantiation(GrExpression expression, LiteralConstructorSearcher literalProcessor) {
        if (expression instanceof GrListOrMap) {
            return literalProcessor.processLiteral((GrListOrMap)expression);
        }
        return true;
    }

    private static boolean processConstructors(PsiMethod searchedConstructor, Processor<? super PsiReference> consumer, PsiClass clazz, boolean processThisRefs) {
        PsiMethod[] constructors = clazz.getConstructors();
        if (constructors.length == 0) {
            GroovyConstructorUsagesSearcher.processImplicitConstructorCall((PsiMember)clazz, consumer, searchedConstructor);
        }
        for (PsiMethod constructor : constructors) {
            GrOpenBlock block;
            if (!(constructor instanceof GrMethod) || (block = ((GrMethod)constructor).getBlock()) == null) continue;
            GrStatement[] statements = block.getStatements();
            if (statements.length > 0 && statements[0] instanceof GrConstructorInvocation) {
                GrConstructorInvocation invocation = (GrConstructorInvocation)statements[0];
                if (invocation.isThisCall() != processThisRefs || !invocation.getManager().areElementsEquivalent((PsiElement)invocation.resolveMethod(), (PsiElement)searchedConstructor) || consumer.process((Object)invocation.getInvokedExpression())) continue;
                return false;
            }
            GroovyConstructorUsagesSearcher.processImplicitConstructorCall((PsiMember)constructor, consumer, searchedConstructor);
        }
        return true;
    }

    private static void processImplicitConstructorCall(final @NotNull PsiMember usage, Processor<? super PsiReference> processor, PsiMethod constructor) {
        GrParameter[] grParameters;
        if (usage == null) {
            GroovyConstructorUsagesSearcher.$$$reportNull$$$0(2);
        }
        if (constructor instanceof GrMethod ? (grParameters = (GrParameter[])constructor.getParameterList().getParameters()).length > 0 && !grParameters[0].isOptional() : !constructor.getParameterList().isEmpty()) {
            return;
        }
        PsiManager manager = constructor.getManager();
        if (manager.areElementsEquivalent((PsiElement)usage, (PsiElement)constructor) || manager.areElementsEquivalent((PsiElement)constructor.getContainingClass(), (PsiElement)usage.getContainingClass())) {
            return;
        }
        processor.process((Object)new LightMemberReference(manager, usage, PsiSubstitutor.EMPTY){

            @NotNull
            public PsiElement getElement() {
                PsiMember psiMember = usage;
                if (psiMember == null) {
                    3.$$$reportNull$$$0(0);
                }
                return psiMember;
            }

            @NotNull
            public TextRange getRangeInElement() {
                PsiIdentifier identifier;
                if (usage instanceof PsiClass) {
                    PsiIdentifier identifier2 = ((PsiClass)usage).getNameIdentifier();
                    if (identifier2 != null) {
                        TextRange textRange = TextRange.from((int)identifier2.getStartOffsetInParent(), (int)identifier2.getTextLength());
                        if (textRange == null) {
                            3.$$$reportNull$$$0(1);
                        }
                        return textRange;
                    }
                } else if (usage instanceof PsiMethod && (identifier = ((PsiMethod)usage).getNameIdentifier()) != null) {
                    TextRange textRange = TextRange.from((int)identifier.getStartOffsetInParent(), (int)identifier.getTextLength());
                    if (textRange == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    return textRange;
                }
                TextRange textRange = super.getRangeInElement();
                if (textRange == null) {
                    3.$$$reportNull$$$0(3);
                }
                return textRange;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/plugins/groovy/findUsages/GroovyConstructorUsagesSearcher$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElement";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRangeInElement";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/findUsages/GroovyConstructorUsagesSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processQuery";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processImplicitConstructorCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

