/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.extensions;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.search.GlobalSearchScope;
import icons.JetgroovyIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public abstract class GroovyScriptTypeDetector {
    public static final ExtensionPointName<GroovyScriptTypeDetector> EP_NAME = ExtensionPointName.create((String)"org.intellij.groovy.scriptTypeDetector");
    private final GroovyScriptType myScriptType;
    private final String[] myExtensions;

    protected GroovyScriptTypeDetector(GroovyScriptType scriptType, String ... extensions) {
        this.myScriptType = scriptType;
        this.myExtensions = extensions;
    }

    @NotNull
    public final String[] getExtensions() {
        if (this.myExtensions == null) {
            GroovyScriptTypeDetector.$$$reportNull$$$0(0);
        }
        return this.myExtensions;
    }

    @NotNull
    public final GroovyScriptType getScriptType() {
        GroovyScriptType groovyScriptType = this.myScriptType;
        if (groovyScriptType == null) {
            GroovyScriptTypeDetector.$$$reportNull$$$0(1);
        }
        return groovyScriptType;
    }

    public abstract boolean isSpecificScriptFile(@NotNull GroovyFile var1);

    @NotNull
    public static Icon getIcon(@NotNull GroovyFile script) {
        if (script == null) {
            GroovyScriptTypeDetector.$$$reportNull$$$0(2);
        }
        for (GroovyScriptTypeDetector detector : (GroovyScriptTypeDetector[])EP_NAME.getExtensions()) {
            if (!detector.isSpecificScriptFile(script)) continue;
            Icon icon = detector.getScriptType().getScriptIcon();
            if (icon == null) {
                GroovyScriptTypeDetector.$$$reportNull$$$0(3);
            }
            return icon;
        }
        Icon icon = JetgroovyIcons.Groovy.GroovyFile;
        if (icon == null) {
            GroovyScriptTypeDetector.$$$reportNull$$$0(4);
        }
        return icon;
    }

    public static GlobalSearchScope patchResolveScope(@NotNull GroovyFile script, GlobalSearchScope scope) {
        if (script == null) {
            GroovyScriptTypeDetector.$$$reportNull$$$0(5);
        }
        for (GroovyScriptTypeDetector detector : (GroovyScriptTypeDetector[])EP_NAME.getExtensions()) {
            if (!detector.isSpecificScriptFile(script)) continue;
            return detector.getScriptType().patchResolveScope(script, scope);
        }
        return scope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/extensions/GroovyScriptTypeDetector";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptType";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/extensions/GroovyScriptTypeDetector";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "patchResolveScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

