/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.actions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.text.CharArrayCharSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.codeStyle.GroovyCodeStyleSettings;
import org.jetbrains.plugins.groovy.editor.HandlerUtils;
import org.jetbrains.plugins.groovy.formatter.GeeseUtil;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class GroovyEnterHandler
extends EnterHandlerDelegateAdapter {
    private static final TokenSet GSTRING_TOKENS = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mGSTRING_BEGIN, GroovyTokenTypes.mGSTRING_CONTENT, GroovyTokenTypes.mGSTRING_END, GroovyTokenTypes.mGSTRING_LITERAL});
    private static final TokenSet REGEX_TOKENS = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mREGEX_BEGIN, GroovyTokenTypes.mREGEX_CONTENT, GroovyTokenTypes.mREGEX_END, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_BEGIN, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_END});
    private static final TokenSet AFTER_DOLLAR = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mLCURLY, GroovyTokenTypes.mIDENT, GroovyTokenTypes.mDOLLAR, GroovyTokenTypes.mGSTRING_END, GroovyTokenTypes.mREGEX_END, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_END, GroovyElementTypes.GSTRING_CONTENT, GroovyTokenTypes.mGSTRING_CONTENT, GroovyTokenTypes.mREGEX_CONTENT, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT});
    private static final TokenSet ALL_STRINGS = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mSTRING_LITERAL, GroovyTokenTypes.mGSTRING_LITERAL, GroovyTokenTypes.mGSTRING_BEGIN, GroovyTokenTypes.mGSTRING_END, GroovyTokenTypes.mGSTRING_CONTENT, GroovyTokenTypes.mRCURLY, GroovyTokenTypes.mIDENT, GroovyTokenTypes.mDOLLAR, GroovyTokenTypes.mREGEX_BEGIN, GroovyTokenTypes.mREGEX_CONTENT, GroovyTokenTypes.mREGEX_END, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_BEGIN, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_END, GroovyTokenTypes.mREGEX_LITERAL, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL, GroovyElementTypes.GSTRING_CONTENT});
    private static final TokenSet BEFORE_DOLLAR = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mGSTRING_BEGIN, GroovyTokenTypes.mREGEX_BEGIN, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_BEGIN, GroovyElementTypes.GSTRING_CONTENT, GroovyTokenTypes.mGSTRING_CONTENT, GroovyTokenTypes.mREGEX_CONTENT, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT});
    private static final TokenSet EXPR_END = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mRCURLY, GroovyTokenTypes.mIDENT});
    private static final TokenSet AFTER_EXPR_END = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mGSTRING_END, GroovyTokenTypes.mDOLLAR, GroovyTokenTypes.mREGEX_END, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_END, GroovyElementTypes.GSTRING_CONTENT, GroovyTokenTypes.mGSTRING_CONTENT, GroovyTokenTypes.mREGEX_CONTENT, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT});
    private static final TokenSet STRING_END = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mSTRING_LITERAL, GroovyTokenTypes.mGSTRING_LITERAL, GroovyTokenTypes.mGSTRING_END, GroovyTokenTypes.mREGEX_END, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_END, GroovyTokenTypes.mREGEX_LITERAL, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL});
    private static final TokenSet INNER_STRING_TOKENS = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mGSTRING_BEGIN, GroovyTokenTypes.mGSTRING_CONTENT, GroovyTokenTypes.mGSTRING_END, GroovyTokenTypes.mREGEX_BEGIN, GroovyTokenTypes.mREGEX_CONTENT, GroovyTokenTypes.mREGEX_END, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_BEGIN, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_END, GroovyElementTypes.GSTRING_INJECTION, GroovyElementTypes.GSTRING_CONTENT});

    public static void insertSpacesByGroovyContinuationIndent(Editor editor, Project project) {
        int indentSize = CodeStyle.getSettings((Editor)editor).getContinuationIndentSize((FileType)GroovyFileType.GROOVY_FILE_TYPE);
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)StringUtil.repeatSymbol((char)' ', (int)indentSize));
    }

    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            GroovyEnterHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GroovyEnterHandler.$$$reportNull$$$0(1);
        }
        if (caretOffset == null) {
            GroovyEnterHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            GroovyEnterHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            GroovyEnterHandler.$$$reportNull$$$0(4);
        }
        Document document = editor.getDocument();
        Project project = file.getProject();
        CaretModel caretModel = editor.getCaretModel();
        if (!(file instanceof GroovyFileBase)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int docLength = document.getTextLength();
        if (docLength == 0) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int caret = caretModel.getOffset();
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        if (caret >= 1 && caret < docLength && CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER) {
            boolean afterArrow;
            HighlighterIterator iterator2 = highlighter.createIterator(caret);
            iterator2.retreat();
            while (!iterator2.atEnd() && TokenType.WHITE_SPACE == iterator2.getTokenType()) {
                iterator2.retreat();
            }
            boolean bl = afterArrow = !iterator2.atEnd() && iterator2.getTokenType() == GroovyTokenTypes.mCLOSABLE_BLOCK_OP;
            if (afterArrow) {
                originalHandler.execute(editor, dataContext);
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, caretModel.getOffset());
            }
            iterator2 = highlighter.createIterator(caretModel.getOffset());
            while (!iterator2.atEnd() && TokenType.WHITE_SPACE == iterator2.getTokenType()) {
                iterator2.advance();
            }
            if (!iterator2.atEnd() && GroovyTokenTypes.mRCURLY == iterator2.getTokenType()) {
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                PsiElement element = file.findElementAt(iterator2.getStart());
                if (element != null && element.getNode().getElementType() == GroovyTokenTypes.mRCURLY && element.getParent() instanceof GrClosableBlock && docLength > caret && afterArrow) {
                    return EnterHandlerDelegate.Result.DefaultForceIndent;
                }
            }
            if (afterArrow) {
                return EnterHandlerDelegate.Result.Stop;
            }
            if (editor.isInsertMode() && !HandlerUtils.isReadOnly(editor) && !editor.getSelectionModel().hasSelection() && GroovyEnterHandler.handleFlyingGeese(editor, caret, dataContext, originalHandler, file)) {
                return EnterHandlerDelegate.Result.DefaultForceIndent;
            }
        }
        if (GroovyEnterHandler.handleEnter(editor, dataContext, project, originalHandler)) {
            return EnterHandlerDelegate.Result.Stop;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    protected static boolean handleEnter(Editor editor, DataContext dataContext, @NotNull Project project, EditorActionHandler originalHandler) {
        if (project == null) {
            GroovyEnterHandler.$$$reportNull$$$0(5);
        }
        if (HandlerUtils.isReadOnly(editor)) {
            return false;
        }
        int caretOffset = editor.getCaretModel().getOffset();
        if (caretOffset < 1) {
            return false;
        }
        if (GroovyEnterHandler.handleBetweenSquareBraces(editor, caretOffset, dataContext, project, originalHandler)) {
            return true;
        }
        return GroovyEnterHandler.handleInString(editor, caretOffset, dataContext, originalHandler);
    }

    private static boolean handleFlyingGeese(Editor editor, int caretOffset, DataContext dataContext, EditorActionHandler originalHandler, PsiFile file) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        GroovyCodeStyleSettings codeStyleSettings = GroovyCodeStyleSettings.getInstance(editor);
        if (!codeStyleSettings.USE_FLYING_GEESE_BRACES) {
            return false;
        }
        PsiElement element = file.findElementAt(caretOffset);
        if (element != null && element.getNode().getElementType() == TokenType.WHITE_SPACE) {
            element = GeeseUtil.getNextNonWhitespaceToken(element);
        }
        if (element == null || !GeeseUtil.isClosureRBrace(element)) {
            return false;
        }
        if ((element = GeeseUtil.getNextNonWhitespaceToken(element)) == null || element.getNode().getElementType() != GroovyTokenTypes.mNLS || StringUtil.countChars((CharSequence)element.getText(), (char)'\n') > 1) {
            return false;
        }
        if ((element = GeeseUtil.getNextNonWhitespaceToken(element)) == null || !GeeseUtil.isClosureRBrace(element)) {
            return false;
        }
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        int toRemove = element.getTextRange().getStartOffset();
        document.deleteString(caretOffset + 1, toRemove);
        originalHandler.execute(editor, dataContext);
        String text = document.getText();
        int nextLineFeed = text.indexOf(10, caretOffset + 1);
        if (nextLineFeed == -1) {
            nextLineFeed = text.length();
        }
        CodeStyleManager.getInstance((Project)project).reformatText(file, caretOffset, nextLineFeed);
        return true;
    }

    private static boolean handleBetweenSquareBraces(Editor editor, int caret, DataContext context, Project project, EditorActionHandler originalHandler) {
        String text = editor.getDocument().getText();
        if (text == null || text.isEmpty()) {
            return false;
        }
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        if (caret < 1 || caret > text.length() - 1) {
            return false;
        }
        HighlighterIterator iterator2 = highlighter.createIterator(caret - 1);
        if (GroovyTokenTypes.mLBRACK == iterator2.getTokenType() && text.length() > caret && GroovyTokenTypes.mRBRACK == (iterator2 = highlighter.createIterator(caret)).getTokenType()) {
            originalHandler.execute(editor, context);
            originalHandler.execute(editor, context);
            editor.getCaretModel().moveCaretRelatively(0, -1, false, false, true);
            GroovyEnterHandler.insertSpacesByGroovyContinuationIndent(editor, project);
            return true;
        }
        return false;
    }

    private static boolean handleInString(Editor editor, int caretOffset, DataContext dataContext, EditorActionHandler originalHandler) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        VirtualFile vfile = FileDocumentManager.getInstance().getFile(editor.getDocument());
        assert (vfile != null);
        PsiFile file = PsiManager.getInstance((Project)project).findFile(vfile);
        Document document = editor.getDocument();
        String fileText = document.getText();
        if (fileText.length() == caretOffset) {
            return false;
        }
        if (!GroovyEnterHandler.checkStringApplicable(editor, caretOffset)) {
            return false;
        }
        if (file == null) {
            return false;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        PsiElement stringElement = GroovyEnterHandler.inferStringPair(file, caretOffset);
        if (stringElement == null) {
            return false;
        }
        ASTNode node = stringElement.getNode();
        IElementType nodeElementType = node.getElementType();
        boolean isInsertIndent = GroovyEnterHandler.isInsertIndent(caretOffset, stringElement.getTextRange().getStartOffset(), fileText);
        CaretModel caretModel = editor.getCaretModel();
        if (nodeElementType == GroovyTokenTypes.mSTRING_LITERAL) {
            if (GroovyEnterHandler.isSingleQuoteString(stringElement)) {
                if (GroovyEnterHandler.isSlashBeforeCaret(caretOffset, fileText)) {
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"\n");
                } else if (stringElement.getParent() instanceof GrReferenceExpression) {
                    TextRange range = stringElement.getTextRange();
                    GroovyEnterHandler.convertEndToMultiline(range.getEndOffset(), document, fileText, '\'');
                    document.insertString(range.getStartOffset(), (CharSequence)"''");
                    caretModel.moveToOffset(caretOffset + 2);
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"\n");
                } else {
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"'+");
                    originalHandler.execute(editor, dataContext);
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"'");
                    PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                    CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)file, caretOffset, caretModel.getOffset());
                }
            } else {
                GroovyEnterHandler.insertLineFeedInString(editor, dataContext, originalHandler, isInsertIndent);
            }
            return true;
        }
        if (GSTRING_TOKENS.contains(nodeElementType) || nodeElementType == GroovyElementTypes.GSTRING_CONTENT && GSTRING_TOKENS.contains(node.getFirstChildNode().getElementType()) || nodeElementType == GroovyTokenTypes.mDOLLAR && node.getTreeParent().getTreeParent().getElementType() == GroovyElementTypes.GSTRING) {
            PsiElement parent;
            if (nodeElementType == GroovyTokenTypes.mGSTRING_LITERAL) {
                parent = stringElement;
            } else {
                for (parent = stringElement.getParent(); parent != null && !(parent instanceof GrLiteral); parent = parent.getParent()) {
                }
            }
            if (parent == null) {
                return false;
            }
            if (GroovyEnterHandler.isDoubleQuotedString(parent)) {
                boolean rightFromDollar;
                PsiElement exprSibling = stringElement.getNextSibling();
                boolean bl = rightFromDollar = exprSibling instanceof GrExpression && exprSibling.getTextRange().getStartOffset() == caretOffset;
                if (rightFromDollar) {
                    --caretOffset;
                }
                TextRange parentRange = parent.getTextRange();
                if (rightFromDollar || parent.getParent() instanceof GrReferenceExpression) {
                    GroovyEnterHandler.convertEndToMultiline(parent.getTextRange().getEndOffset(), document, fileText, '\"');
                    document.insertString(parentRange.getStartOffset(), (CharSequence)"\"\"");
                    caretModel.moveToOffset(caretOffset + 2);
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"\n");
                    if (rightFromDollar) {
                        caretModel.moveCaretRelatively(1, 0, false, false, true);
                    }
                } else if (GroovyEnterHandler.isSlashBeforeCaret(caretOffset, fileText)) {
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"\n");
                } else {
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"\"+");
                    originalHandler.execute(editor, dataContext);
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"\"");
                    PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                    CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)file, caretOffset, caretModel.getOffset());
                }
            } else {
                GroovyEnterHandler.insertLineFeedInString(editor, dataContext, originalHandler, isInsertIndent);
            }
            return true;
        }
        if (REGEX_TOKENS.contains(nodeElementType) || nodeElementType == GroovyElementTypes.GSTRING_CONTENT && REGEX_TOKENS.contains(node.getFirstChildNode().getElementType()) || nodeElementType == GroovyTokenTypes.mDOLLAR && node.getTreeParent().getTreeParent().getElementType() == GroovyElementTypes.REGEX) {
            boolean rightFromDollar;
            PsiElement parent;
            if (nodeElementType == GroovyTokenTypes.mREGEX_LITERAL || nodeElementType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL) {
                parent = stringElement;
            } else {
                for (parent = stringElement.getParent(); parent != null && !(parent instanceof GrLiteral); parent = parent.getParent()) {
                }
            }
            if (parent == null || parent.getLastChild() instanceof PsiErrorElement) {
                return false;
            }
            PsiElement exprSibling = stringElement.getNextSibling();
            boolean bl = rightFromDollar = exprSibling instanceof GrExpression && exprSibling.getTextRange().getStartOffset() == caretOffset;
            if (rightFromDollar) {
                caretModel.moveToOffset(caretOffset - 1);
            }
            GroovyEnterHandler.insertLineFeedInString(editor, dataContext, originalHandler, isInsertIndent);
            if (rightFromDollar) {
                caretModel.moveCaretRelatively(1, 0, false, false, true);
            }
            return true;
        }
        return false;
    }

    private static boolean isDoubleQuotedString(PsiElement element) {
        return "\"".equals(GrStringUtil.getStartQuote(element.getText()));
    }

    private static boolean isSingleQuoteString(PsiElement element) {
        return "'".equals(GrStringUtil.getStartQuote(element.getText()));
    }

    @Nullable
    private static PsiElement inferStringPair(PsiFile file, int caretOffset) {
        PsiElement stringElement = file.findElementAt(caretOffset - 1);
        if (stringElement == null) {
            return null;
        }
        ASTNode node = stringElement.getNode();
        if (node == null) {
            return null;
        }
        if (!INNER_STRING_TOKENS.contains(node.getElementType()) && GroovyEnterHandler.checkGStringInjection(stringElement) && (stringElement = stringElement.getParent().getParent().getNextSibling()) == null) {
            return null;
        }
        return stringElement;
    }

    private static boolean isSlashBeforeCaret(int caretOffset, String fileText) {
        return caretOffset > 0 && fileText.charAt(caretOffset - 1) == '\\';
    }

    private static void insertLineFeedInString(Editor editor, DataContext dataContext, EditorActionHandler originalHandler, boolean isInsertIndent) {
        if (isInsertIndent) {
            originalHandler.execute(editor, dataContext);
        } else {
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"\n");
        }
    }

    private static boolean isInsertIndent(int caret, int stringOffset, String text) {
        int i = text.indexOf(10, stringOffset);
        return stringOffset < i && i < caret;
    }

    private static void convertEndToMultiline(int caretOffset, Document document, String fileText, char c) {
        if (caretOffset < fileText.length() && fileText.charAt(caretOffset) == c || caretOffset > 0 && fileText.charAt(caretOffset - 1) == c) {
            document.insertString(caretOffset, (CharSequence)new CharArrayCharSequence(new char[]{c, c}));
        } else {
            document.insertString(caretOffset, (CharSequence)new CharArrayCharSequence(new char[]{c, c, c}));
        }
    }

    private static boolean checkStringApplicable(Editor editor, int caret) {
        GroovyLexer lexer = new GroovyLexer();
        lexer.start(editor.getDocument().getText());
        while (lexer.getTokenEnd() < caret) {
            lexer.advance();
        }
        IElementType leftToken = lexer.getTokenType();
        if (lexer.getTokenEnd() <= caret) {
            lexer.advance();
        }
        IElementType rightToken = lexer.getTokenType();
        if (!ALL_STRINGS.contains(leftToken)) {
            return false;
        }
        if (BEFORE_DOLLAR.contains(leftToken) && !AFTER_DOLLAR.contains(rightToken)) {
            return false;
        }
        if (EXPR_END.contains(leftToken) && !AFTER_EXPR_END.contains(rightToken)) {
            return false;
        }
        return !STRING_END.contains(leftToken) || STRING_END.contains(rightToken);
    }

    private static boolean checkGStringInjection(PsiElement element) {
        if (element != null && (element.getParent() instanceof GrReferenceExpression || element.getParent() instanceof GrClosableBlock)) {
            PsiElement parent = element.getParent().getParent();
            if (!(parent instanceof GrStringInjection)) {
                return false;
            }
            PsiElement nextSibling = parent.getNextSibling();
            if (nextSibling == null) {
                return false;
            }
            return INNER_STRING_TOKENS.contains(nextSibling.getNode().getElementType());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/editor/actions/GroovyEnterHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessEnter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "handleEnter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

