/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor;

import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeStyle.GroovyCodeStyleSettings;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyImportUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyImportOptimizer
implements ImportOptimizer {
    public static Comparator<GrImportStatement> getComparator(GroovyCodeStyleSettings settings) {
        return (statement1, statement2) -> {
            String name2;
            if (settings.LAYOUT_STATIC_IMPORTS_SEPARATELY) {
                if (statement1.isStatic() && !statement2.isStatic()) {
                    return 1;
                }
                if (statement2.isStatic() && !statement1.isStatic()) {
                    return -1;
                }
            }
            GrCodeReferenceElement ref1 = statement1.getImportReference();
            GrCodeReferenceElement ref2 = statement2.getImportReference();
            String name1 = ref1 != null ? PsiUtil.getQualifiedReferenceText(ref1) : null;
            String string = name2 = ref2 != null ? PsiUtil.getQualifiedReferenceText(ref2) : null;
            if (name1 == null) {
                return name2 == null ? 0 : -1;
            }
            if (name2 == null) {
                return 1;
            }
            return name1.compareTo(name2);
        };
    }

    @NotNull
    public Runnable processFile(PsiFile file) {
        Runnable runnable = new MyProcessor(file).compute();
        if (runnable == null) {
            GroovyImportOptimizer.$$$reportNull$$$0(0);
        }
        return runnable;
    }

    public boolean supports(PsiFile file) {
        return file instanceof GroovyFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/editor/GroovyImportOptimizer", "processFile"));
    }

    private static class MyProcessor
    implements NotNullComputable<Runnable> {
        private final PsiFile myFile;

        private MyProcessor(PsiFile file) {
            this.myFile = file;
        }

        @NotNull
        public Runnable compute() {
            if (!(this.myFile instanceof GroovyFile)) {
                Runnable runnable = EmptyRunnable.getInstance();
                if (runnable == null) {
                    MyProcessor.$$$reportNull$$$0(0);
                }
                return runnable;
            }
            GroovyFile file = (GroovyFile)this.myFile;
            LinkedHashSet<String> simplyImportedClasses = new LinkedHashSet<String>();
            LinkedHashSet<String> staticallyImportedMembers = new LinkedHashSet<String>();
            HashSet<GrImportStatement> usedImports = new HashSet<GrImportStatement>();
            HashSet<GrImportStatement> unresolvedOnDemandImports = new HashSet<GrImportStatement>();
            LinkedHashSet<String> implicitlyImportedClasses = new LinkedHashSet<String>();
            HashSet<String> innerClasses = new HashSet<String>();
            HashMap aliasImported = ContainerUtil.newHashMap();
            HashMap annotatedImports = ContainerUtil.newHashMap();
            GroovyImportUtil.processFile(this.myFile, simplyImportedClasses, staticallyImportedMembers, usedImports, unresolvedOnDemandImports, implicitlyImportedClasses, innerClasses, aliasImported, annotatedImports);
            List<GrImportStatement> oldImports = PsiUtil.getValidImportStatements(file);
            GrImportStatement[] newImports = this.prepare(usedImports, simplyImportedClasses, staticallyImportedMembers, implicitlyImportedClasses, innerClasses, aliasImported, annotatedImports, unresolvedOnDemandImports);
            if (oldImports.isEmpty() && newImports.length == 0 && aliasImported.isEmpty()) {
                Runnable runnable = EmptyRunnable.getInstance();
                if (runnable == null) {
                    MyProcessor.$$$reportNull$$$0(1);
                }
                return runnable;
            }
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(file.getProject());
            GroovyFile tempFile = factory.createGroovyFile("", false, null);
            for (GrImportStatement newImport : newImports) {
                tempFile.addImport(newImport);
            }
            if (!oldImports.isEmpty()) {
                String oldText;
                int startOffset = oldImports.get(0).getTextRange().getStartOffset();
                int endOffset = oldImports.get(oldImports.size() - 1).getTextRange().getEndOffset();
                String string = oldText = oldImports.isEmpty() ? "" : this.myFile.getText().substring(startOffset, endOffset);
                if (tempFile.getText().trim().equals(oldText)) {
                    Runnable runnable = EmptyRunnable.getInstance();
                    if (runnable == null) {
                        MyProcessor.$$$reportNull$$$0(2);
                    }
                    return runnable;
                }
            }
            Runnable runnable = () -> {
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)file.getProject());
                Document document = documentManager.getDocument((PsiFile)file);
                if (document != null) {
                    documentManager.commitDocument(document);
                }
                List<GrImportStatement> existingImports = PsiUtil.getValidImportStatements(file);
                for (GrImportStatement statement : tempFile.getImportStatements()) {
                    file.addImport(statement);
                }
                for (GrImportStatement importStatement : existingImports) {
                    file.removeImport(importStatement);
                }
            };
            if (runnable == null) {
                MyProcessor.$$$reportNull$$$0(3);
            }
            return runnable;
        }

        private GrImportStatement[] prepare(Set<GrImportStatement> usedImports, Set<String> importedClasses, Set<String> staticallyImportedMembers, Set<String> implicitlyImported, Set<String> innerClasses, Map<String, String> aliased, final Map<String, String> annotations2, Set<GrImportStatement> unresolvedOnDemandImports) {
            Project project = this.myFile.getProject();
            final GroovyCodeStyleSettings settings = GroovyCodeStyleSettings.getInstance(this.myFile);
            final GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
            TObjectIntHashMap packageCountMap = new TObjectIntHashMap();
            TObjectIntHashMap classCountMap = new TObjectIntHashMap();
            for (String importedClass : importedClasses) {
                if (implicitlyImported.contains(importedClass) || innerClasses.contains(importedClass) || aliased.containsKey(importedClass) || annotations2.containsKey(importedClass)) continue;
                String packageName = StringUtil.getPackageName((String)importedClass);
                if (!packageCountMap.containsKey((Object)packageName)) {
                    packageCountMap.put((Object)packageName, 0);
                }
                packageCountMap.increment((Object)packageName);
            }
            for (String importedMember : staticallyImportedMembers) {
                if (aliased.containsKey(importedMember) || annotations2.containsKey(importedMember)) continue;
                String className = StringUtil.getPackageName((String)importedMember);
                if (!classCountMap.containsKey((Object)className)) {
                    classCountMap.put((Object)className, 0);
                }
                classCountMap.increment((Object)className);
            }
            final HashSet onDemandImportedSimpleClassNames = new HashSet();
            final ArrayList<GrImportStatement> result2 = new ArrayList<GrImportStatement>();
            packageCountMap.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>(){

                public boolean execute(String s, int i) {
                    if (i >= settings.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND || settings.PACKAGES_TO_USE_IMPORT_ON_DEMAND.contains(s)) {
                        GrImportStatement imp = factory.createImportStatementFromText(s, false, true, null);
                        String annos = (String)annotations2.remove(s + ".*");
                        if (annos != null) {
                            imp.getAnnotationList().replace(factory.createModifierList(annos));
                        }
                        result2.add(imp);
                        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)myFile.getProject()).findPackage(s);
                        if (aPackage != null) {
                            for (PsiClass clazz : aPackage.getClasses(myFile.getResolveScope())) {
                                onDemandImportedSimpleClassNames.add(clazz.getName());
                            }
                        }
                    }
                    return true;
                }
            });
            classCountMap.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>(){

                public boolean execute(String s, int i) {
                    if (i >= settings.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND) {
                        GrImportStatement imp = factory.createImportStatementFromText(s, true, true, null);
                        String annos = (String)annotations2.remove(s + ".*");
                        if (annos != null) {
                            imp.getAnnotationList().replace(factory.createModifierList(annos));
                        }
                        result2.add(imp);
                    }
                    return true;
                }
            });
            ArrayList explicated = ContainerUtil.newArrayList();
            for (String importedClass : importedClasses) {
                String parentName = StringUtil.getPackageName((String)importedClass);
                if (!annotations2.containsKey(importedClass) && !aliased.containsKey(importedClass) && (packageCountMap.get((Object)parentName) >= settings.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND || settings.PACKAGES_TO_USE_IMPORT_ON_DEMAND.contains(parentName) || implicitlyImported.contains(importedClass) && !onDemandImportedSimpleClassNames.contains(StringUtil.getShortName((String)importedClass)))) continue;
                GrImportStatement imp = factory.createImportStatementFromText(importedClass, false, false, null);
                String annos = annotations2.remove(importedClass);
                if (annos != null) {
                    imp.getAnnotationList().replace(factory.createModifierList(annos));
                }
                explicated.add(imp);
            }
            for (String importedMember : staticallyImportedMembers) {
                String className = StringUtil.getPackageName((String)importedMember);
                if (!annotations2.containsKey(importedMember) && !aliased.containsKey(importedMember) && classCountMap.get((Object)className) >= settings.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND) continue;
                result2.add(factory.createImportStatementFromText(importedMember, true, false, null));
            }
            for (GrImportStatement anImport : usedImports) {
                if (!anImport.isAliasedImport() && !GroovyImportUtil.isAnnotatedImport(anImport)) continue;
                if (GroovyImportUtil.isAnnotatedImport(anImport)) {
                    annotations2.remove(GroovyImportUtil.getImportReferenceText(anImport));
                }
                if (anImport.isStatic()) {
                    result2.add(anImport);
                    continue;
                }
                explicated.add(anImport);
            }
            Comparator<GrImportStatement> comparator = GroovyImportOptimizer.getComparator(settings);
            Collections.sort(result2, comparator);
            Collections.sort(explicated, comparator);
            explicated.addAll(result2);
            if (!annotations2.isEmpty()) {
                StringBuilder allSkippedAnnotations = new StringBuilder();
                for (String anno : annotations2.values()) {
                    allSkippedAnnotations.append(anno).append(' ');
                }
                if (explicated.isEmpty()) {
                    explicated.add(factory.createImportStatementFromText("java.lang.Object", false, false, null));
                }
                GrImportStatement first = (GrImportStatement)explicated.get(0);
                allSkippedAnnotations.append(first.getAnnotationList().getText());
                first.getAnnotationList().replace(factory.createModifierList(allSkippedAnnotations));
            }
            for (GrImportStatement anImport : unresolvedOnDemandImports) {
                explicated.add(anImport);
            }
            return explicated.toArray(GrImportStatement.EMPTY_ARRAY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/editor/GroovyImportOptimizer$MyProcessor", "compute"));
        }
    }
}

