/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.dsl.DslActivationStatus;
import org.jetbrains.plugins.groovy.dsl.GdslUtil;
import org.jetbrains.plugins.groovy.dsl.GroovyDslFileIndex;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.util.GrFileIndexUtil;

public class GroovyDslAnnotator
implements Annotator,
DumbAware {
    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        String error;
        if (psiElement == null) {
            GroovyDslAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            GroovyDslAnnotator.$$$reportNull$$$0(1);
        }
        if (!(psiElement instanceof GroovyFile)) {
            return;
        }
        GroovyFile groovyFile = (GroovyFile)psiElement;
        if (!GrFileIndexUtil.isGroovySourceFile(groovyFile)) {
            return;
        }
        VirtualFile vfile = groovyFile.getVirtualFile();
        if (!GdslUtil.GDSL_FILTER.value((Object)vfile)) {
            return;
        }
        DslActivationStatus.Status status = GroovyDslFileIndex.getStatus(vfile);
        if (status == DslActivationStatus.Status.ACTIVE) {
            return;
        }
        String message = status == DslActivationStatus.Status.MODIFIED ? "DSL descriptor file has been changed and isn't currently executed." : "DSL descriptor file has been disabled due to a processing error.";
        Annotation annotation = holder.createWarningAnnotation(psiElement, message);
        annotation.setFileLevelAnnotation(true);
        if (status == DslActivationStatus.Status.ERROR && (error = GroovyDslFileIndex.getError(vfile)) != null) {
            annotation.registerFix(GroovyQuickFixFactory.getInstance().createInvestigateFix(error));
        }
        annotation.registerFix((IntentionAction)new ActivateFix(vfile));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/dsl/GroovyDslAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ActivateFix
    implements IntentionAction {
        private final VirtualFile myVfile;

        public ActivateFix(VirtualFile vfile) {
            this.myVfile = vfile;
        }

        @NotNull
        public String getText() {
            if ("Activate back" == null) {
                ActivateFix.$$$reportNull$$$0(0);
            }
            return "Activate back";
        }

        @NotNull
        public String getFamilyName() {
            if ("Activate DSL Descriptor" == null) {
                ActivateFix.$$$reportNull$$$0(1);
            }
            return "Activate DSL Descriptor";
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                ActivateFix.$$$reportNull$$$0(2);
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                ActivateFix.$$$reportNull$$$0(3);
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            GroovyDslFileIndex.activate(this.myVfile);
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/dsl/GroovyDslAnnotator$ActivateFix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/dsl/GroovyDslAnnotator$ActivateFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

