/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.console.GroovyConsoleUtil;

@State(name="GroovyConsoleState", storages={@Storage(value="$WORKSPACE_FILE$")})
public class GroovyConsoleStateService
implements PersistentStateComponent<MyState> {
    private final ModuleManager myModuleManager;
    private final VirtualFileManager myFileManager;
    private final Map<VirtualFile, Pair<Module, String>> myFileModuleMap = Collections.synchronizedMap(ContainerUtil.newHashMap());

    public GroovyConsoleStateService(ModuleManager manager, VirtualFileManager fileManager) {
        this.myModuleManager = manager;
        this.myFileManager = fileManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public MyState getState() {
        Map<VirtualFile, Pair<Module, String>> map2 = this.myFileModuleMap;
        // MONITORENTER : map2
        MyState result2 = new MyState();
        Iterator<Map.Entry<VirtualFile, Pair<Module, String>>> iterator2 = this.myFileModuleMap.entrySet().iterator();
        while (true) {
            if (!iterator2.hasNext()) {
                MyState myState = result2;
                // MONITOREXIT : map2
                if (myState != null) return myState;
                GroovyConsoleStateService.$$$reportNull$$$0(0);
                return myState;
            }
            Map.Entry<VirtualFile, Pair<Module, String>> entry = iterator2.next();
            VirtualFile file = entry.getKey();
            Pair<Module, String> pair = entry.getValue();
            Module module = pair == null ? null : (Module)pair.first;
            Entry e = new Entry();
            e.url = file.getUrl();
            e.moduleName = module == null ? "" : module.getName();
            e.title = pair == null ? "" : (String)pair.second;
            result2.list.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull MyState state) {
        if (state == null) {
            GroovyConsoleStateService.$$$reportNull$$$0(1);
        }
        Map<VirtualFile, Pair<Module, String>> map2 = this.myFileModuleMap;
        synchronized (map2) {
            this.myFileModuleMap.clear();
            for (Entry entry : state.list) {
                VirtualFile file;
                if (entry.url == null || (file = this.myFileManager.findFileByUrl(entry.url)) == null) continue;
                String moduleName = entry.moduleName;
                Module module = moduleName == null ? null : this.myModuleManager.findModuleByName(moduleName);
                this.myFileModuleMap.put(file, (Pair<Module, String>)Pair.create((Object)module, (Object)entry.title));
            }
        }
    }

    public boolean isProjectConsole(@NotNull VirtualFile file) {
        if (file == null) {
            GroovyConsoleStateService.$$$reportNull$$$0(2);
        }
        return this.myFileModuleMap.containsKey(file);
    }

    @Nullable
    public Module getSelectedModule(@NotNull VirtualFile file) {
        Pair<Module, String> pair;
        if (file == null) {
            GroovyConsoleStateService.$$$reportNull$$$0(3);
        }
        return (pair = this.myFileModuleMap.get(file)) == null ? null : (Module)pair.first;
    }

    @Nullable
    public String getSelectedModuleTitle(@NotNull VirtualFile file) {
        Pair<Module, String> pair;
        if (file == null) {
            GroovyConsoleStateService.$$$reportNull$$$0(4);
        }
        return (pair = this.myFileModuleMap.get(file)) == null ? null : (String)pair.second;
    }

    public void setFileModule(@NotNull VirtualFile file, @NotNull Module module) {
        if (file == null) {
            GroovyConsoleStateService.$$$reportNull$$$0(5);
        }
        if (module == null) {
            GroovyConsoleStateService.$$$reportNull$$$0(6);
        }
        this.myFileModuleMap.put(file, (Pair<Module, String>)Pair.create((Object)module, (Object)GroovyConsoleUtil.getTitle(module)));
    }

    @NotNull
    public static GroovyConsoleStateService getInstance(@NotNull Project project) {
        if (project == null) {
            GroovyConsoleStateService.$$$reportNull$$$0(7);
        }
        GroovyConsoleStateService groovyConsoleStateService = (GroovyConsoleStateService)ServiceManager.getService((Project)project, GroovyConsoleStateService.class);
        if (groovyConsoleStateService == null) {
            GroovyConsoleStateService.$$$reportNull$$$0(8);
        }
        return groovyConsoleStateService;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/console/GroovyConsoleStateService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/console/GroovyConsoleStateService";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isProjectConsole";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedModule";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedModuleTitle";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setFileModule";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyState {
        public Collection<Entry> list = ContainerUtil.newArrayList();
    }

    public static class Entry {
        @Nullable
        public String url;
        @Nullable
        public String moduleName;
        @Nullable
        public String title;
    }
}

