/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.metrics.GroovyMethodMetricInspection;
import org.jetbrains.plugins.groovy.codeInspection.metrics.NestingDepthVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyOverlyNestedMethodInspectionBase
extends GroovyMethodMetricInspection {
    public GroovyOverlyNestedMethodInspectionBase() {
        super(5);
    }

    @NotNull
    public String getDisplayName() {
        if ("Overly nested method" == null) {
            GroovyOverlyNestedMethodInspectionBase.$$$reportNull$$$0(0);
        }
        return "Overly nested method";
    }

    @Override
    public String buildErrorString(Object ... args) {
        return "Method '#ref' is overly nested ( nesting depth =" + args[0] + '>' + args[1] + ')';
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor2 = new Visitor();
        if (visitor2 == null) {
            GroovyOverlyNestedMethodInspectionBase.$$$reportNull$$$0(1);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyOverlyNestedMethodInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitMethod(@NotNull GrMethod grMethod) {
            if (grMethod == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(grMethod);
            int limit = GroovyOverlyNestedMethodInspectionBase.this.getLimit();
            NestingDepthVisitor visitor2 = new NestingDepthVisitor();
            GrOpenBlock body = grMethod.getBlock();
            if (body == null) {
                return;
            }
            body.accept(visitor2);
            int nestingDepth = visitor2.getMaximumDepth();
            if (nestingDepth <= limit) {
                return;
            }
            this.registerMethodError(grMethod, nestingDepth, limit);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grMethod", "org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyOverlyNestedMethodInspectionBase$Visitor", "visitMethod"));
        }
    }
}

