/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

class CyclomaticComplexityVisitor
extends GroovyRecursiveElementVisitor {
    private int complexity = 1;

    CyclomaticComplexityVisitor() {
    }

    @Override
    public void visitElement(@NotNull GroovyPsiElement GrElement) {
        if (GrElement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(0);
        }
        int oldComplexity = 0;
        if (GrElement instanceof GrMethod) {
            oldComplexity = this.complexity;
        }
        super.visitElement(GrElement);
        if (GrElement instanceof GrMethod) {
            this.complexity = oldComplexity;
        }
    }

    @Override
    public void visitForStatement(@NotNull GrForStatement statement) {
        if (statement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(1);
        }
        super.visitForStatement(statement);
        ++this.complexity;
    }

    @Override
    public void visitIfStatement(@NotNull GrIfStatement statement) {
        if (statement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(2);
        }
        super.visitIfStatement(statement);
        ++this.complexity;
    }

    @Override
    public void visitConditionalExpression(@NotNull GrConditionalExpression expression) {
        if (expression == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(3);
        }
        super.visitConditionalExpression(expression);
        ++this.complexity;
    }

    @Override
    public void visitSwitchStatement(@NotNull GrSwitchStatement statement) {
        GrCaseSection[] caseClauses;
        if (statement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(4);
        }
        super.visitSwitchStatement(statement);
        for (GrCaseSection clause : caseClauses = statement.getCaseSections()) {
            GrStatement[] statements = clause.getStatements();
            if (statements == null || statements.length == 0) continue;
            ++this.complexity;
        }
    }

    @Override
    public void visitWhileStatement(@NotNull GrWhileStatement statement) {
        if (statement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(5);
        }
        super.visitWhileStatement(statement);
        ++this.complexity;
    }

    public int getComplexity() {
        return this.complexity;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "GrElement";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/metrics/CyclomaticComplexityVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitForStatement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitIfStatement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitConditionalExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSwitchStatement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitWhileStatement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

