/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.control.ConditionalUtils;
import org.jetbrains.plugins.groovy.codeInspection.utils.BoolUtils;
import org.jetbrains.plugins.groovy.codeInspection.utils.EquivalenceChecker;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GroovyTrivialIfInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        if ("Redundant 'if' statement" == null) {
            GroovyTrivialIfInspection.$$$reportNull$$$0(0);
        }
        return "Redundant 'if' statement";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        TrivialIfVisitor trivialIfVisitor = new TrivialIfVisitor();
        if (trivialIfVisitor == null) {
            GroovyTrivialIfInspection.$$$reportNull$$$0(1);
        }
        return trivialIfVisitor;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public String buildErrorString(Object ... args) {
        return "#ref statement can be simplified #loc";
    }

    @Override
    public GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyTrivialIfInspection.$$$reportNull$$$0(2);
        }
        return new TrivialIfFix();
    }

    public static boolean isSimplifiableImplicitReturn(GrIfStatement ifStatement) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        GrStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        PsiElement nextStatement = PsiTreeUtil.skipWhitespacesForward((PsiElement)ifStatement);
        if (!(nextStatement instanceof GrStatement)) {
            return false;
        }
        GrStatement elseBranch = (GrStatement)nextStatement;
        return ConditionalUtils.isReturn(thenBranch, "true") && ConditionalUtils.isReturn(elseBranch, "false");
    }

    public static boolean isSimplifiableImplicitReturnNegated(GrIfStatement ifStatement) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        GrStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        PsiElement nextStatement = PsiTreeUtil.skipWhitespacesForward((PsiElement)ifStatement);
        if (!(nextStatement instanceof GrStatement)) {
            return false;
        }
        GrStatement elseBranch = (GrStatement)nextStatement;
        return ConditionalUtils.isReturn(thenBranch, "false") && ConditionalUtils.isReturn(elseBranch, "true");
    }

    public static boolean isSimplifiableReturn(GrIfStatement ifStatement) {
        GrStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        GrStatement elseBranch = ifStatement.getElseBranch();
        elseBranch = ConditionalUtils.stripBraces(elseBranch);
        return ConditionalUtils.isReturn(thenBranch, "true") && ConditionalUtils.isReturn(elseBranch, "false");
    }

    public static boolean isSimplifiableReturnNegated(GrIfStatement ifStatement) {
        GrStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        GrStatement elseBranch = ifStatement.getElseBranch();
        elseBranch = ConditionalUtils.stripBraces(elseBranch);
        return ConditionalUtils.isReturn(thenBranch, "false") && ConditionalUtils.isReturn(elseBranch, "true");
    }

    public static boolean isSimplifiableAssignment(GrIfStatement ifStatement) {
        GrStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        GrStatement elseBranch = ifStatement.getElseBranch();
        elseBranch = ConditionalUtils.stripBraces(elseBranch);
        if (ConditionalUtils.isAssignment(thenBranch, "true") && ConditionalUtils.isAssignment(elseBranch, "false")) {
            IElementType elseSign;
            GrAssignmentExpression thenExpression = (GrAssignmentExpression)thenBranch;
            GrAssignmentExpression elseExpression = (GrAssignmentExpression)elseBranch;
            IElementType thenSign = thenExpression.getOperationTokenType();
            if (!thenSign.equals(elseSign = elseExpression.getOperationTokenType())) {
                return false;
            }
            GrExpression thenLhs = thenExpression.getLValue();
            GrExpression elseLhs = elseExpression.getLValue();
            return EquivalenceChecker.expressionsAreEquivalent(thenLhs, elseLhs);
        }
        return false;
    }

    public static boolean isSimplifiableAssignmentNegated(GrIfStatement ifStatement) {
        GrStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        GrStatement elseBranch = ifStatement.getElseBranch();
        elseBranch = ConditionalUtils.stripBraces(elseBranch);
        if (ConditionalUtils.isAssignment(thenBranch, "false") && ConditionalUtils.isAssignment(elseBranch, "true")) {
            IElementType elseSign;
            GrAssignmentExpression thenExpression = (GrAssignmentExpression)thenBranch;
            GrAssignmentExpression elseExpression = (GrAssignmentExpression)elseBranch;
            IElementType thenSign = thenExpression.getOperationTokenType();
            if (!thenSign.equals(elseSign = elseExpression.getOperationTokenType())) {
                return false;
            }
            GrExpression thenLhs = thenExpression.getLValue();
            GrExpression elseLhs = elseExpression.getLValue();
            return EquivalenceChecker.expressionsAreEquivalent(thenLhs, elseLhs);
        }
        return false;
    }

    public static boolean isSimplifiableImplicitAssignment(GrIfStatement ifStatement) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        GrStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        PsiElement nextStatement = PsiTreeUtil.skipWhitespacesBackward((PsiElement)ifStatement);
        if (!(nextStatement instanceof GrStatement)) {
            return false;
        }
        GrStatement elseBranch = (GrStatement)nextStatement;
        elseBranch = ConditionalUtils.stripBraces(elseBranch);
        if (ConditionalUtils.isAssignment(thenBranch, "true") && ConditionalUtils.isAssignment(elseBranch, "false")) {
            IElementType elseSign;
            GrAssignmentExpression thenExpression = (GrAssignmentExpression)thenBranch;
            GrAssignmentExpression elseExpression = (GrAssignmentExpression)elseBranch;
            IElementType thenSign = thenExpression.getOperationTokenType();
            if (!thenSign.equals(elseSign = elseExpression.getOperationTokenType())) {
                return false;
            }
            GrExpression thenLhs = thenExpression.getLValue();
            GrExpression elseLhs = elseExpression.getLValue();
            return EquivalenceChecker.expressionsAreEquivalent(thenLhs, elseLhs);
        }
        return false;
    }

    public static boolean isSimplifiableImplicitAssignmentNegated(GrIfStatement ifStatement) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        GrStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        PsiElement nextStatement = PsiTreeUtil.skipWhitespacesBackward((PsiElement)ifStatement);
        if (!(nextStatement instanceof GrStatement)) {
            return false;
        }
        GrStatement elseBranch = (GrStatement)nextStatement;
        elseBranch = ConditionalUtils.stripBraces(elseBranch);
        if (ConditionalUtils.isAssignment(thenBranch, "false") && ConditionalUtils.isAssignment(elseBranch, "true")) {
            IElementType elseSign;
            GrAssignmentExpression thenExpression = (GrAssignmentExpression)thenBranch;
            GrAssignmentExpression elseExpression = (GrAssignmentExpression)elseBranch;
            IElementType thenSign = thenExpression.getOperationTokenType();
            if (!thenSign.equals(elseSign = elseExpression.getOperationTokenType())) {
                return false;
            }
            GrExpression thenLhs = thenExpression.getLValue();
            GrExpression elseLhs = elseExpression.getLValue();
            return EquivalenceChecker.expressionsAreEquivalent(thenLhs, elseLhs);
        }
        return false;
    }

    @NonNls
    private static String getTextForOperator(IElementType operator) {
        if (operator.equals(GroovyTokenTypes.mASSIGN)) {
            return "=";
        }
        if (operator.equals(GroovyTokenTypes.mNOT_EQUAL)) {
            return "!=";
        }
        if (operator.equals(GroovyTokenTypes.mLE)) {
            return "<=";
        }
        if (operator.equals(GroovyTokenTypes.mGE)) {
            return ">=";
        }
        if (operator.equals(GroovyTokenTypes.mLT)) {
            return "<=";
        }
        if (operator.equals(GroovyTokenTypes.mGT)) {
            return ">=";
        }
        if (operator.equals(GroovyTokenTypes.mELVIS)) {
            return "==";
        }
        if (operator.equals(GroovyTokenTypes.mPLUS_ASSIGN)) {
            return "+=";
        }
        if (operator.equals(GroovyTokenTypes.mMINUS_ASSIGN)) {
            return "-=";
        }
        if (operator.equals(GroovyTokenTypes.mSTAR_ASSIGN)) {
            return "*=";
        }
        if (operator.equals(GroovyTokenTypes.mDIV_ASSIGN)) {
            return "/=";
        }
        if (operator.equals(GroovyTokenTypes.mMOD_ASSIGN)) {
            return "%=";
        }
        if (operator.equals(GroovyTokenTypes.mBXOR_ASSIGN)) {
            return "^=";
        }
        if (operator.equals(GroovyTokenTypes.mBAND_ASSIGN)) {
            return "&=";
        }
        if (operator.equals(GroovyTokenTypes.mBOR_ASSIGN)) {
            return "|=";
        }
        return "unknown";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyTrivialIfInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyTrivialIfInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TrivialIfVisitor
    extends BaseInspectionVisitor {
        private TrivialIfVisitor() {
        }

        @Override
        public void visitIfStatement(@NotNull GrIfStatement ifStatement) {
            if (ifStatement == null) {
                TrivialIfVisitor.$$$reportNull$$$0(0);
            }
            super.visitIfStatement(ifStatement);
            GrExpression condition = ifStatement.getCondition();
            if (condition == null) {
                return;
            }
            PsiType type = condition.getType();
            if (type == null || !PsiType.BOOLEAN.isAssignableFrom(type)) {
                return;
            }
            if (GroovyTrivialIfInspection.isSimplifiableAssignment(ifStatement)) {
                this.registerStatementError(ifStatement, new Object[0]);
                return;
            }
            if (GroovyTrivialIfInspection.isSimplifiableReturn(ifStatement)) {
                this.registerStatementError(ifStatement, new Object[0]);
                return;
            }
            if (GroovyTrivialIfInspection.isSimplifiableImplicitReturn(ifStatement)) {
                this.registerStatementError(ifStatement, new Object[0]);
                return;
            }
            if (GroovyTrivialIfInspection.isSimplifiableAssignmentNegated(ifStatement)) {
                this.registerStatementError(ifStatement, new Object[0]);
                return;
            }
            if (GroovyTrivialIfInspection.isSimplifiableReturnNegated(ifStatement)) {
                this.registerStatementError(ifStatement, new Object[0]);
                return;
            }
            if (GroovyTrivialIfInspection.isSimplifiableImplicitReturnNegated(ifStatement)) {
                this.registerStatementError(ifStatement, new Object[0]);
                return;
            }
            if (GroovyTrivialIfInspection.isSimplifiableImplicitAssignment(ifStatement)) {
                this.registerStatementError(ifStatement, new Object[0]);
                return;
            }
            if (GroovyTrivialIfInspection.isSimplifiableImplicitAssignmentNegated(ifStatement)) {
                this.registerStatementError(ifStatement, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyTrivialIfInspection$TrivialIfVisitor", "visitIfStatement"));
        }
    }

    private static class TrivialIfFix
    extends GroovyFix {
        private TrivialIfFix() {
        }

        @NotNull
        public String getFamilyName() {
            if ("Simplify" == null) {
                TrivialIfFix.$$$reportNull$$$0(0);
            }
            return "Simplify";
        }

        @Override
        public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement ifKeywordElement;
            GrIfStatement statement;
            if (project == null) {
                TrivialIfFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                TrivialIfFix.$$$reportNull$$$0(2);
            }
            if (GroovyTrivialIfInspection.isSimplifiableAssignment(statement = (GrIfStatement)(ifKeywordElement = descriptor2.getPsiElement()).getParent())) {
                TrivialIfFix.replaceSimplifiableAssignment(statement);
            } else if (GroovyTrivialIfInspection.isSimplifiableReturn(statement)) {
                TrivialIfFix.repaceSimplifiableReturn(statement);
            } else if (GroovyTrivialIfInspection.isSimplifiableImplicitReturn(statement)) {
                TrivialIfFix.replaceSimplifiableImplicitReturn(statement);
            } else if (GroovyTrivialIfInspection.isSimplifiableAssignmentNegated(statement)) {
                TrivialIfFix.replaceSimplifiableAssignmentNegated(statement);
            } else if (GroovyTrivialIfInspection.isSimplifiableReturnNegated(statement)) {
                TrivialIfFix.repaceSimplifiableReturnNegated(statement);
            } else if (GroovyTrivialIfInspection.isSimplifiableImplicitReturnNegated(statement)) {
                TrivialIfFix.replaceSimplifiableImplicitReturnNegated(statement);
            } else if (GroovyTrivialIfInspection.isSimplifiableImplicitAssignment(statement)) {
                TrivialIfFix.replaceSimplifiableImplicitAssignment(statement);
            } else if (GroovyTrivialIfInspection.isSimplifiableImplicitAssignmentNegated(statement)) {
                TrivialIfFix.replaceSimplifiableImplicitAssignmentNegated(statement);
            }
        }

        private static void replaceSimplifiableImplicitReturn(GrIfStatement statement) throws IncorrectOperationException {
            GrExpression condition = statement.getCondition();
            String conditionText = condition.getText();
            PsiElement nextStatement = PsiTreeUtil.skipWhitespacesForward((PsiElement)statement);
            String newStatement = "return " + conditionText + ';';
            TrivialIfFix.replaceStatement((GrStatement)statement, newStatement);
            assert (nextStatement != null);
            nextStatement.delete();
        }

        private static void repaceSimplifiableReturn(GrIfStatement statement) throws IncorrectOperationException {
            GrExpression condition = statement.getCondition();
            String conditionText = condition.getText();
            String newStatement = "return " + conditionText + ';';
            TrivialIfFix.replaceStatement((GrStatement)statement, newStatement);
        }

        private static void replaceSimplifiableAssignment(GrIfStatement statement) throws IncorrectOperationException {
            GrExpression condition = statement.getCondition();
            String conditionText = condition.getText();
            GrStatement thenBranch = statement.getThenBranch();
            GrAssignmentExpression assignmentExpression = (GrAssignmentExpression)ConditionalUtils.stripBraces(thenBranch);
            IElementType operator = assignmentExpression.getOperationTokenType();
            String operatorText = GroovyTrivialIfInspection.getTextForOperator(operator);
            GrExpression lhs = assignmentExpression.getLValue();
            String lhsText = lhs.getText();
            TrivialIfFix.replaceStatement((GrStatement)statement, lhsText + operatorText + conditionText + ';');
        }

        private static void replaceSimplifiableImplicitAssignment(GrIfStatement statement) throws IncorrectOperationException {
            PsiElement prevStatement = PsiTreeUtil.skipWhitespacesBackward((PsiElement)statement);
            if (prevStatement == null) {
                return;
            }
            GrExpression condition = statement.getCondition();
            String conditionText = condition.getText();
            GrStatement thenBranch = statement.getThenBranch();
            GrAssignmentExpression assignmentExpression = (GrAssignmentExpression)ConditionalUtils.stripBraces(thenBranch);
            IElementType operator = assignmentExpression.getOperationTokenType();
            GrExpression lhs = assignmentExpression.getLValue();
            String lhsText = lhs.getText();
            TrivialIfFix.replaceStatement((GrStatement)statement, lhsText + operator + conditionText + ';');
            prevStatement.delete();
        }

        private static void replaceSimplifiableImplicitAssignmentNegated(GrIfStatement statement) throws IncorrectOperationException {
            PsiElement prevStatement = PsiTreeUtil.skipWhitespacesBackward((PsiElement)statement);
            GrExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            String conditionText = BoolUtils.getNegatedExpressionText(condition);
            GrStatement thenBranch = statement.getThenBranch();
            GrAssignmentExpression assignmentExpression = (GrAssignmentExpression)ConditionalUtils.stripBraces(thenBranch);
            IElementType operator = assignmentExpression.getOperationTokenType();
            String operatorText = GroovyTrivialIfInspection.getTextForOperator(operator);
            GrExpression lhs = assignmentExpression.getLValue();
            String lhsText = lhs.getText();
            TrivialIfFix.replaceStatement((GrStatement)statement, lhsText + operatorText + conditionText + ';');
            assert (prevStatement != null);
            prevStatement.delete();
        }

        private static void replaceSimplifiableImplicitReturnNegated(GrIfStatement statement) throws IncorrectOperationException {
            GrExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            String conditionText = BoolUtils.getNegatedExpressionText(condition);
            PsiElement nextStatement = PsiTreeUtil.skipWhitespacesForward((PsiElement)statement);
            if (nextStatement == null) {
                return;
            }
            String newStatement = "return " + conditionText + ';';
            TrivialIfFix.replaceStatement((GrStatement)statement, newStatement);
            nextStatement.delete();
        }

        private static void repaceSimplifiableReturnNegated(GrIfStatement statement) throws IncorrectOperationException {
            GrExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            String conditionText = BoolUtils.getNegatedExpressionText(condition);
            String newStatement = "return " + conditionText + ';';
            TrivialIfFix.replaceStatement((GrStatement)statement, newStatement);
        }

        private static void replaceSimplifiableAssignmentNegated(GrIfStatement statement) throws IncorrectOperationException {
            GrExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            String conditionText = BoolUtils.getNegatedExpressionText(condition);
            GrStatement thenBranch = statement.getThenBranch();
            GrAssignmentExpression assignmentExpression = (GrAssignmentExpression)ConditionalUtils.stripBraces(thenBranch);
            IElementType operator = assignmentExpression.getOperationTokenType();
            String operatorText = GroovyTrivialIfInspection.getTextForOperator(operator);
            GrExpression lhs = assignmentExpression.getLValue();
            String lhsText = lhs.getText();
            TrivialIfFix.replaceStatement((GrStatement)statement, lhsText + operatorText + conditionText + ';');
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyTrivialIfInspection$TrivialIfFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyTrivialIfInspection$TrivialIfFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

