/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ParamInfo;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicElementSettings;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class QuickfixUtil {
    @Nullable
    public static PsiClass findTargetClass(GrReferenceExpression refExpr, boolean compileStatic) {
        PsiType classType;
        if (refExpr.getQualifier() == null) {
            return PsiUtil.getContextClass(refExpr);
        }
        PsiType type = PsiImplUtil.getQualifierType(refExpr);
        if (type == null && compileStatic) {
            return JavaPsiFacade.getInstance((Project)refExpr.getProject()).findClass("java.lang.Object", refExpr.getResolveScope());
        }
        if (ResolveUtil.resolvesToClass(refExpr.getQualifierExpression()) && (classType = ResolveUtil.unwrapClassType(type)) != null) {
            type = classType;
        }
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        return ((PsiClassType)type).resolve();
    }

    public static boolean isStaticCall(GrReferenceExpression refExpr) {
        GrExpression qualifierExpression = refExpr.getQualifierExpression();
        if (!(qualifierExpression instanceof GrReferenceExpression)) {
            return false;
        }
        GrReferenceExpression referenceExpression = (GrReferenceExpression)qualifierExpression;
        GroovyPsiElement resolvedElement = ResolveUtil.resolveProperty(referenceExpression, referenceExpression.getReferenceName());
        if (resolvedElement == null) {
            return false;
        }
        return resolvedElement instanceof PsiClass;
    }

    public static List<ParamInfo> swapArgumentsAndTypes(String[] names, PsiType[] types) {
        ArrayList<ParamInfo> result2 = new ArrayList<ParamInfo>();
        if (names.length != types.length) {
            return Collections.emptyList();
        }
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            PsiType type = types[i];
            result2.add(new ParamInfo(name, type.getCanonicalText()));
        }
        return result2;
    }

    public static String[] getArgumentsTypes(List<ParamInfo> listOfPairs) {
        ArrayList<String> result2 = new ArrayList<String>();
        if (listOfPairs == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        for (ParamInfo listOfPair : listOfPairs) {
            String type = PsiTypesUtil.unboxIfPossible((String)listOfPair.type);
            result2.add(type);
        }
        return ArrayUtil.toStringArray(result2);
    }

    public static String[] getArgumentsNames(List<ParamInfo> listOfPairs) {
        ArrayList<String> result2 = new ArrayList<String>();
        for (ParamInfo listOfPair : listOfPairs) {
            String name = listOfPair.name;
            result2.add(name);
        }
        return ArrayUtil.toStringArray(result2);
    }

    public static String shortenType(String typeText) {
        if (typeText == null) {
            return "";
        }
        int i = typeText.lastIndexOf(".");
        if (i != -1) {
            return typeText.substring(i + 1);
        }
        return typeText;
    }

    public static DynamicElementSettings createSettings(GrReferenceExpression referenceExpression) {
        DynamicElementSettings settings = new DynamicElementSettings();
        PsiClass containingClass = QuickfixUtil.findTargetClass(referenceExpression, false);
        assert (containingClass != null);
        String className = containingClass.getQualifiedName();
        String string = className = className == null ? containingClass.getContainingFile().getName() : className;
        if (QuickfixUtil.isStaticCall(referenceExpression)) {
            settings.setStatic(true);
        }
        settings.setContainingClassName(className);
        settings.setName(referenceExpression.getReferenceName());
        if (PsiUtil.isCall(referenceExpression)) {
            ArrayList<PsiType> unboxedTypes = new ArrayList<PsiType>();
            for (PsiType type : PsiUtil.getArgumentTypes(referenceExpression, false)) {
                unboxedTypes.add(TypesUtil.unboxPrimitiveTypeWrapperAndEraseGenerics(type));
            }
            PsiType[] types = unboxedTypes.toArray(PsiType.createArray((int)unboxedTypes.size()));
            String[] names = GroovyNamesUtil.getMethodArgumentsNames(referenceExpression.getProject(), types);
            List<ParamInfo> infos = QuickfixUtil.swapArgumentsAndTypes(names, types);
            settings.setMethod(true);
            settings.setParams(infos);
        } else {
            settings.setMethod(false);
        }
        return settings;
    }

    public static DynamicElementSettings createSettings(GrArgumentLabel label, PsiClass targetClass) {
        DynamicElementSettings settings = new DynamicElementSettings();
        assert (targetClass != null);
        String className = targetClass.getQualifiedName();
        className = className == null ? targetClass.getContainingFile().getName() : className;
        settings.setContainingClassName(className);
        settings.setName(label.getName());
        return settings;
    }
}

