/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.UtilKt;
import org.jetbrains.plugins.groovy.codeInspection.bugs.GrRemoveModifierFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/GroovyAnnotator30;", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyElementVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "(Lcom/intellij/lang/annotation/AnnotationHolder;)V", "checkDefaultModifier", "", "modifierList", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/GrModifierList;", "visitModifierList", "intellij.groovy.psi"})
public final class GroovyAnnotator30
extends GroovyElementVisitor {
    private final AnnotationHolder holder;

    @Override
    public void visitModifierList(@NotNull GrModifierList modifierList) {
        Intrinsics.checkParameterIsNotNull((Object)modifierList, (String)"modifierList");
        this.checkDefaultModifier(modifierList);
    }

    private final void checkDefaultModifier(GrModifierList modifierList) {
        block5: {
            Annotation annotation;
            PsiElement modifier;
            block4: {
                PsiElement psiElement = modifierList.getModifier("default");
                if (psiElement == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"modifierList.getModifier\u2026difier.DEFAULT) ?: return");
                modifier = psiElement;
                PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)modifier, PsiClass.class);
                if (psiClass == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"PsiTreeUtil.getParentOfT\u2026ss::class.java) ?: return");
                PsiClass parentClass = psiClass;
                if (!parentClass.isInterface()) break block4;
                PsiClass psiClass2 = parentClass;
                if (!(psiClass2 instanceof GrTypeDefinition)) {
                    psiClass2 = null;
                }
                GrTypeDefinition grTypeDefinition = (GrTypeDefinition)psiClass2;
                if (grTypeDefinition == null) break block5;
                if (!grTypeDefinition.isTrait()) break block5;
            }
            Annotation annotation2 = annotation = this.holder.createWarningAnnotation(modifier, GroovyBundle.message("illegal.default.modifier", new Object[0]));
            Intrinsics.checkExpressionValueIsNotNull((Object)annotation2, (String)"annotation");
            UtilKt.registerFix(annotation2, (LocalQuickFix)new GrRemoveModifierFix("default", GroovyBundle.message("illegal.default.modifier.fix", new Object[0])), modifier);
        }
    }

    public GroovyAnnotator30(@NotNull AnnotationHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        this.holder = holder;
    }
}

