/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.application;

import com.intellij.cvsSupport2.application.CvsStorageComponent;
import com.intellij.cvsSupport2.application.DeleteHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;

public class DeletedCVSDirectoryStorage {
    private final File myRoot;
    public static final String CVS_ADMIN_DIR = "CVS";
    private final Collection<VirtualFile> myFilesToDelete = new HashSet<VirtualFile>();

    public DeletedCVSDirectoryStorage(File root) {
        this.myRoot = root;
    }

    public static boolean isAdminDir(File subdirectory) {
        return subdirectory.getName().equals(CVS_ADMIN_DIR);
    }

    public static boolean isAdminDir(VirtualFile file) {
        if (!file.isDirectory()) {
            return false;
        }
        return file.getName().equals(CVS_ADMIN_DIR);
    }

    public void checkNeedForPurge(File file) {
        File[] subdirectories;
        if (!file.isDirectory()) {
            return;
        }
        for (File subdirectory : subdirectories = file.listFiles(FileUtilRt.ALL_DIRECTORIES)) {
            this.checkNeedForPurge(subdirectory);
        }
        File savedCopy = this.translatePath(file);
        if (DeletedCVSDirectoryStorage.canDeleteSavedCopy(file, savedCopy)) {
            FileUtil.delete((File)savedCopy);
        }
    }

    public File translatePath(File file) {
        return this.translatePath(file.getAbsolutePath());
    }

    private File translatePath(String path) {
        return new File(this.myRoot, path.replace(':', '_'));
    }

    public File alternatePath(File file) {
        return this.gotControlOver(file) ? this.translatePath(file) : file;
    }

    private boolean gotControlOver(File file) {
        return !file.exists() && (this.contains(file) || this.containsCvsDirFor(file));
    }

    public boolean contains(File file) {
        return this.translatePath(file).exists();
    }

    private boolean containsCvsDirFor(File file) {
        return this.translatePath(new File(file.getParentFile(), CVS_ADMIN_DIR)).exists();
    }

    private static boolean canDeleteSavedCopy(File original, File copy) {
        File[] savedFiles = copy.listFiles();
        if (savedFiles == null) {
            savedFiles = new File[]{};
        }
        for (File savedFile : savedFiles) {
            if (new File(original, savedFile.getName()).exists()) continue;
            return false;
        }
        return true;
    }

    public synchronized void deleteIfAdminDirCreated(VirtualFile file) {
        if (DeletedCVSDirectoryStorage.isAdminDir(file)) {
            this.myFilesToDelete.add(file);
        } else if (file.isDirectory()) {
            VirtualFile[] children;
            for (VirtualFile child : children = file.getChildren()) {
                this.deleteIfAdminDirCreated(child);
            }
        }
    }

    public DeleteHandler createDeleteHandler(Project project, CvsStorageComponent cvsStorageComponent) {
        return new DeleteHandler(project, cvsStorageComponent);
    }
}

