/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.lang.ant.dom.AntDomElement;
import com.intellij.lang.ant.dom.AntDomInclude;
import com.intellij.lang.ant.dom.AntDomRecursiveVisitor;
import com.intellij.lang.ant.dom.PropertyResolver;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class AntDomPattern
extends AntDomRecursiveVisitor {
    private static final List<Pattern> ourDefaultExcludes = new ArrayList<Pattern>(AntDomPattern.getDefaultExcludes(true));
    private static final List<Pattern> ourCaseInsensitiveDefaultExcludes = new ArrayList<Pattern>(AntDomPattern.getDefaultExcludes(false));
    private final boolean myCaseSensitive;
    private static final String ourSeparatorPattern = Pattern.quote("/");
    private final List<Pattern> myIncludePatterns = new ArrayList<Pattern>();
    private final List<Pattern> myExcludePatterns = new ArrayList<Pattern>();
    private final List<PrefixItem[]> myCouldBeIncludedPatterns = new ArrayList<PrefixItem[]>();

    private static List<Pattern> getDefaultExcludes(boolean caseSensitive) {
        return Arrays.asList(AntDomPattern.convertToRegexPattern("**/*~", caseSensitive), AntDomPattern.convertToRegexPattern("**/#*#", caseSensitive), AntDomPattern.convertToRegexPattern("**/.#*", caseSensitive), AntDomPattern.convertToRegexPattern("**/%*%", caseSensitive), AntDomPattern.convertToRegexPattern("**/._*", caseSensitive), AntDomPattern.convertToRegexPattern("**/CVS", caseSensitive), AntDomPattern.convertToRegexPattern("**/CVS/**", caseSensitive), AntDomPattern.convertToRegexPattern("**/.cvsignore", caseSensitive), AntDomPattern.convertToRegexPattern("**/SCCS", caseSensitive), AntDomPattern.convertToRegexPattern("**/SCCS/**", caseSensitive), AntDomPattern.convertToRegexPattern("**/vssver.scc", caseSensitive), AntDomPattern.convertToRegexPattern("**/.svn", caseSensitive), AntDomPattern.convertToRegexPattern("**/.svn/**", caseSensitive), AntDomPattern.convertToRegexPattern("**/_svn", caseSensitive), AntDomPattern.convertToRegexPattern("**/_svn/**", caseSensitive), AntDomPattern.convertToRegexPattern("**/.DS_Store", caseSensitive));
    }

    AntDomPattern(boolean caseSensitive) {
        this.myCaseSensitive = caseSensitive;
    }

    public boolean hasIncludePatterns() {
        return this.myIncludePatterns.size() > 0;
    }

    @Override
    public void visitAntDomElement(AntDomElement element) {
        AntDomElement referred;
        String value;
        if ("include".equals(element.getXmlElementName()) && !(element instanceof AntDomInclude)) {
            if (AntDomPattern.isEnabled(element) && (value = AntDomPattern.getAttributeValue(element, "name")) != null) {
                this.addIncludePattern(value);
            }
        } else if ("exclude".equals(element.getXmlElementName())) {
            if (AntDomPattern.isEnabled(element) && (value = AntDomPattern.getAttributeValue(element, "name")) != null) {
                this.addExcludePattern(value);
            }
        } else {
            String excludeAttribs;
            String includeAttribs = AntDomPattern.getAttributeValue(element, "includes");
            if (includeAttribs != null) {
                this.addPatterns(true, includeAttribs);
            }
            if ((excludeAttribs = AntDomPattern.getAttributeValue(element, "excludes")) != null) {
                this.addPatterns(false, excludeAttribs);
            }
        }
        if ((referred = (AntDomElement)element.getRefId().getValue()) != null) {
            referred.accept(this);
        }
        super.visitAntDomElement(element);
    }

    @Nullable
    private static String getAttributeValue(AntDomElement element, String attributeName) {
        DomAttributeChildDescription description = element.getGenericInfo().getAttributeChildDescription(attributeName);
        if (description == null) {
            return null;
        }
        return description.getDomAttributeValue((DomElement)element).getStringValue();
    }

    public final void addExcludePattern(String antPattern) {
        this.myExcludePatterns.add(AntDomPattern.convertToRegexPattern(antPattern, this.myCaseSensitive));
    }

    public final void addIncludePattern(String antPattern) {
        String normalizedPattern;
        this.myIncludePatterns.add(AntDomPattern.convertToRegexPattern(antPattern, this.myCaseSensitive));
        String string = normalizedPattern = antPattern.endsWith("/") || antPattern.endsWith(File.separator) ? antPattern.replace(File.separatorChar, '/') + "**" : antPattern.replace(File.separatorChar, '/');
        if (normalizedPattern.startsWith("/") && normalizedPattern.length() > 1) {
            normalizedPattern = normalizedPattern.substring(1);
        }
        if (!normalizedPattern.startsWith("/")) {
            String[] patDirs = normalizedPattern.split(ourSeparatorPattern);
            PrefixItem[] items = new PrefixItem[patDirs.length];
            for (int i = 0; i < patDirs.length; ++i) {
                items[i] = new PrefixItem(patDirs[i]);
            }
            this.myCouldBeIncludedPatterns.add(items);
        }
    }

    public boolean acceptPath(String relativePath) {
        String path = relativePath.replace('\\', '/');
        boolean accepted = this.myIncludePatterns.size() == 0;
        for (Pattern includePattern : this.myIncludePatterns) {
            if (!includePattern.matcher(path).matches()) continue;
            accepted = true;
            break;
        }
        if (accepted) {
            for (Pattern excludePattern : this.myExcludePatterns) {
                if (!excludePattern.matcher(path).matches()) continue;
                accepted = false;
                break;
            }
        }
        return accepted;
    }

    private static boolean isEnabled(AntDomElement element) {
        String ifProperty = AntDomPattern.getAttributeValue(element, "if");
        if (ifProperty != null && PropertyResolver.resolve(element.getContextAntProject(), ifProperty, element).getFirst() == null) {
            return false;
        }
        String unlessProperty = AntDomPattern.getAttributeValue(element, "unless");
        return unlessProperty == null || PropertyResolver.resolve(element.getContextAntProject(), unlessProperty, element).getFirst() == null;
    }

    private void addPatterns(boolean addToIncludes, String patternString) {
        StringTokenizer tokenizer = new StringTokenizer(patternString, ", \t", false);
        while (tokenizer.hasMoreTokens()) {
            String pattern = tokenizer.nextToken();
            if (pattern.length() <= 0) continue;
            if (addToIncludes) {
                this.addIncludePattern(pattern);
                continue;
            }
            this.addExcludePattern(pattern);
        }
    }

    private static Pattern convertToRegexPattern(@NonNls String antPattern, boolean caseSensitive) {
        return Pattern.compile(FileUtil.convertAntToRegexp((String)antPattern), caseSensitive ? 0 : 2);
    }

    public static AntDomPattern create(AntDomElement element, boolean honorDefaultExcludes, boolean caseSensitive) {
        AntDomPattern antPattern = new AntDomPattern(caseSensitive);
        element.accept(antPattern);
        if (honorDefaultExcludes) {
            antPattern.myExcludePatterns.addAll(caseSensitive ? ourDefaultExcludes : ourCaseInsensitiveDefaultExcludes);
        }
        return antPattern;
    }

    protected static boolean matchPatternStart(PrefixItem[] patDirs, String str) {
        PrefixItem item;
        int strIdxStart;
        String[] strDirs = str.split(ourSeparatorPattern);
        int patIdxStart = 0;
        int patIdxEnd = patDirs.length - 1;
        int strIdxEnd = strDirs.length - 1;
        for (strIdxStart = 0; patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !"**".equals((item = patDirs[patIdxStart]).getStrPattern()); ++patIdxStart, ++strIdxStart) {
            if (item.getPattern().matcher(strDirs[strIdxStart]).matches()) continue;
            return false;
        }
        if (strIdxStart > strIdxEnd) {
            return true;
        }
        return patIdxStart <= patIdxEnd;
    }

    public boolean couldBeIncluded(String relativePath) {
        if (this.myIncludePatterns.size() == 0) {
            return true;
        }
        return this.myCouldBeIncludedPatterns.stream().anyMatch(couldBeIncludedPattern -> AntDomPattern.matchPatternStart(couldBeIncludedPattern, relativePath));
    }

    private class PrefixItem {
        private final String myStrPattern;
        private Pattern myCompiledPattern;

        public PrefixItem(String strPattern) {
            this.myStrPattern = strPattern;
        }

        public String getStrPattern() {
            return this.myStrPattern;
        }

        public Pattern getPattern() {
            if (this.myCompiledPattern == null) {
                this.myCompiledPattern = Pattern.compile(FileUtil.convertAntToRegexp((String)this.myStrPattern), AntDomPattern.this.myCaseSensitive ? 0 : 2);
            }
            return this.myCompiledPattern;
        }
    }
}

