/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl.configuration;

import com.intellij.lang.ant.config.impl.AntBuildFileImpl;
import com.intellij.lang.ant.config.impl.AntInstallation;
import com.intellij.lang.ant.config.impl.AntReference;
import com.intellij.lang.ant.config.impl.GlobalAntConfiguration;
import com.intellij.lang.ant.config.impl.configuration.AntSetPanel;
import com.intellij.lang.ant.config.impl.configuration.AntUIUtil;
import com.intellij.lang.ant.config.impl.configuration.ChooseAndEditComboBoxController;
import com.intellij.lang.ant.config.impl.configuration.UIPropertyBinding;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.containers.ConvertingIterator;
import com.intellij.util.containers.Convertor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;

public class RunWithAntBinding
extends UIPropertyBinding {
    private final ArrayList<JComponent> myComponents = new ArrayList();
    private final JRadioButton myUseDefaultAnt;
    private final ComboboxWithBrowseButton myAnts;
    private final ChooseAndEditComboBoxController<AntReference, AntReference> myAntsController;
    private final GlobalAntConfiguration myAntConfiguration;
    private boolean myEnabled = true;
    private boolean myLoadingValues = false;
    private final JRadioButton myUseCustomAnt;

    public RunWithAntBinding(JRadioButton useDefaultAnt, JRadioButton useCastomAnt, ComboboxWithBrowseButton ants) {
        this(useDefaultAnt, useCastomAnt, ants, GlobalAntConfiguration.getInstance());
    }

    RunWithAntBinding(JRadioButton useDefaultAnt, JRadioButton useCustomAnt, ComboboxWithBrowseButton ants, final GlobalAntConfiguration antConfiguration) {
        this.myAntConfiguration = antConfiguration;
        this.myComponents.add(useDefaultAnt);
        this.myUseCustomAnt = useCustomAnt;
        this.myComponents.add(this.myUseCustomAnt);
        this.myAnts = ants;
        this.myUseDefaultAnt = useDefaultAnt;
        ButtonGroup group = new ButtonGroup();
        group.add(useDefaultAnt);
        group.add(this.myUseCustomAnt);
        this.myUseCustomAnt.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RunWithAntBinding.this.updateEnableCombobox();
                if (RunWithAntBinding.this.myUseCustomAnt.isSelected() && !RunWithAntBinding.this.myLoadingValues) {
                    RunWithAntBinding.this.myAnts.getComboBox().requestFocusInWindow();
                }
            }
        });
        this.myAntsController = new ChooseAndEditComboBoxController<AntReference, AntReference>(this.myAnts, (Convertor)new ConvertingIterator.IdConvertor(), AntReference.COMPARATOR){

            @Override
            public Iterator<AntReference> getAllListItems() {
                return antConfiguration.getConfiguredAnts().keySet().iterator();
            }

            @Override
            public AntReference openConfigureDialog(AntReference reference, JComponent parent) {
                AntSetPanel antSetPanel = new AntSetPanel();
                AntInstallation installation = RunWithAntBinding.this.myAntConfiguration.getConfiguredAnts().get(reference);
                if (installation == null) {
                    installation = RunWithAntBinding.this.myAntConfiguration.getConfiguredAnts().get(AntReference.BUNDLED_ANT);
                }
                antSetPanel.reset();
                antSetPanel.setSelection(installation);
                AntInstallation antInstallation = antSetPanel.showDialog(parent);
                return antInstallation != null ? antInstallation.getReference() : null;
            }
        };
        this.myAntsController.setRenderer((ListCellRenderer)((Object)new AntUIUtil.AntReferenceRenderer(this.myAntConfiguration)));
    }

    @Override
    public void addAllPropertiesTo(Collection<AbstractProperty> properties) {
        properties.add(AntBuildFileImpl.ANT_REFERENCE);
    }

    @Override
    public void apply(AbstractProperty.AbstractPropertyContainer container) {
        AntReference antReference = this.myUseDefaultAnt.isSelected() ? AntReference.PROJECT_DEFAULT : this.myAntsController.getSelectedItem();
        AntBuildFileImpl.ANT_REFERENCE.set(container, (Object)antReference);
    }

    @Override
    public void beDisabled() {
        this.myEnabled = false;
        this.updateEnabled();
    }

    @Override
    public void beEnabled() {
        this.myEnabled = true;
        this.updateEnabled();
    }

    @Override
    public void loadValues(AbstractProperty.AbstractPropertyContainer container) {
        this.myLoadingValues = true;
        AntReference antReference = (AntReference)AntBuildFileImpl.ANT_REFERENCE.get(container);
        boolean isDefault = AntReference.PROJECT_DEFAULT == antReference;
        this.myUseDefaultAnt.setSelected(isDefault);
        this.myUseCustomAnt.setSelected(!isDefault);
        AntReference selection = isDefault ? null : antReference;
        this.myAntsController.resetList(selection);
        this.updateEnableCombobox();
        this.myLoadingValues = false;
    }

    private void updateEnabled() {
        for (JComponent component : this.myComponents) {
            component.setEnabled(this.myEnabled);
        }
        this.updateEnableCombobox();
    }

    private void updateEnableCombobox() {
        boolean enabled = this.myEnabled && this.myUseCustomAnt.isSelected();
        this.myAnts.setEnabled(enabled);
        if (!enabled) {
            this.myAnts.getComboBox().setSelectedItem(null);
        }
        if (!enabled || this.myLoadingValues) {
            return;
        }
        this.myAntsController.resetList(AntReference.BUNDLED_ANT);
    }
}

