/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.ExternalizablePropertyContainer;
import java.util.Arrays;

public class CompositePropertyContainer
extends AbstractProperty.AbstractPropertyContainer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.ant.config.impl.CompositePropertyContainer");
    private final AbstractProperty.AbstractPropertyContainer[] myContainers;

    public CompositePropertyContainer(AbstractProperty.AbstractPropertyContainer[] containers) {
        this.myContainers = containers;
    }

    public Object getValueOf(AbstractProperty property) {
        return property.get(this.containerOf(property));
    }

    public void setValueOf(AbstractProperty property, Object value) {
        property.set(this.containerOf(property), value);
    }

    public boolean hasProperty(AbstractProperty property) {
        return Arrays.stream(this.myContainers).anyMatch(container -> container.hasProperty(property));
    }

    private AbstractProperty.AbstractPropertyContainer containerOf(AbstractProperty property) {
        for (AbstractProperty.AbstractPropertyContainer container : this.myContainers) {
            if (!container.hasProperty(property)) continue;
            return container;
        }
        if (ApplicationManager.getApplication() != null) {
            LOG.error("Unknown property: " + property.getName());
        }
        return new ExternalizablePropertyContainer();
    }
}

