/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.actions;

import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntBuildListener;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.execution.ExecutionHandler;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.List;

public final class TargetAction
extends DumbAwareAction {
    public static final String DEFAULT_TARGET_NAME = AntBundle.message("ant.target.name.default.target", new Object[0]);
    private final String myBuildName;
    private final List<String> myTargets;
    private final String myDebugString;

    public TargetAction(AntBuildFile buildFile, String displayName, List<String> targets, String description) {
        Presentation templatePresentation = this.getTemplatePresentation();
        templatePresentation.setText(displayName, false);
        templatePresentation.setDescription(description);
        this.myBuildName = buildFile.getPresentableName();
        this.myTargets = targets;
        this.myDebugString = "Target action: " + displayName + "; Build: " + buildFile.getPresentableName() + "; Project: " + buildFile.getProject().getPresentableUrl();
    }

    public String toString() {
        return this.myDebugString;
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        for (AntBuildFile antBuildFile : AntConfiguration.getInstance(project).getBuildFileList()) {
            String name = antBuildFile.getPresentableName();
            if (name == null || !this.myBuildName.equals(name)) continue;
            List<String> targets = this.myTargets.size() == 1 && DEFAULT_TARGET_NAME.equals(this.myTargets.iterator().next()) ? Collections.emptyList() : this.myTargets;
            ExecutionHandler.runBuild((AntBuildFileBase)antBuildFile, targets, null, e.getDataContext(), Collections.emptyList(), AntBuildListener.NULL);
            return;
        }
    }
}

