/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jshell.protocol;

import com.intellij.execution.jshell.protocol.Endpoint;
import com.intellij.execution.jshell.protocol.Message;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

public class MessageWriter<T extends Message>
extends Endpoint {
    private final BufferedWriter myOut;
    private final JAXBContext myContext;

    public MessageWriter(OutputStream output, Class<T> msgType) throws Exception {
        this.myOut = new BufferedWriter(new OutputStreamWriter(output));
        this.myContext = JAXBContext.newInstance((Class[])new Class[]{msgType});
    }

    public void send(T message) throws IOException {
        try {
            this.myOut.newLine();
            this.myOut.write("__#begin#__");
            this.myOut.newLine();
            this.myContext.createMarshaller().marshal(message, (Writer)this.myOut);
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
        finally {
            this.myOut.newLine();
            this.myOut.write("__#end#__");
            this.myOut.newLine();
            this.myOut.flush();
        }
    }
}

