/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.util.CachedAliasImportData;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u0006\u001a\u0016\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u0007\u001a\u0018\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u0006H\u0002\u001a\u0014\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n*\u0006\u0012\u0002\b\u00030\u000bH\u0002\u001a\f\u0010\f\u001a\u00020\r*\u0004\u0018\u00010\u000e\u001a\f\u0010\f\u001a\u00020\r*\u0004\u0018\u00010\u0007\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"ALIAS_IMPORT_DATA_KEY", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/kotlin/util/CachedAliasImportData;", "aliasImportMap", "Lcom/google/common/collect/Multimap;", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "Lorg/jetbrains/kotlin/psi/KtUserType;", "buildAliasImportMap", "getContainingFileStub", "Lcom/intellij/psi/stubs/PsiFileStub;", "Lcom/intellij/psi/stubs/StubElement;", "isProbablyNothing", "", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "ide-common"})
public final class TypeIndexUtilKt {
    private static final Key<CachedAliasImportData> ALIAS_IMPORT_DATA_KEY = new Key("ALIAS_IMPORT_MAP_KEY");

    @NotNull
    public static final Multimap<String, String> aliasImportMap(@NotNull KtUserType $receiver) {
        PsiFile file2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiFile psiFile = (PsiFile)$receiver.getStub();
        if (psiFile == null || (psiFile = TypeIndexUtilKt.getContainingFileStub((StubElement)psiFile)) == null || (psiFile = (PsiFile)psiFile.getPsi()) == null) {
            HashMultimap hashMultimap = HashMultimap.create();
            Intrinsics.checkExpressionValueIsNotNull((Object)hashMultimap, (String)"HashMultimap.create()");
            return (Multimap)hashMultimap;
        }
        PsiFile psiFile2 = file2 = psiFile;
        if (psiFile2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        return TypeIndexUtilKt.aliasImportMap((KtFile)psiFile2);
    }

    @NotNull
    public static final Multimap<String, String> aliasImportMap(@NotNull KtFile $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        CachedAliasImportData cached = (CachedAliasImportData)$receiver.getUserData(ALIAS_IMPORT_DATA_KEY);
        long modificationStamp = $receiver.getModificationStamp();
        if (cached != null && modificationStamp == cached.getFileModificationStamp()) {
            return cached.getMap();
        }
        CachedAliasImportData data = new CachedAliasImportData(TypeIndexUtilKt.buildAliasImportMap($receiver), modificationStamp);
        $receiver.putUserData(ALIAS_IMPORT_DATA_KEY, data);
        return data.getMap();
    }

    private static final Multimap<String, String> buildAliasImportMap(@NotNull KtFile $receiver) {
        HashMultimap map2 = HashMultimap.create();
        KtImportList ktImportList = $receiver.getImportList();
        if (ktImportList == null) {
            HashMultimap hashMultimap = map2;
            Intrinsics.checkExpressionValueIsNotNull((Object)hashMultimap, (String)"map");
            return (Multimap)hashMultimap;
        }
        KtImportList importList = ktImportList;
        Iterator<KtImportDirective> iterator2 = importList.getImports().iterator();
        while (iterator2.hasNext()) {
            String aliasName;
            KtImportDirective ktImportDirective;
            KtImportDirective ktImportDirective2 = ktImportDirective = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktImportDirective2, (String)"import");
            if (ktImportDirective2.getAliasName() == null) {
                continue;
            }
            Object object = ktImportDirective.getImportPath();
            if (object == null || (object = ((ImportPath)object).getFqName()) == null || (object = ((FqName)object).shortName()) == null || (object = ((Name)object).asString()) == null) {
                continue;
            }
            Object name2 = object;
            map2.put((Object)aliasName, name2);
        }
        HashMultimap hashMultimap = map2;
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMultimap, (String)"map");
        return (Multimap)hashMultimap;
    }

    public static final boolean isProbablyNothing(@Nullable KtTypeReference $receiver) {
        KtTypeReference ktTypeReference = $receiver;
        KtTypeElement ktTypeElement = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
        if (!(ktTypeElement instanceof KtUserType)) {
            ktTypeElement = null;
        }
        KtUserType ktUserType2 = (KtUserType)ktTypeElement;
        if (ktUserType2 == null) {
            return false;
        }
        KtUserType userType2 = ktUserType2;
        return TypeIndexUtilKt.isProbablyNothing(userType2);
    }

    public static final boolean isProbablyNothing(@Nullable KtUserType $receiver) {
        if ($receiver == null) {
            return false;
        }
        String referencedName = $receiver.getReferencedName();
        return Intrinsics.areEqual((Object)referencedName, (Object)"Nothing") || TypeIndexUtilKt.aliasImportMap($receiver).get((Object)referencedName).contains("Nothing");
    }

    private static final PsiFileStub<?> getContainingFileStub(@NotNull StubElement<?> $receiver) {
        PsiFileStub<?> psiFileStub;
        if ($receiver instanceof PsiFileStub) {
            psiFileStub = (PsiFileStub<?>)$receiver;
        } else {
            StubElement stubElement = $receiver.getParentStub();
            Intrinsics.checkExpressionValueIsNotNull((Object)stubElement, (String)"parentStub");
            psiFileStub = TypeIndexUtilKt.getContainingFileStub(stubElement);
        }
        return psiFileStub;
    }
}

