/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.Mutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.ReadOnly;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;

public class DescriptorSubstitutor {
    private DescriptorSubstitutor() {
    }

    @NotNull
    public static TypeSubstitutor substituteTypeParameters(@ReadOnly @NotNull List<TypeParameterDescriptor> typeParameters, @NotNull TypeSubstitution originalSubstitution, @NotNull DeclarationDescriptor newContainingDeclaration, @NotNull @Mutable List<TypeParameterDescriptor> result2) {
        TypeSubstitutor substitutor3 = DescriptorSubstitutor.substituteTypeParameters(typeParameters, originalSubstitution, newContainingDeclaration, result2, null);
        if (substitutor3 == null) {
            throw new AssertionError((Object)"Substitution failed");
        }
        return substitutor3;
    }

    @Nullable
    public static TypeSubstitutor substituteTypeParameters(@ReadOnly @NotNull List<TypeParameterDescriptor> typeParameters, @NotNull TypeSubstitution originalSubstitution, @NotNull DeclarationDescriptor newContainingDeclaration, @NotNull @Mutable List<TypeParameterDescriptor> result2, @Nullable boolean[] wereChanges) {
        HashMap<TypeConstructor, TypeProjectionImpl> mutableSubstitution = new HashMap<TypeConstructor, TypeProjectionImpl>();
        HashMap<TypeParameterDescriptor, TypeParameterDescriptorImpl> substitutedMap = new HashMap<TypeParameterDescriptor, TypeParameterDescriptorImpl>();
        int index2 = 0;
        for (TypeParameterDescriptor descriptor2 : typeParameters) {
            TypeParameterDescriptorImpl substituted = TypeParameterDescriptorImpl.createForFurtherModification(newContainingDeclaration, descriptor2.getAnnotations(), descriptor2.isReified(), descriptor2.getVariance(), descriptor2.getName(), index2++, SourceElement.NO_SOURCE);
            mutableSubstitution.put(descriptor2.getTypeConstructor(), new TypeProjectionImpl(substituted.getDefaultType()));
            substitutedMap.put(descriptor2, substituted);
            result2.add(substituted);
        }
        TypeSubstitutor substitutor3 = TypeSubstitutor.createChainedSubstitutor(originalSubstitution, TypeConstructorSubstitution.createByConstructorsMap(mutableSubstitution));
        for (TypeParameterDescriptor descriptor3 : typeParameters) {
            TypeParameterDescriptorImpl substituted = (TypeParameterDescriptorImpl)substitutedMap.get(descriptor3);
            for (KotlinType upperBound : descriptor3.getUpperBounds()) {
                KotlinType substitutedBound = substitutor3.substitute(upperBound, Variance.IN_VARIANCE);
                if (substitutedBound == null) {
                    return null;
                }
                if (substitutedBound != upperBound && wereChanges != null) {
                    wereChanges[0] = true;
                }
                substituted.addUpperBound(substitutedBound);
            }
            substituted.setInitialized();
        }
        return substitutor3;
    }
}

