/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedType;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintContext;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintIncorporationKt$WhenMappings;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderImpl;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBounds;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBoundsImpl;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBoundsKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.CompoundConstraintPosition;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typesApproximation.ApproximationBounds;
import org.jetbrains.kotlin.types.typesApproximation.CapturedTypeApproximationKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u001c\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002\u001a\u0012\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\n\u001a\u00020\u0004\u00a8\u0006\u000b"}, d2={"addConstraintFromBounds", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilderImpl;", "old", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$Bound;", "new", "generateNewBound", "bound", "substitution", "incorporateBound", "newBound", "frontend"})
public final class ConstraintIncorporationKt {
    /*
     * WARNING - void declaration
     */
    public static final void incorporateBound(@NotNull ConstraintSystemBuilderImpl $receiver, @NotNull TypeBounds.Bound newBound) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)newBound, (String)"newBound");
        TypeVariable typeVariable2 = newBound.getTypeVariable();
        TypeBoundsImpl typeBounds = $receiver.getTypeBounds$frontend(typeVariable2);
        int n = 0;
        int n2 = typeBounds.getBounds().size();
        while (n < n2) {
            void oldBoundIndex;
            Object e = ((ArrayList)typeBounds.getBounds()).get((int)oldBoundIndex);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"typeBounds.bounds[oldBoundIndex]");
            ConstraintIncorporationKt.addConstraintFromBounds($receiver, (TypeBounds.Bound)e, newBound);
            ++oldBoundIndex;
        }
        List list2 = $receiver.getUsedInBounds$frontend().get(typeVariable2);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List boundsUsedIn = list2;
        n2 = 0;
        int n3 = ((Collection)boundsUsedIn).size();
        while (n2 < n3) {
            void index2;
            TypeBounds.Bound boundUsedIn = (TypeBounds.Bound)boundsUsedIn.get((int)index2);
            ConstraintIncorporationKt.generateNewBound($receiver, boundUsedIn, newBound);
            ++index2;
        }
        KotlinType constrainingType = newBound.getConstrainingType();
        if ($receiver.isMyTypeVariable$frontend(constrainingType)) {
            ConstraintContext context = new ConstraintContext(newBound.getPosition(), newBound.getDerivedFrom(), false, false, 12, null);
            TypeVariable typeVariable3 = $receiver.getMyTypeVariable$frontend(constrainingType);
            if (typeVariable3 == null) {
                Intrinsics.throwNpe();
            }
            $receiver.addBound$frontend(typeVariable3, typeVariable2.getType(), TypeBoundsKt.reverse(newBound.getKind()), context);
            return;
        }
        Iterable $receiver$iv = $receiver.getNestedTypeVariables$frontend(constrainingType);
        for (Object element$iv : $receiver$iv) {
            TypeVariable it = (TypeVariable)element$iv;
            Collection boundsForNestedVariable = $receiver.getTypeBounds$frontend(it).getBounds();
            int n4 = 0;
            int n5 = boundsForNestedVariable.size();
            while (n4 < n5) {
                void index3;
                Object e = ((ArrayList)boundsForNestedVariable).get((int)index3);
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"boundsForNestedVariable[index]");
                ConstraintIncorporationKt.generateNewBound($receiver, newBound, (TypeBounds.Bound)e);
                ++index3;
            }
        }
    }

    private static final void addConstraintFromBounds(@NotNull ConstraintSystemBuilderImpl $receiver, TypeBounds.Bound old, TypeBounds.Bound bound) {
        if (Intrinsics.areEqual((Object)old, (Object)bound)) {
            return;
        }
        KotlinType oldType = old.getConstrainingType();
        KotlinType newType = bound.getConstrainingType();
        ConstraintContext context = new ConstraintContext(new CompoundConstraintPosition(old.getPosition(), bound.getPosition()), SetsKt.plus(old.getDerivedFrom(), (Iterable)bound.getDerivedFrom()), false, false, 12, null);
        if (old.getKind().ordinal() < bound.getKind().ordinal()) {
            $receiver.addConstraint(ConstraintSystemBuilderImpl.ConstraintKind.SUB_TYPE, oldType, newType, context);
        } else if (old.getKind().ordinal() > bound.getKind().ordinal()) {
            $receiver.addConstraint(ConstraintSystemBuilderImpl.ConstraintKind.SUB_TYPE, newType, oldType, context);
        } else if (old.getKind() == bound.getKind() && old.getKind() == TypeBounds.BoundKind.EXACT_BOUND) {
            $receiver.addConstraint(ConstraintSystemBuilderImpl.ConstraintKind.EQUAL, oldType, newType, context);
        }
    }

    private static final void generateNewBound(@NotNull ConstraintSystemBuilderImpl $receiver, TypeBounds.Bound bound, TypeBounds.Bound substitution2) {
        KotlinType kotlinType;
        if (bound == substitution2) {
            return;
        }
        switch (ConstraintIncorporationKt$WhenMappings.$EnumSwitchMapping$0[substitution2.getKind().ordinal()]) {
            case 1: {
                kotlinType = substitution2.getConstrainingType();
                break;
            }
            case 2: {
                kotlinType = new CapturedType(new TypeProjectionImpl(Variance.OUT_VARIANCE, substitution2.getConstrainingType()), null, false, null, 14, null);
                break;
            }
            case 3: {
                kotlinType = new CapturedType(new TypeProjectionImpl(Variance.IN_VARIANCE, substitution2.getConstrainingType()), null, false, null, 14, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        KotlinType substitutedType = kotlinType;
        TypeProjectionImpl newTypeProjection = new TypeProjectionImpl(substitutedType);
        TypeSubstitutor substitutor3 = TypeSubstitutor.create(MapsKt.mapOf((Pair)TuplesKt.to((Object)substitution2.getTypeVariable().getType().getConstructor(), (Object)newTypeProjection)));
        KotlinType kotlinType2 = substitutor3.substitute(bound.getConstrainingType(), Variance.INVARIANT);
        if (kotlinType2 == null) {
            return;
        }
        KotlinType type2 = kotlinType2;
        CompoundConstraintPosition position2 = new CompoundConstraintPosition(bound.getPosition(), substitution2.getPosition());
        Function2<KotlinType, TypeBounds.BoundKind, Unit> addNewBound$ = new Function2<KotlinType, TypeBounds.BoundKind, Unit>($receiver, bound, substitution2, position2){
            final /* synthetic */ ConstraintSystemBuilderImpl receiver$0;
            final /* synthetic */ TypeBounds.Bound $bound;
            final /* synthetic */ TypeBounds.Bound $substitution;
            final /* synthetic */ CompoundConstraintPosition $position;

            public final void invoke(@NotNull KotlinType newConstrainingType, @NotNull TypeBounds.BoundKind newBoundKind) {
                Intrinsics.checkParameterIsNotNull((Object)newConstrainingType, (String)"newConstrainingType");
                Intrinsics.checkParameterIsNotNull((Object)((Object)newBoundKind), (String)"newBoundKind");
                if (this.receiver$0.getNestedTypeVariables$frontend(newConstrainingType).contains(this.$bound.getTypeVariable())) {
                    return;
                }
                HashSet<TypeVariable> derivedFrom = new HashSet<TypeVariable>(SetsKt.plus(this.$bound.getDerivedFrom(), (Iterable)this.$substitution.getDerivedFrom()));
                if (derivedFrom.contains(this.$substitution.getTypeVariable())) {
                    return;
                }
                derivedFrom.add(this.$substitution.getTypeVariable());
                this.receiver$0.addBound$frontend(this.$bound.getTypeVariable(), newConstrainingType, newBoundKind, new ConstraintContext(this.$position, derivedFrom, false, false, 12, null));
            }
            {
                this.receiver$0 = constraintSystemBuilderImpl;
                this.$bound = bound;
                this.$substitution = bound2;
                this.$position = compoundConstraintPosition;
                super(2);
            }
        };
        if (substitution2.getKind() == TypeBounds.BoundKind.EXACT_BOUND) {
            KotlinType kotlinType3 = type2;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"type");
            addNewBound$.invoke(kotlinType3, bound.getKind());
            return;
        }
        KotlinType kotlinType4 = type2;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType4, (String)"type");
        ApproximationBounds<KotlinType> approximationBounds = CapturedTypeApproximationKt.approximateCapturedTypes(kotlinType4);
        Function1<KotlinType, Boolean> containsConstrainingTypeWithoutProjection$ = new Function1<KotlinType, Boolean>(substitution2){
            final /* synthetic */ TypeBounds.Bound $substitution;

            public final boolean invoke(@NotNull KotlinType $receiver) {
                boolean bl;
                block3: {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    Iterable $receiver$iv = ConstraintSystemUtilsKt.getNestedArguments($receiver);
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $receiver$iv) {
                            TypeProjection it = (TypeProjection)element$iv;
                            if (!(Intrinsics.areEqual((Object)it.getType().getConstructor(), (Object)this.$substitution.getConstrainingType().getConstructor()) && it.getProjectionKind() == Variance.INVARIANT)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
            {
                this.$substitution = bound;
                super(1);
            }
        };
        if (containsConstrainingTypeWithoutProjection$.invoke(approximationBounds.getUpper()) && bound.getKind() != TypeBounds.BoundKind.LOWER_BOUND) {
            addNewBound$.invoke(approximationBounds.getUpper(), TypeBounds.BoundKind.UPPER_BOUND);
        }
        if (containsConstrainingTypeWithoutProjection$.invoke(approximationBounds.getLower()) && bound.getKind() != TypeBounds.BoundKind.UPPER_BOUND) {
            addNewBound$.invoke(approximationBounds.getLower(), TypeBounds.BoundKind.LOWER_BOUND);
        }
    }
}

