/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.calls.components.CallableReferenceResolver;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.components.KotlinResolutionCallbacks;
import org.jetbrains.kotlin.resolve.calls.components.PostponeArgumentsChecksKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintStorage;
import org.jetbrains.kotlin.resolve.calls.inference.model.CoroutinePosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.LambdaArgumentConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.NewTypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinDiagnosticsHolder;
import org.jetbrains.kotlin.resolve.calls.model.LambdaWithTypeVariableAsExpectedTypeAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallableReferenceAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCollectionLiteralAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedLambdaAtom;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.StubType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ(\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer;", "", "callableReferenceResolver", "Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceResolver;", "(Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceResolver;)V", "analyze", "", "c", "Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer$Context;", "resolutionCallbacks", "Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedAtom;", "diagnosticsHolder", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinDiagnosticsHolder;", "analyzeLambda", "lambda", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedLambdaAtom;", "diagnosticHolder", "Context", "resolution"})
public final class PostponedArgumentsAnalyzer {
    private final CallableReferenceResolver callableReferenceResolver;

    public final void analyze(@NotNull Context c, @NotNull KotlinResolutionCallbacks resolutionCallbacks, @NotNull ResolvedAtom argument2, @NotNull KotlinDiagnosticsHolder diagnosticsHolder) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull((Object)resolutionCallbacks, (String)"resolutionCallbacks");
        Intrinsics.checkParameterIsNotNull((Object)argument2, (String)"argument");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticsHolder, (String)"diagnosticsHolder");
        ResolvedAtom resolvedAtom = argument2;
        if (resolvedAtom instanceof ResolvedLambdaAtom) {
            this.analyzeLambda(c, resolutionCallbacks, (ResolvedLambdaAtom)argument2, diagnosticsHolder);
        } else if (resolvedAtom instanceof LambdaWithTypeVariableAsExpectedTypeAtom) {
            this.analyzeLambda(c, resolutionCallbacks, PostponeArgumentsChecksKt.transformToResolvedLambda((LambdaWithTypeVariableAsExpectedTypeAtom)argument2, c.getBuilder()), diagnosticsHolder);
        } else if (resolvedAtom instanceof ResolvedCallableReferenceAtom) {
            this.callableReferenceResolver.processCallableReferenceArgument(c.getBuilder(), (ResolvedCallableReferenceAtom)argument2, diagnosticsHolder);
        } else {
            if (resolvedAtom instanceof ResolvedCollectionLiteralAtom) {
                String string = "Not supported";
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
            String string = "Unexpected resolved primitive: " + argument2.getClass().getCanonicalName();
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void analyzeLambda(Context c, KotlinResolutionCallbacks resolutionCallbacks, ResolvedLambdaAtom lambda2, KotlinDiagnosticsHolder diagnosticHolder) {
        Object $i$f$mapKeysTo;
        Object item$iv$iv;
        UnwrappedType $receiver$iv$iv;
        Object element$iv2;
        void returnArguments;
        Object item$iv$iv22;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        UnwrappedType unwrappedType2;
        Object object;
        UnwrappedType it$iv$iv;
        Object object2;
        Object object3;
        void $receiver$iv$iv3;
        void $receiver$iv2;
        Map<NewTypeVariable, StubType> stubsForPostponedVariables;
        Map<NewTypeVariable, StubType> map2 = stubsForPostponedVariables = c.bindingStubsForPostponedVariables();
        Object object4 = c;
        void var8_8 = $receiver$iv2;
        Object destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv2.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv3.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            Iterator it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object3 = destination$iv$iv;
            TypeConstructor typeConstructor2 = ((NewTypeVariable)it.getKey()).getFreshTypeConstructor();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            TypeConstructor typeConstructor3 = typeConstructor2;
            object2 = object3;
            object = it$iv$iv.getValue();
            object2.put(typeConstructor3, object);
        }
        object3 = destination$iv$iv;
        NewTypeSubstitutor currentSubstitutor2 = object4.buildCurrentSubstitutor((Map<TypeConstructor, StubType>)object3);
        Function1<UnwrappedType, UnwrappedType> substitute$ = new Function1<UnwrappedType, UnwrappedType>(currentSubstitutor2){
            final /* synthetic */ NewTypeSubstitutor $currentSubstitutor;

            @NotNull
            public final UnwrappedType invoke(@NotNull UnwrappedType type2) {
                Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                return this.$currentSubstitutor.safeSubstitute(type2);
            }
            {
                this.$currentSubstitutor = newTypeSubstitutor;
                super(1);
            }
        };
        UnwrappedType unwrappedType3 = lambda2.getReceiver();
        if (unwrappedType3 != null) {
            Object p1 = destination$iv$iv = unwrappedType3;
            unwrappedType2 = substitute$.invoke((UnwrappedType)p1);
        } else {
            unwrappedType2 = null;
        }
        UnwrappedType receiver = unwrappedType2;
        Iterable $i$a$1$unknown = $receiver$iv = (Iterable)lambda2.getParameters();
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv22 : $receiver$iv$iv2) {
            Iterator p1;
            it$iv$iv = (UnwrappedType)item$iv$iv22;
            object4 = destination$iv$iv2;
            object3 = substitute$.invoke((UnwrappedType)((Object)p1));
            object4.add(object3);
        }
        List parameters2 = (List)destination$iv$iv2;
        UnwrappedType rawReturnType = lambda2.getReturnType();
        UnwrappedType expectedTypeForReturnArguments = c.canBeProper(rawReturnType) ? substitute$.invoke(rawReturnType) : (c.hasUpperUnitConstraint(rawReturnType) ? (UnwrappedType)TypeUtilsKt.getBuiltIns(lambda2.getReturnType()).getUnitType() : null);
        item$iv$iv22 = resolutionCallbacks.analyzeAndGetLambdaReturnArguments(lambda2.getAtom(), lambda2.isSuspend(), receiver, parameters2, expectedTypeForReturnArguments, stubsForPostponedVariables);
        destination$iv$iv2 = (List)item$iv$iv22.component1();
        InferenceSession inferenceSession = (InferenceSession)item$iv$iv22.component2();
        Iterable $receiver$iv3 = (Iterable)returnArguments;
        for (Object element$iv2 : $receiver$iv3) {
            KotlinCallArgument it = (KotlinCallArgument)element$iv2;
            ConstraintSystemBuilderKt.addSubsystemFromArgument(c, it);
        }
        Iterable $receiver$iv4 = (Iterable)returnArguments;
        element$iv2 = $receiver$iv4;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv4, (int)10));
        Iterator $i$a$2$forEach = $receiver$iv$iv.iterator();
        while ($i$a$2$forEach.hasNext()) {
            void it;
            item$iv$iv = $i$a$2$forEach.next();
            KotlinCallArgument $i$f$associateByTo = (KotlinCallArgument)item$iv$iv;
            object4 = destination$iv$iv3;
            $i$f$mapKeysTo = lambda2.getReturnType();
            void $i$f$mapKeys = it;
            ConstraintSystemBuilder constraintSystemBuilder = c.getBuilder();
            UnwrappedType p1 = $i$f$mapKeysTo;
            UnwrappedType unwrappedType4 = substitute$.invoke(p1);
            object3 = PostponeArgumentsChecksKt.resolveKtPrimitive(constraintSystemBuilder, (KotlinCallArgument)$i$f$mapKeys, unwrappedType4, diagnosticHolder, false);
            object4.add(object3);
        }
        List subResolvedKtPrimitives = (List)destination$iv$iv3;
        if (returnArguments.isEmpty()) {
            SimpleType unitType = TypeUtilsKt.getBuiltIns(lambda2.getReturnType()).getUnitType();
            $receiver$iv$iv = lambda2.getReturnType();
            object4 = c.getBuilder();
            UnwrappedType p1 = $receiver$iv$iv;
            object3 = substitute$.invoke(p1);
            SimpleType simpleType2 = unitType;
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"unitType");
            object4.addSubtypeConstraint((UnwrappedType)object3, simpleType2, new LambdaArgumentConstraintPosition(lambda2));
        }
        lambda2.setAnalyzedResults((List<? extends KotlinCallArgument>)returnArguments, subResolvedKtPrimitives);
        if (inferenceSession != null) {
            ConstraintStorage storageSnapshot = c.getBuilder().currentStorage();
            Map<TypeConstructor, UnwrappedType> postponedVariables = inferenceSession.inferPostponedVariables(lambda2, storageSnapshot);
            item$iv$iv = postponedVariables;
            object = item$iv$iv.entrySet().iterator();
            while (object.hasNext()) {
                VariableWithConstraints variableWithConstraints;
                $i$f$mapKeysTo = object2 = (Map.Entry)object.next();
                TypeConstructor constructor2 = (TypeConstructor)$i$f$mapKeysTo.getKey();
                $i$f$mapKeysTo = object2;
                UnwrappedType resultType = (UnwrappedType)$i$f$mapKeysTo.getValue();
                if (storageSnapshot.getNotFixedTypeVariables().get(constructor2) == null) {
                    continue;
                }
                NewTypeVariable variable2 = variableWithConstraints.getTypeVariable();
                c.getBuilder().unmarkPostponedVariable(variable2);
                c.getBuilder().addEqualityConstraint(variable2.getDefaultType(), resultType, new CoroutinePosition());
            }
        }
    }

    public PostponedArgumentsAnalyzer(@NotNull CallableReferenceResolver callableReferenceResolver) {
        Intrinsics.checkParameterIsNotNull((Object)callableReferenceResolver, (String)"callableReferenceResolver");
        this.callableReferenceResolver = callableReferenceResolver;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0014\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H&J\u001c\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\t0\u0007H&J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&J\b\u0010\u0012\u001a\u00020\u0013H&J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer$Context;", "", "addOtherSystem", "", "otherSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintStorage;", "bindingStubsForPostponedVariables", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/NewTypeVariable;", "Lorg/jetbrains/kotlin/types/StubType;", "buildCurrentSubstitutor", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/NewTypeSubstitutor;", "additionalBindings", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "canBeProper", "", "type", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "getBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "hasUpperUnitConstraint", "resolution"})
    public static interface Context {
        @NotNull
        public NewTypeSubstitutor buildCurrentSubstitutor(@NotNull Map<TypeConstructor, StubType> var1);

        @NotNull
        public Map<NewTypeVariable, StubType> bindingStubsForPostponedVariables();

        public boolean canBeProper(@NotNull UnwrappedType var1);

        public boolean hasUpperUnitConstraint(@NotNull UnwrappedType var1);

        public void addOtherSystem(@NotNull ConstraintStorage var1);

        @NotNull
        public ConstraintSystemBuilder getBuilder();
    }
}

