/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.CallableReferenceCandidate;
import org.jetbrains.kotlin.resolve.calls.components.CallableReferenceOverloadConflictResolver;
import org.jetbrains.kotlin.resolve.calls.components.CallableReferenceResolutionKt;
import org.jetbrains.kotlin.resolve.calls.components.CallableReferencesCandidateFactory;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemOperation;
import org.jetbrains.kotlin.resolve.calls.inference.components.FreshVariableNewTypeSubstitutor;
import org.jetbrains.kotlin.resolve.calls.model.CallableReferenceCandidatesAmbiguity;
import org.jetbrains.kotlin.resolve.calls.model.CallableReferenceKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallComponents;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.KotlinDiagnosticsHolder;
import org.jetbrains.kotlin.resolve.calls.model.LHSResult;
import org.jetbrains.kotlin.resolve.calls.model.NoneCallableReferenceCandidates;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionCandidateKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallableReferenceAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedExpressionAtom;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SubKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.tower.ImplicitScopeTower;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.TowerResolver;
import org.jetbrains.kotlin.types.UnwrappedType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014JH\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u001e\u0010\u001e\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u000e0\u001f\u0012\u0004\u0012\u00020\u000e0\u001fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceResolver;", "", "towerResolver", "Lorg/jetbrains/kotlin/resolve/calls/tower/TowerResolver;", "callableReferenceOverloadConflictResolver", "Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceOverloadConflictResolver;", "callComponents", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;", "(Lorg/jetbrains/kotlin/resolve/calls/tower/TowerResolver;Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceOverloadConflictResolver;Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;)V", "buildResolvedKtArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedAtom;", "lhsResult", "Lorg/jetbrains/kotlin/resolve/calls/model/LHSResult;", "processCallableReferenceArgument", "", "csBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "resolvedAtom", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallableReferenceAtom;", "diagnosticsHolder", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinDiagnosticsHolder;", "runRHSResolution", "", "Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceCandidate;", "scopeTower", "Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "callableReference", "Lorg/jetbrains/kotlin/resolve/calls/model/CallableReferenceKotlinCallArgument;", "expectedType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "compatibilityChecker", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemOperation;", "resolution"})
public final class CallableReferenceResolver {
    private final TowerResolver towerResolver;
    private final CallableReferenceOverloadConflictResolver callableReferenceOverloadConflictResolver;
    private final KotlinCallComponents callComponents;

    /*
     * WARNING - void declaration
     */
    public final void processCallableReferenceArgument(@NotNull ConstraintSystemBuilder csBuilder, @NotNull ResolvedCallableReferenceAtom resolvedAtom, @NotNull KotlinDiagnosticsHolder diagnosticsHolder) {
        UnwrappedType unwrappedType2;
        Intrinsics.checkParameterIsNotNull((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkParameterIsNotNull((Object)resolvedAtom, (String)"resolvedAtom");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticsHolder, (String)"diagnosticsHolder");
        CallableReferenceKotlinCallArgument argument2 = resolvedAtom.getAtom();
        UnwrappedType unwrappedType3 = resolvedAtom.getExpectedType();
        if (unwrappedType3 != null) {
            UnwrappedType unwrappedType4;
            UnwrappedType it = unwrappedType4 = unwrappedType3;
            unwrappedType2 = csBuilder.buildCurrentSubstitutor().safeSubstitute(it);
        } else {
            unwrappedType2 = null;
        }
        UnwrappedType expectedType = unwrappedType2;
        ImplicitScopeTower scopeTower = this.callComponents.getStatelessCallbacks().getScopeTowerForCallableReferenceArgument(argument2);
        Set<CallableReferenceCandidate> candidates2 = this.runRHSResolution(scopeTower, argument2, expectedType, (Function1<? super Function1<? super ConstraintSystemOperation, Unit>, Unit>)((Function1)new Function1<Function1<? super ConstraintSystemOperation, ? extends Unit>, Unit>(csBuilder){
            final /* synthetic */ ConstraintSystemBuilder $csBuilder;

            public final void invoke(@NotNull Function1<? super ConstraintSystemOperation, Unit> checkCallableReference) {
                Intrinsics.checkParameterIsNotNull(checkCallableReference, (String)"checkCallableReference");
                this.$csBuilder.runTransaction((Function1<? super ConstraintSystemOperation, Boolean>)((Function1)new Function1<ConstraintSystemOperation, Boolean>(checkCallableReference){
                    final /* synthetic */ Function1 $checkCallableReference;

                    public final boolean invoke(@NotNull ConstraintSystemOperation $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        this.$checkCallableReference.invoke((Object)$receiver);
                        return false;
                    }
                    {
                        this.$checkCallableReference = function1;
                        super(1);
                    }
                }));
            }
            {
                this.$csBuilder = constraintSystemBuilder;
                super(1);
            }
        }));
        CallableReferenceCandidate chosenCandidate = (CallableReferenceCandidate)CollectionsKt.singleOrNull((Iterable)candidates2);
        if (chosenCandidate != null) {
            void toFreshSubstitutor;
            CallableReferenceCandidate $receiver = chosenCandidate;
            Pair<FreshVariableNewTypeSubstitutor, KotlinCallDiagnostic> pair2 = CallableReferenceResolutionKt.checkCallableReference(csBuilder, argument2, $receiver.getDispatchReceiver(), $receiver.getExtensionReceiver(), $receiver.getCandidate(), $receiver.getReflectionCandidateType(), expectedType, scopeTower.getLexicalScope().getOwnerDescriptor());
            FreshVariableNewTypeSubstitutor freshVariableNewTypeSubstitutor = (FreshVariableNewTypeSubstitutor)pair2.component1();
            KotlinCallDiagnostic diagnostic = (KotlinCallDiagnostic)pair2.component2();
            ResolutionCandidateKt.addDiagnosticIfNotNull(diagnosticsHolder, diagnostic);
            chosenCandidate.setFreshSubstitutor$resolution((FreshVariableNewTypeSubstitutor)toFreshSubstitutor);
        } else if (candidates2.isEmpty()) {
            diagnosticsHolder.addDiagnostic(new NoneCallableReferenceCandidates(argument2));
        } else {
            diagnosticsHolder.addDiagnostic(new CallableReferenceCandidatesAmbiguity(argument2, (Collection<CallableReferenceCandidate>)candidates2));
        }
        List subKtArguments = CollectionsKt.listOfNotNull((Object)this.buildResolvedKtArgument(argument2.getLhsResult()));
        resolvedAtom.setAnalyzedResults(chosenCandidate, subKtArguments);
    }

    private final ResolvedAtom buildResolvedKtArgument(LHSResult lhsResult) {
        ResolvedAtom resolvedAtom;
        if (!(lhsResult instanceof LHSResult.Expression)) {
            return null;
        }
        SimpleKotlinCallArgument lshCallArgument = ((LHSResult.Expression)lhsResult).getLshCallArgument();
        SimpleKotlinCallArgument simpleKotlinCallArgument = lshCallArgument;
        if (simpleKotlinCallArgument instanceof SubKotlinCallArgument) {
            resolvedAtom = ((SubKotlinCallArgument)lshCallArgument).getCallResult();
        } else if (simpleKotlinCallArgument instanceof ExpressionKotlinCallArgument) {
            resolvedAtom = new ResolvedExpressionAtom((ExpressionKotlinCallArgument)lshCallArgument);
        } else {
            Void void_ = ArgumentsUtilsKt.unexpectedArgument(lshCallArgument);
            throw null;
        }
        return resolvedAtom;
    }

    private final Set<CallableReferenceCandidate> runRHSResolution(ImplicitScopeTower scopeTower, CallableReferenceKotlinCallArgument callableReference2, UnwrappedType expectedType, Function1<? super Function1<? super ConstraintSystemOperation, Unit>, Unit> compatibilityChecker) {
        CallableReferencesCandidateFactory factory2 = new CallableReferencesCandidateFactory(callableReference2, this.callComponents, scopeTower, compatibilityChecker, expectedType);
        ScopeTowerProcessor<CallableReferenceCandidate> processor2 = CallableReferenceResolutionKt.createCallableReferenceProcessor(factory2);
        Collection<CallableReferenceCandidate> candidates2 = this.towerResolver.runResolve(scopeTower, processor2, true, callableReference2.getRhsName());
        return this.callableReferenceOverloadConflictResolver.chooseMaximallySpecificCandidates(candidates2, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, false, scopeTower.isDebuggerContext());
    }

    public CallableReferenceResolver(@NotNull TowerResolver towerResolver, @NotNull CallableReferenceOverloadConflictResolver callableReferenceOverloadConflictResolver, @NotNull KotlinCallComponents callComponents) {
        Intrinsics.checkParameterIsNotNull((Object)towerResolver, (String)"towerResolver");
        Intrinsics.checkParameterIsNotNull((Object)callableReferenceOverloadConflictResolver, (String)"callableReferenceOverloadConflictResolver");
        Intrinsics.checkParameterIsNotNull((Object)callComponents, (String)"callComponents");
        this.towerResolver = towerResolver;
        this.callableReferenceOverloadConflictResolver = callableReferenceOverloadConflictResolver;
        this.callComponents = callComponents;
    }
}

