/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/ProtectedConstructorCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class ProtectedConstructorCallChecker
implements CallChecker {
    public static final ProtectedConstructorCallChecker INSTANCE;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        boolean bl;
        ConstructorDescriptor actualConstructor;
        DeclarationDescriptor scopeOwner;
        ConstructorDescriptor descriptor2;
        block9: {
            KtExpression calleeExpression2;
            ConstructorDescriptor constructorDescriptor;
            Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
            Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object obj = resolvedCall2.getResultingDescriptor();
            if (!(obj instanceof ConstructorDescriptor)) {
                obj = null;
            }
            ConstructorDescriptor constructorDescriptor2 = (ConstructorDescriptor)obj;
            if (constructorDescriptor2 == null) {
                return;
            }
            descriptor2 = constructorDescriptor2;
            ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = descriptor2.getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull((Object)classifierDescriptorWithTypeParameters, (String)"descriptor.containingDeclaration");
            ClassifierDescriptor constructorOwner = classifierDescriptorWithTypeParameters.getOriginal();
            scopeOwner = context.getScope().getOwnerDescriptor();
            ConstructorDescriptor constructorDescriptor3 = descriptor2;
            if (!(constructorDescriptor3 instanceof TypeAliasConstructorDescriptor)) {
                constructorDescriptor3 = null;
            }
            ConstructorDescriptor constructorDescriptor4 = (constructorDescriptor = (TypeAliasConstructorDescriptor)constructorDescriptor3) != null && (constructorDescriptor = constructorDescriptor.getUnderlyingConstructorDescriptor()) != null ? (ConstructorDescriptor)constructorDescriptor : (actualConstructor = descriptor2);
            if (Intrinsics.areEqual((Object)actualConstructor.getVisibility().normalize(), (Object)Visibilities.PROTECTED) ^ true) {
                return;
            }
            if (!Visibilities.isVisibleWithAnyReceiver(descriptor2, scopeOwner)) {
                return;
            }
            Call call2 = resolvedCall2.getCall();
            Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
            KtExpression ktExpression = calleeExpression2 = call2.getCalleeExpression();
            if (ktExpression instanceof KtConstructorCalleeExpression ? ((KtConstructorCalleeExpression)calleeExpression2).getParent() instanceof KtSuperTypeCallEntry : ktExpression instanceof KtConstructorDelegationReferenceExpression) {
                return;
            }
            Sequence<DeclarationDescriptor> $receiver$iv = DescriptorUtilsKt.getParentsWithSelf(scopeOwner);
            for (Object element$iv : $receiver$iv) {
                DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                if (!(it.getOriginal() == constructorOwner)) continue;
                bl = true;
                break block9;
            }
            bl = false;
        }
        if (bl) {
            return;
        }
        if (Intrinsics.areEqual((Object)Visibilities.findInvisibleMember(Visibilities.FALSE_IF_PROTECTED, descriptor2, scopeOwner), (Object)actualConstructor)) {
            context.getTrace().report(Errors.PROTECTED_CONSTRUCTOR_NOT_IN_SUPER_CALL.on(reportOn, descriptor2));
        }
    }

    private ProtectedConstructorCallChecker() {
    }

    static {
        ProtectedConstructorCallChecker protectedConstructorCallChecker;
        INSTANCE = protectedConstructorCallChecker = new ProtectedConstructorCallChecker();
    }
}

