/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.CoroutineLanguageVersionSettingsUtilKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt$WhenMappings;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a,\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0012\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\u0013\u001a\u00020\u0014*\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0014\u0010\u0017\u001a\u00020\u0014*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0015H\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u001a"}, d2={"COROUTINE_CONTEXT_1_2_20_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "getCOROUTINE_CONTEXT_1_2_20_FQ_NAME", "()Lorg/jetbrains/kotlin/name/FqName;", "checkCoroutinesFeature", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "reportOn", "Lcom/intellij/psi/PsiElement;", "checkRestrictsSuspension", "enclosingCallableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "isBuiltInCoroutineContext", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "isScopeForDefaultParameterValuesOf", "Lorg/jetbrains/kotlin/resolve/scopes/HierarchicalScope;", "enclosingSuspendFunction", "frontend"})
public final class CoroutineCallCheckerKt {
    @NotNull
    private static final FqName COROUTINE_CONTEXT_1_2_20_FQ_NAME = DescriptorUtils.COROUTINES_INTRINSICS_PACKAGE_FQ_NAME_EXPERIMENTAL.child(Name.identifier("coroutineContext"));

    @NotNull
    public static final FqName getCOROUTINE_CONTEXT_1_2_20_FQ_NAME() {
        return COROUTINE_CONTEXT_1_2_20_FQ_NAME;
    }

    public static final boolean isBuiltInCoroutineContext(@NotNull FunctionDescriptor $receiver, @NotNull LanguageVersionSettings languageVersionSettings) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        FunctionDescriptor functionDescriptor2 = $receiver;
        if (!(functionDescriptor2 instanceof PropertyGetterDescriptor)) {
            functionDescriptor2 = null;
        }
        return (object = (PropertyGetterDescriptor)functionDescriptor2) != null && (object = object.getCorrespondingProperty()) != null && (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object)) != null && CoroutineLanguageVersionSettingsUtilKt.isBuiltInCoroutineContext((FqName)object, languageVersionSettings);
    }

    public static final boolean isBuiltInCoroutineContext(@NotNull PropertyDescriptor $receiver, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        return CoroutineLanguageVersionSettingsUtilKt.isBuiltInCoroutineContext(DescriptorUtilsKt.getFqNameSafe($receiver), languageVersionSettings);
    }

    private static final boolean isScopeForDefaultParameterValuesOf(@NotNull HierarchicalScope $receiver, FunctionDescriptor enclosingSuspendFunction) {
        return $receiver instanceof LexicalScope && ((LexicalScope)$receiver).getKind() == LexicalScopeKind.DEFAULT_VALUE && Intrinsics.areEqual((Object)((LexicalScope)$receiver).getOwnerDescriptor(), (Object)enclosingSuspendFunction);
    }

    public static final void checkCoroutinesFeature(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull DiagnosticSink diagnosticHolder, @NotNull PsiElement reportOn) {
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Pair diagnosticData = TuplesKt.to((Object)((Object)LanguageFeature.Coroutines), (Object)languageVersionSettings);
        switch (CoroutineCallCheckerKt$WhenMappings.$EnumSwitchMapping$0[languageVersionSettings.getFeatureSupport(LanguageFeature.Coroutines).ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                diagnosticHolder.report(Errors.EXPERIMENTAL_FEATURE_WARNING.on(reportOn, (Pair<LanguageFeature, LanguageVersionSettings>)diagnosticData));
                break;
            }
            case 3: {
                diagnosticHolder.report(Errors.EXPERIMENTAL_FEATURE_ERROR.on(reportOn, (Pair<LanguageFeature, LanguageVersionSettings>)diagnosticData));
                break;
            }
            case 4: {
                diagnosticHolder.report(Errors.UNSUPPORTED_FEATURE.on(reportOn, (Pair<LanguageFeature, LanguageVersionSettings>)diagnosticData));
            }
        }
    }

    private static final void checkRestrictsSuspension(CallableDescriptor enclosingCallableDescriptor, ResolvedCall<?> resolvedCall2, PsiElement reportOn, CallCheckerContext context) {
        Object object = enclosingCallableDescriptor.getExtensionReceiverParameter();
        if (object == null || (object = object.getValue()) == null) {
            return;
        }
        Object enclosingSuspendReceiverValue = object;
        Function1<ReceiverValue, Boolean> isRestrictsSuspensionReceiver$ = new Function1<ReceiverValue, Boolean>(context){
            final /* synthetic */ CallCheckerContext $context;

            public final boolean invoke(@NotNull ReceiverValue $receiver) {
                boolean bl;
                block3: {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    KotlinType kotlinType = $receiver.getType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"type");
                    Collection<KotlinType> collection = TypeUtilsKt.supertypes(kotlinType);
                    KotlinType kotlinType2 = $receiver.getType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"type");
                    Iterable $receiver$iv = CollectionsKt.plus(collection, (Object)kotlinType2);
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $receiver$iv) {
                            KotlinType it = (KotlinType)element$iv;
                            Object object = it.getConstructor().getDeclarationDescriptor();
                            if (!(object != null && (object = object.getAnnotations()) != null && object.hasAnnotation(CoroutineLanguageVersionSettingsUtilKt.restrictsSuspensionFqName(this.$context.getLanguageVersionSettings())))) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
            {
                this.$context = callCheckerContext;
                super(1);
            }
        };
        Function2<ReceiverValue, ReceiverValue, Boolean> sameInstance$ = new Function2<ReceiverValue, ReceiverValue, Boolean>(context){
            final /* synthetic */ CallCheckerContext $context;

            public final boolean invoke(@NotNull ReceiverValue $receiver, @Nullable ReceiverValue other) {
                CallableDescriptor callableDescriptor;
                DeclarationDescriptor referenceTarget;
                DeclarationDescriptor declarationDescriptor;
                DeclarationDescriptor declarationDescriptor2;
                KtReferenceExpression referenceExpression;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                if (other == null) {
                    return false;
                }
                if ($receiver == other) {
                    return true;
                }
                ReceiverValue receiverValue = other;
                if (!(receiverValue instanceof ExpressionReceiver)) {
                    receiverValue = null;
                }
                ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue;
                KtExpression ktExpression = expressionReceiver != null ? expressionReceiver.getExpression() : null;
                if (!(ktExpression instanceof KtThisExpression)) {
                    ktExpression = null;
                }
                KtThisExpression ktThisExpression = (KtThisExpression)ktExpression;
                KtReferenceExpression ktReferenceExpression = referenceExpression = ktThisExpression != null ? ktThisExpression.getInstanceReference() : null;
                if (ktReferenceExpression != null) {
                    KtReferenceExpression ktReferenceExpression2;
                    KtReferenceExpression it = ktReferenceExpression2 = ktReferenceExpression;
                    declarationDescriptor2 = (DeclarationDescriptor)this.$context.getTrace().get(BindingContext.REFERENCE_TARGET, referenceExpression);
                } else {
                    declarationDescriptor2 = null;
                }
                if (!((declarationDescriptor = (referenceTarget = declarationDescriptor2)) instanceof CallableDescriptor)) {
                    declarationDescriptor = null;
                }
                return $receiver == ((callableDescriptor = (CallableDescriptor)declarationDescriptor) != null && (callableDescriptor = callableDescriptor.getExtensionReceiverParameter()) != null ? callableDescriptor.getValue() : null);
            }
            {
                this.$context = callCheckerContext;
                super(2);
            }
        };
        Object object2 = enclosingSuspendReceiverValue;
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"enclosingSuspendReceiverValue");
        if (!isRestrictsSuspensionReceiver$.invoke((ReceiverValue)object2)) {
            return;
        }
        ReceiverValue receiverValue = resolvedCall2.getDispatchReceiver();
        if (sameInstance$.invoke((ReceiverValue)enclosingSuspendReceiverValue, receiverValue != null ? receiverValue.getOriginal() : null)) {
            return;
        }
        ReceiverValue receiverValue2 = resolvedCall2.getExtensionReceiver();
        if (sameInstance$.invoke((ReceiverValue)enclosingSuspendReceiverValue, receiverValue2 != null ? receiverValue2.getOriginal() : null)) {
            Object obj = resolvedCall2.getCandidateDescriptor();
            Intrinsics.checkExpressionValueIsNotNull(obj, (String)"resolvedCall.candidateDescriptor");
            ReceiverParameterDescriptor receiverParameterDescriptor = obj.getExtensionReceiverParameter();
            if (receiverParameterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)receiverParameterDescriptor, (String)"resolvedCall.candidateDe\u2026ensionReceiverParameter!!");
            ReceiverValue receiverValue3 = receiverParameterDescriptor.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)receiverValue3, (String)"resolvedCall.candidateDe\u2026ReceiverParameter!!.value");
            if (isRestrictsSuspensionReceiver$.invoke(receiverValue3)) {
                return;
            }
        }
        context.getTrace().report(Errors.ILLEGAL_RESTRICTED_SUSPENDING_FUNCTION_CALL.on(reportOn));
    }

    public static final /* synthetic */ boolean access$isScopeForDefaultParameterValuesOf(@NotNull HierarchicalScope $receiver, @NotNull FunctionDescriptor enclosingSuspendFunction) {
        return CoroutineCallCheckerKt.isScopeForDefaultParameterValuesOf($receiver, enclosingSuspendFunction);
    }

    public static final /* synthetic */ void access$checkRestrictsSuspension(@NotNull CallableDescriptor enclosingCallableDescriptor, @NotNull ResolvedCall resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        CoroutineCallCheckerKt.checkRestrictsSuspension(enclosingCallableDescriptor, resolvedCall2, reportOn, context);
    }
}

