/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceFilter;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.diagnostics.MutableDiagnosticsWithSuppression;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.slicedMap.MutableSlicedMap;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.SlicedMapImpl;
import org.jetbrains.kotlin.util.slicedMap.TrackingSlicedMap;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class BindingTraceContext
implements BindingTrace {
    static final boolean TRACK_REWRITES = false;
    static final boolean TRACK_WITH_STACK_TRACES = true;
    private final MutableSlicedMap map;
    @Nullable
    private final MutableDiagnosticsWithSuppression mutableDiagnostics;
    @NotNull
    private final BindingTraceFilter filter;
    private final BindingContext bindingContext = new BindingContext(){

        @Override
        @NotNull
        public Diagnostics getDiagnostics() {
            return BindingTraceContext.this.mutableDiagnostics != null ? BindingTraceContext.this.mutableDiagnostics : Diagnostics.Companion.getEMPTY();
        }

        @Override
        public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
            return BindingTraceContext.this.get(slice, key);
        }

        @Override
        @NotNull
        public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
            return BindingTraceContext.this.getKeys(slice);
        }

        @Override
        @NotNull
        public <K, V> ImmutableMap<K, V> getSliceContents(@NotNull ReadOnlySlice<K, V> slice) {
            return BindingTraceContext.this.map.getSliceContents(slice);
        }

        @Override
        @Nullable
        public KotlinType getType(@NotNull KtExpression expression2) {
            return BindingTraceContext.this.getType(expression2);
        }

        @Override
        public void addOwnDataTo(@NotNull BindingTrace trace, boolean commitDiagnostics) {
            BindingContextUtils.addOwnDataTo(trace, null, commitDiagnostics, BindingTraceContext.this.map, BindingTraceContext.this.mutableDiagnostics);
        }
    };

    public BindingTraceContext() {
        this(false);
    }

    public BindingTraceContext(boolean allowSliceRewrite) {
        this(BindingTraceFilter.Companion.getACCEPT_ALL(), allowSliceRewrite);
    }

    public BindingTraceContext(BindingTraceFilter filter2, boolean allowSliceRewrite) {
        this(new SlicedMapImpl(allowSliceRewrite), filter2);
    }

    private BindingTraceContext(@NotNull MutableSlicedMap map2, BindingTraceFilter filter2) {
        this.map = map2;
        this.mutableDiagnostics = !filter2.getIgnoreDiagnostics() ? new MutableDiagnosticsWithSuppression(this.bindingContext, Diagnostics.Companion.getEMPTY()) : null;
        this.filter = filter2;
    }

    public static BindingTraceContext createTraceableBindingTrace() {
        return new BindingTraceContext(new TrackingSlicedMap(true), BindingTraceFilter.Companion.getACCEPT_ALL());
    }

    @Override
    public void report(@NotNull Diagnostic diagnostic) {
        if (this.mutableDiagnostics == null) {
            return;
        }
        this.mutableDiagnostics.report(diagnostic);
    }

    public void clearDiagnostics() {
        if (this.mutableDiagnostics != null) {
            this.mutableDiagnostics.clear();
        }
    }

    @Override
    public boolean wantsDiagnostics() {
        return this.mutableDiagnostics != null;
    }

    @Override
    @NotNull
    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @Override
    public <K, V> void record(WritableSlice<K, V> slice, K key, V value2) {
        this.map.put(slice, key, value2);
    }

    @Override
    public <K> void record(WritableSlice<K, Boolean> slice, K key) {
        this.record(slice, key, true);
    }

    @Override
    public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
        return this.map.get(slice, key);
    }

    @Override
    @NotNull
    public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
        return this.map.getKeys(slice);
    }

    @Override
    @Nullable
    public KotlinType getType(@NotNull KtExpression expression2) {
        KotlinTypeInfo typeInfo = this.get(BindingContext.EXPRESSION_TYPE_INFO, expression2);
        return typeInfo != null ? typeInfo.getType() : null;
    }

    @Override
    public void recordType(@NotNull KtExpression expression2, @Nullable KotlinType type2) {
        KotlinTypeInfo typeInfo = this.get(BindingContext.EXPRESSION_TYPE_INFO, expression2);
        typeInfo = typeInfo != null ? typeInfo.replaceType(type2) : TypeInfoFactoryKt.createTypeInfo(type2);
        this.record(BindingContext.EXPRESSION_TYPE_INFO, expression2, typeInfo);
    }
}

