/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.stubs.KotlinImportDirectiveStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinImportDirectiveStubImpl;

public class KtImportDirectiveElementType
extends KtStubElementType<KotlinImportDirectiveStub, KtImportDirective> {
    public KtImportDirectiveElementType(@NotNull @NonNls String debugName) {
        super(debugName, KtImportDirective.class, KotlinImportDirectiveStub.class);
    }

    public KotlinImportDirectiveStub createStub(@NotNull KtImportDirective psi2, StubElement parentStub) {
        FqName importedFqName = psi2.getImportedFqName();
        StringRef fqName2 = StringRef.fromString((String)(importedFqName == null ? null : importedFqName.asString()));
        return new KotlinImportDirectiveStubImpl((StubElement<PsiElement>)parentStub, psi2.isAllUnder(), fqName2, psi2.isValidImport());
    }

    public void serialize(@NotNull KotlinImportDirectiveStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        dataStream.writeBoolean(stub.isAllUnder());
        FqName importedFqName = stub.getImportedFqName();
        dataStream.writeName(importedFqName != null ? importedFqName.asString() : null);
        dataStream.writeBoolean(stub.isValid());
    }

    @NotNull
    public KotlinImportDirectiveStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        boolean isAllUnder = dataStream.readBoolean();
        StringRef importedName = dataStream.readName();
        boolean isValid2 = dataStream.readBoolean();
        return new KotlinImportDirectiveStubImpl((StubElement<PsiElement>)parentStub, isAllUnder, importedName, isValid2);
    }
}

