/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinTypeProjectionStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

public class KtTypeProjection
extends KtModifierListOwnerStub<KotlinTypeProjectionStub> {
    public KtTypeProjection(@NotNull ASTNode node) {
        super(node);
    }

    public KtTypeProjection(@NotNull KotlinTypeProjectionStub stub) {
        super(stub, KtStubElementTypes.TYPE_PROJECTION);
    }

    @NotNull
    public KtProjectionKind getProjectionKind() {
        KotlinTypeProjectionStub stub = (KotlinTypeProjectionStub)this.getStub();
        if (stub != null) {
            return stub.getProjectionKind();
        }
        PsiElement projectionToken = this.getProjectionToken();
        IElementType token = projectionToken != null ? projectionToken.getNode().getElementType() : null;
        for (KtProjectionKind projectionKind : KtProjectionKind.values()) {
            if (projectionKind.getToken() != token) continue;
            return projectionKind;
        }
        throw new IllegalStateException(projectionToken.getText());
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        return visitor2.visitTypeProjection(this, data);
    }

    @Nullable
    public KtTypeReference getTypeReference() {
        return (KtTypeReference)this.getStubOrPsiChild(KtStubElementTypes.TYPE_REFERENCE);
    }

    @Nullable
    public PsiElement getProjectionToken() {
        PsiElement star = this.findChildByType(KtTokens.MUL);
        if (star != null) {
            return star;
        }
        KtModifierList modifierList = this.getModifierList();
        if (modifierList != null) {
            PsiElement element3 = modifierList.getModifier(KtTokens.IN_KEYWORD);
            if (element3 != null) {
                return element3;
            }
            element3 = modifierList.getModifier(KtTokens.OUT_KEYWORD);
            if (element3 != null) {
                return element3;
            }
        }
        return null;
    }
}

