/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsMultipleInheritanceChecker;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsMultipleInheritanceChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "fqNames", "", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "simpleNames", "", "Lorg/jetbrains/kotlin/name/Name;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "js.frontend"})
public final class JsMultipleInheritanceChecker
implements DeclarationChecker {
    private static final List<FqNameUnsafe> fqNames;
    private static final Set<Name> simpleNames;
    public static final JsMultipleInheritanceChecker INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return;
        }
        Iterable iterable = ResolutionScope.DefaultImpls.getContributedDescriptors$default(((ClassDescriptor)descriptor2).getUnsubstitutedMemberScope(), null, check.1.INSTANCE, 1, null);
        Iterator iterator2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof CallableMemberDescriptor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (CallableMemberDescriptor callable2 : (List)destination$iv$iv) {
            boolean bl;
            block6: {
                if (callable2.getOverriddenDescriptors().size() <= 1) continue;
                Collection<? extends CallableMemberDescriptor> collection = callable2.getOverriddenDescriptors();
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"callable.overriddenDescriptors");
                $receiver$iv = collection;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        CallableMemberDescriptor it;
                        CallableMemberDescriptor callableMemberDescriptor = it = (CallableMemberDescriptor)element$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"it");
                        if (!fqNames.contains(DescriptorUtilsKt.getFqNameUnsafe(callableMemberDescriptor))) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            context.getTrace().report(ErrorsJs.WRONG_MULTIPLE_INHERITANCE.on(declaration2, callable2));
        }
    }

    private JsMultipleInheritanceChecker() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var2_2;
        void $receiver$iv;
        JsMultipleInheritanceChecker jsMultipleInheritanceChecker;
        INSTANCE = jsMultipleInheritanceChecker = new JsMultipleInheritanceChecker();
        fqNames = CollectionsKt.listOf((Object[])new FqNameUnsafe[]{new FqNameUnsafe("kotlin.CharSequence.get"), new FqNameUnsafe("kotlin.collections.CharIterator.nextChar")});
        Iterable iterable = fqNames;
        Collection destination$iv = new LinkedHashSet();
        for (Object item$iv : $receiver$iv) {
            void it;
            FqNameUnsafe fqNameUnsafe = (FqNameUnsafe)item$iv;
            Collection collection = destination$iv;
            Name name2 = it.shortName();
            collection.add(name2);
        }
        simpleNames = (Set)var2_2;
    }

    @NotNull
    public static final /* synthetic */ Set access$getSimpleNames$p(JsMultipleInheritanceChecker $this) {
        JsMultipleInheritanceChecker jsMultipleInheritanceChecker = $this;
        return simpleNames;
    }
}

