/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.util.AstUtil;

public final class JsIf
extends SourceInfoAwareJsNode
implements JsStatement {
    @NotNull
    private JsExpression ifExpression;
    @NotNull
    private JsStatement thenStatement;
    @Nullable
    private JsStatement elseStatement;

    public JsIf(@NotNull JsExpression ifExpression2, @NotNull JsStatement thenStatement, @Nullable JsStatement elseStatement) {
        this.ifExpression = ifExpression2;
        this.thenStatement = thenStatement;
        this.elseStatement = elseStatement;
    }

    public JsIf(@NotNull JsExpression ifExpression2, @NotNull JsStatement thenStatement) {
        this(ifExpression2, thenStatement, null);
    }

    @Nullable
    public JsStatement getElseStatement() {
        return this.elseStatement;
    }

    @NotNull
    public JsExpression getIfExpression() {
        return this.ifExpression;
    }

    @NotNull
    public JsStatement getThenStatement() {
        return this.thenStatement;
    }

    public void setElseStatement(@Nullable JsStatement elseStatement) {
        this.elseStatement = elseStatement;
    }

    public void setIfExpression(@NotNull JsExpression ifExpression2) {
        this.ifExpression = ifExpression2;
    }

    public void setThenStatement(@NotNull JsStatement thenStatement) {
        this.thenStatement = thenStatement;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitIf(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.accept(this.ifExpression);
        visitor2.accept(this.thenStatement);
        if (this.elseStatement != null) {
            visitor2.accept(this.elseStatement);
        }
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.ifExpression = v.accept(this.ifExpression);
            this.thenStatement = v.acceptStatement(this.thenStatement);
            if (this.elseStatement != null) {
                this.elseStatement = v.acceptStatement(this.elseStatement);
            }
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsIf deepCopy() {
        JsExpression ifCopy = AstUtil.deepCopy(this.ifExpression);
        JsStatement thenCopy = AstUtil.deepCopy(this.thenStatement);
        JsStatement elseCopy = AstUtil.deepCopy(this.elseStatement);
        return new JsIf(ifCopy, thenCopy, elseCopy).withMetadataFrom(this);
    }
}

