/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u0002*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\u0007\u001a\u00020\b*\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"typeConversionMap", "", "", "getTypeConversionMethod", "Lcom/intellij/psi/PsiExpression;", "expectedType", "Lcom/intellij/psi/PsiType;", "needTypeConversion", "", "expected", "j2k"})
public final class TypeConverterKt {
    private static final Map<String, String> typeConversionMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"java.lang.Byte", (Object)"byte"), TuplesKt.to((Object)"java.lang.Short", (Object)"short"), TuplesKt.to((Object)"java.lang.Integer", (Object)"int"), TuplesKt.to((Object)"java.lang.Long", (Object)"long"), TuplesKt.to((Object)"java.lang.Float", (Object)"float"), TuplesKt.to((Object)"java.lang.Double", (Object)"double"), TuplesKt.to((Object)"java.lang.Character", (Object)"char")});

    @Nullable
    public static final String getTypeConversionMethod(@NotNull PsiExpression $receiver, @NotNull PsiType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        PsiType psiType = $receiver.getType();
        if (psiType == null) {
            return null;
        }
        PsiType actualType = psiType;
        if (Intrinsics.areEqual((Object)actualType, (Object)expectedType)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)expectedType.getCanonicalText(), (Object)"java.lang.String")) {
            return "toString";
        }
        PsiType psiType2 = expectedType;
        return Intrinsics.areEqual((Object)psiType2, (Object)PsiType.BYTE) ? "toByte" : (Intrinsics.areEqual((Object)psiType2, (Object)PsiType.SHORT) ? "toShort" : (Intrinsics.areEqual((Object)psiType2, (Object)PsiType.INT) ? "toInt" : (Intrinsics.areEqual((Object)psiType2, (Object)PsiType.LONG) ? "toLong" : (Intrinsics.areEqual((Object)psiType2, (Object)PsiType.FLOAT) ? "toFloat" : (Intrinsics.areEqual((Object)psiType2, (Object)PsiType.DOUBLE) ? "toDouble" : (Intrinsics.areEqual((Object)psiType2, (Object)PsiType.CHAR) ? "toChar" : null))))));
    }

    public static final boolean needTypeConversion(@NotNull PsiType $receiver, @NotNull PsiType expected) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        String expectedStr = expected.getCanonicalText();
        String actualStr = $receiver.getCanonicalText();
        return Intrinsics.areEqual((Object)expectedStr, (Object)actualStr) ^ true && Intrinsics.areEqual((Object)expectedStr, (Object)typeConversionMap.get(actualStr)) ^ true && Intrinsics.areEqual((Object)actualStr, (Object)typeConversionMap.get(expectedStr)) ^ true;
    }
}

