/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.versions;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.framework.JavaRuntimeDetectionUtil;
import org.jetbrains.kotlin.idea.framework.JsLibraryStdDetectionUtil;
import org.jetbrains.kotlin.idea.versions.KotlinJVMRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.idea.versions.OutdatedKotlinRuntimeCheckerKt;
import org.jetbrains.kotlin.idea.versions.VersionedLibrary;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u001a\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004\u001a,\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00052\u001a\b\u0002\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u001a\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\u0010\u001a\u00020\r\u001a\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\rH\u0002\u001a\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\rH\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\tH\u0002\u001a\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\rH\u0002\u001a\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\rH\u0002\u001a\u0018\u0010\u0017\u001a\u00020\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0019\u001a\u00020\u0001\u001a\u001c\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\r2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001d\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"OUTDATED_RUNTIME_GROUP_DISPLAY_ID", "", "SUPPRESSED_PROPERTY_NAME", "collectModulesWithOutdatedRuntime", "", "Lcom/intellij/openapi/module/Module;", "libraries", "Lorg/jetbrains/kotlin/idea/versions/VersionedLibrary;", "findKotlinRuntimeLibrary", "Lcom/intellij/openapi/roots/libraries/Library;", "module", "predicate", "Lkotlin/Function2;", "Lcom/intellij/openapi/project/Project;", "", "findOutdatedKotlinLibraries", "project", "getKotlinLibraryVersion", "library", "getOutdatedRuntimeLibraryVersion", "isKotlinJavaRuntime", "isKotlinJsRuntime", "isKotlinRuntime", "isRuntimeOutdated", "libraryVersion", "runtimeVersion", "notifyOutdatedKotlinRuntime", "", "outdatedLibraries", "", "idea-jvm"})
public final class OutdatedKotlinRuntimeCheckerKt {
    private static final String SUPPRESSED_PROPERTY_NAME = "oudtdated.runtime.suppressed.plugin.version";
    private static final String OUTDATED_RUNTIME_GROUP_DISPLAY_ID = "Outdated Kotlin Runtime";

    @NotNull
    public static final List<VersionedLibrary> findOutdatedKotlinLibraries(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String pluginVersion = KotlinPluginUtil.getPluginVersion();
        if (KotlinPluginUtil.isSnapshotVersion()) {
            return CollectionsKt.emptyList();
        }
        if (KotlinPluginUtil.isDevVersion()) {
            return CollectionsKt.emptyList();
        }
        if (project.isDisposed()) {
            return CollectionsKt.emptyList();
        }
        if (Intrinsics.areEqual((Object)pluginVersion, (Object)PropertiesComponent.getInstance((Project)project).getValue(SUPPRESSED_PROPERTY_NAME))) {
            return CollectionsKt.emptyList();
        }
        ArrayList<VersionedLibrary> outdatedLibraries = new ArrayList<VersionedLibrary>();
        for (Map.Entry entry : KotlinRuntimeLibraryUtilKt.findAllUsedLibraries(project).entrySet()) {
            Object object = entry;
            Library library2 = (Library)object.getKey();
            object = entry;
            Collection modules = (Collection)object.getValue();
            Library library3 = library2;
            Intrinsics.checkExpressionValueIsNotNull((Object)library3, (String)"library");
            String string = OutdatedKotlinRuntimeCheckerKt.getOutdatedRuntimeLibraryVersion(library3, project);
            if (string == null) continue;
            Object version = object = string;
            Collection collection = modules;
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"modules");
            outdatedLibraries.add(new VersionedLibrary(library2, (String)version, collection));
        }
        return outdatedLibraries;
    }

    private static final String getOutdatedRuntimeLibraryVersion(Library library2, Project project) {
        String string = OutdatedKotlinRuntimeCheckerKt.getKotlinLibraryVersion(library2, project);
        if (string == null) {
            return null;
        }
        String libraryVersion = string;
        String runtimeVersion = KotlinRuntimeLibraryUtilKt.bundledRuntimeVersion();
        return OutdatedKotlinRuntimeCheckerKt.isRuntimeOutdated(libraryVersion, runtimeVersion) ? libraryVersion : null;
    }

    private static final String getKotlinLibraryVersion(Library library2, Project project) {
        String string = JavaRuntimeDetectionUtil.getJavaRuntimeVersion(library2);
        if (string == null) {
            string = JsLibraryStdDetectionUtil.INSTANCE.getJsLibraryStdVersion(library2, project);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Library findKotlinRuntimeLibrary(@NotNull Module module, @NotNull Function2<? super Library, ? super Project, Boolean> predicate2) {
        Object v4;
        block2: {
            void $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull(predicate2, (String)"predicate");
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
            Sequence sequence2 = moduleRootManager.getOrderEntries();
            Intrinsics.checkExpressionValueIsNotNull((Object)sequence2, (String)"ModuleRootManager.getInstance(module).orderEntries");
            Sequence $receiver$iv = sequence2;
            Sequence sequence3 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (void element$iv$iv : $receiver$iv$iv) {
                if (!(element$iv$iv instanceof LibraryOrderEntry)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List orderEntries = (List)destination$iv$iv;
            $receiver$iv = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)orderEntries), (Function1)findKotlinRuntimeLibrary.2.INSTANCE);
            for (Object element$iv : $receiver$iv) {
                Library it;
                Library library2 = it = (Library)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)library2, (String)"it");
                Project project = module.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
                if (!((Boolean)predicate2.invoke((Object)library2, (Object)project)).booleanValue()) continue;
                v4 = element$iv;
                break block2;
            }
            v4 = null;
        }
        return v4;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ Library findKotlinRuntimeLibrary$default(Module module, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            function2 = findKotlinRuntimeLibrary.1.INSTANCE;
        }
        return OutdatedKotlinRuntimeCheckerKt.findKotlinRuntimeLibrary(module, (Function2<? super Library, ? super Project, Boolean>)function2);
    }

    private static final boolean isKotlinRuntime(Library library2, Project project) {
        return OutdatedKotlinRuntimeCheckerKt.isKotlinJavaRuntime(library2) || OutdatedKotlinRuntimeCheckerKt.isKotlinJsRuntime(library2, project);
    }

    private static final boolean isKotlinJavaRuntime(Library library2) {
        Object[] objectArray = library2.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"library.getFiles(OrderRootType.CLASSES)");
        return JavaRuntimeDetectionUtil.getRuntimeJar(ArraysKt.asList((Object[])objectArray)) != null;
    }

    private static final boolean isKotlinJsRuntime(Library library2, Project project) {
        return JsLibraryStdDetectionUtil.hasJsStdlibJar$default(JsLibraryStdDetectionUtil.INSTANCE, library2, project, false, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Module> collectModulesWithOutdatedRuntime(@NotNull List<VersionedLibrary> libraries) {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(libraries, (String)"libraries");
        Iterable iterable = $receiver$iv = (Iterable)libraries;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            VersionedLibrary it = (VersionedLibrary)element$iv$iv;
            Iterable list$iv$iv = it.getUsedInModules();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)var3_3;
    }

    public static final void notifyOutdatedKotlinRuntime(@NotNull Project project, @NotNull Collection<VersionedLibrary> outdatedLibraries) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(outdatedLibraries, (String)"outdatedLibraries");
        String pluginVersion = KotlinPluginUtil.getPluginVersion();
        if (outdatedLibraries.size() == 1) {
            VersionedLibrary versionedLibrary = (VersionedLibrary)CollectionsKt.first((Iterable)outdatedLibraries);
            String version = versionedLibrary.getVersion();
            String string2 = version;
            if (string2 == null) {
                string2 = "unknown";
            }
            String readableVersion = string2;
            String libraryName = versionedLibrary.getLibrary().getName();
            string = "<p>Your version of Kotlin runtime in '" + libraryName + "' library is " + readableVersion + ", while plugin version is " + pluginVersion + ".</p>" + "<p>Runtime library should be updated to avoid compatibility problems.</p>" + "<p><a href=\"update\">Update Runtime</a> <a href=\"ignore\">Ignore</a></p>";
        } else {
            String libraryNames2 = CollectionsKt.joinToString$default((Iterable)outdatedLibraries, null, null, null, (int)0, null, (Function1)notifyOutdatedKotlinRuntime.message.libraryNames.1.INSTANCE, (int)31, null);
            string = "<p>Version of Kotlin runtime is outdated in several libraries (" + libraryNames2 + "). Plugin version is " + pluginVersion + ".</p>" + "<p>Runtime libraries should be updated to avoid compatibility problems.</p>" + "<p><a href=\"update\">Update All</a> <a href=\"ignore\">Ignore</a></p>";
        }
        String message2 = string;
        Notifications.Bus.notify((Notification)new Notification(OUTDATED_RUNTIME_GROUP_DISPLAY_ID, OUTDATED_RUNTIME_GROUP_DISPLAY_ID, message2, NotificationType.WARNING, new NotificationListener(project, pluginVersion){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $pluginVersion;

            /*
             * WARNING - void declaration
             */
            public final void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)notification2, (String)"notification");
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                    if (Intrinsics.areEqual((Object)"update", (Object)event.getDescription())) {
                        void $receiver$iv$iv;
                        Iterable $receiver$iv;
                        Iterable iterable = $receiver$iv = (Iterable)OutdatedKotlinRuntimeCheckerKt.findOutdatedKotlinLibraries(this.$project);
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                        for (T item$iv$iv : $receiver$iv$iv) {
                            void it;
                            VersionedLibrary versionedLibrary = (VersionedLibrary)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            Library library2 = it.getLibrary();
                            collection.add(library2);
                        }
                        List updatedOutdatedLibraries = (List)destination$iv$iv;
                        ApplicationManager.getApplication().invokeLater(new Runnable(this, updatedOutdatedLibraries){
                            final /* synthetic */ notifyOutdatedKotlinRuntime.1 this$0;
                            final /* synthetic */ List $updatedOutdatedLibraries;

                            public final void run() {
                                KotlinJVMRuntimeLibraryUtilKt.updateLibraries(this.this$0.$project, this.$updatedOutdatedLibraries);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$updatedOutdatedLibraries = list2;
                            }
                        });
                    } else if (Intrinsics.areEqual((Object)"ignore", (Object)event.getDescription())) {
                        if (!this.$project.isDisposed()) {
                            PropertiesComponent.getInstance((Project)this.$project).setValue("oudtdated.runtime.suppressed.plugin.version", this.$pluginVersion);
                        }
                    } else {
                        throw (Throwable)((Object)new AssertionError());
                    }
                    notification2.expire();
                }
            }
            {
                this.$project = project;
                this.$pluginVersion = string;
            }
        }), (Project)project);
    }

    public static final boolean isRuntimeOutdated(@Nullable String libraryVersion, @NotNull String runtimeVersion) {
        Intrinsics.checkParameterIsNotNull((Object)runtimeVersion, (String)"runtimeVersion");
        return libraryVersion == null || StringsKt.startsWith$default((String)libraryVersion, (String)"internal-", (boolean)false, (int)2, null) != StringsKt.startsWith$default((String)runtimeVersion, (String)"internal-", (boolean)false, (int)2, null) || VersionComparatorUtil.compare((String)StringsKt.substringBefore$default((String)runtimeVersion, (String)"-release-", null, (int)2, null), (String)libraryVersion) > 0;
    }

    public static final /* synthetic */ boolean access$isKotlinRuntime(@NotNull Library library2, @NotNull Project project) {
        return OutdatedKotlinRuntimeCheckerKt.isKotlinRuntime(library2, project);
    }
}

