/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.versions;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import java.io.File;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.versions.KotlinUpdatePluginComponentKt;
import org.jetbrains.kotlin.idea.versions.LibraryJarDescriptor;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/versions/KotlinUpdatePluginComponent;", "Lcom/intellij/openapi/components/ApplicationComponent;", "()V", "disposeComponent", "", "getComponentName", "", "initComponent", "requestFullJarUpdate", "jarFilePath", "Ljava/io/File;", "idea"})
public final class KotlinUpdatePluginComponent
implements ApplicationComponent {
    public void initComponent() {
        block4: {
            String installedKotlinVersion;
            Application application = ApplicationManager.getApplication();
            if (application != null) {
                if (application.isUnitTestMode()) {
                    return;
                }
            }
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
            String string = installedKotlinVersion = propertiesComponent != null ? propertiesComponent.getValue(KotlinUpdatePluginComponentKt.access$getINSTALLED_KOTLIN_VERSION$p()) : null;
            if (installedKotlinVersion != null && !(Intrinsics.areEqual((Object)KotlinPluginUtil.getPluginVersion(), (Object)installedKotlinVersion) ^ true)) break block4;
            for (LibraryJarDescriptor libraryJarDescriptor : LibraryJarDescriptor.values()) {
                this.requestFullJarUpdate(libraryJarDescriptor.getPathInPlugin());
            }
            PropertiesComponent propertiesComponent2 = PropertiesComponent.getInstance();
            if (propertiesComponent2 != null) {
                propertiesComponent2.setValue(KotlinUpdatePluginComponentKt.access$getINSTALLED_KOTLIN_VERSION$p(), KotlinPluginUtil.getPluginVersion());
            }
        }
    }

    @NotNull
    public String getComponentName() {
        return "ReindexBundledRuntimeComponent";
    }

    public void disposeComponent() {
    }

    private final void requestFullJarUpdate(File jarFilePath) {
        VirtualFile virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(jarFilePath);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile localVirtualFile = virtualFile2;
        VirtualFile virtualFile3 = JarFileSystem.getInstance().getJarRootForLocalFile(localVirtualFile);
        if (virtualFile3 == null) {
            return;
        }
        VirtualFile jarFile = virtualFile3;
        VfsUtilCore.visitChildrenRecursively((VirtualFile)jarFile, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Object>(new VirtualFileVisitor.Option[0]){}));
        VirtualFile virtualFile4 = jarFile;
        if (virtualFile4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vfs.newvfs.NewVirtualFile");
        }
        ((NewVirtualFile)virtualFile4).markDirtyRecursively();
    }
}

