/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util.projectStructure;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\\\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\r\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00010\u00010\u000e*\u00020\u0010\u001a \u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u00012\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00150\u0014\u001a \u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u00162\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00150\u0014\u001a\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u0001*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010\u001a\n\u0010\u0019\u001a\u00020\u001a*\u00020\u0001\u001a\u001a\u0010\u001b\u001a\u00020\u001c*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0017\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006!"}, d2={"module", "Lcom/intellij/openapi/module/Module;", "Lcom/intellij/psi/PsiElement;", "getModule", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/openapi/module/Module;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getSdk", "(Lcom/intellij/openapi/module/Module;)Lcom/intellij/openapi/projectRoots/Sdk;", "version", "Lcom/intellij/openapi/projectRoots/JavaSdkVersion;", "getVersion", "(Lcom/intellij/openapi/projectRoots/Sdk;)Lcom/intellij/openapi/projectRoots/JavaSdkVersion;", "allModules", "", "kotlin.jvm.PlatformType", "Lcom/intellij/openapi/project/Project;", "findLibrary", "Lcom/intellij/openapi/roots/libraries/Library;", "predicate", "Lkotlin/Function1;", "", "Lcom/intellij/openapi/roots/OrderEnumerator;", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "getModuleDir", "", "replaceFileRoot", "", "Lcom/intellij/openapi/roots/libraries/Library$ModifiableModel;", "oldFile", "Ljava/io/File;", "newFile", "idea"})
public final class ProjectStructureUtilKt {
    @NotNull
    public static final List<Module> allModules(@NotNull Project $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ModuleManager moduleManager = ModuleManager.getInstance((Project)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(this)");
        Object[] objectArray = moduleManager.getModules();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"ModuleManager.getInstance(this).modules");
        return ArraysKt.toList((Object[])objectArray);
    }

    @Nullable
    public static final Library findLibrary(@NotNull Module $receiver, @NotNull Function1<? super Library, Boolean> predicate2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(predicate2, (String)"predicate");
        OrderEnumerator orderEnumerator = OrderEnumerator.orderEntries((Module)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)orderEnumerator, (String)"OrderEnumerator.orderEntries(this)");
        return ProjectStructureUtilKt.findLibrary(orderEnumerator, predicate2);
    }

    @Nullable
    public static final Sdk getSdk(@NotNull Module $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(this)");
        return moduleRootManager.getSdk();
    }

    @Nullable
    public static final JavaSdkVersion getVersion(@NotNull Sdk $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return JavaSdk.getInstance().getVersion($receiver);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Library findLibrary(@NotNull OrderEnumerator $receiver, @NotNull Function1<? super Library, Boolean> predicate2) {
        void lib;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(predicate2, (String)"predicate");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        $receiver.forEachLibrary((Processor)new Processor<Library>(predicate2, (Ref.ObjectRef)lib){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $lib;

            public final boolean process(Library library2) {
                boolean bl;
                Library library3 = library2;
                if (library3 == null) {
                    Intrinsics.throwNpe();
                }
                if (((Boolean)this.$predicate.invoke((Object)library3)).booleanValue()) {
                    this.$lib.element = library2;
                    bl = false;
                } else {
                    bl = true;
                }
                return bl;
            }
            {
                this.$predicate = function1;
                this.$lib = objectRef;
            }
        });
        return (Library)lib.element;
    }

    @NotNull
    public static final String getModuleDir(@NotNull Module $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = new File($receiver.getModuleFilePath()).getParent();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return StringsKt.replace$default((String)string, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }

    public static final void replaceFileRoot(@NotNull Library.ModifiableModel $receiver, @NotNull File oldFile, @NotNull File newFile) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)oldFile, (String)"oldFile");
        Intrinsics.checkParameterIsNotNull((Object)newFile, (String)"newFile");
        String oldRoot = VfsUtil.getUrlForLibraryRoot((File)oldFile);
        String newRoot = VfsUtil.getUrlForLibraryRoot((File)newFile);
        Function1<OrderRootType, Unit> replaceInRootType$ = new Function1<OrderRootType, Unit>($receiver, oldRoot, newRoot){
            final /* synthetic */ Library.ModifiableModel receiver$0;
            final /* synthetic */ String $oldRoot;
            final /* synthetic */ String $newRoot;

            public final void invoke(@NotNull OrderRootType rootType) {
                Intrinsics.checkParameterIsNotNull((Object)rootType, (String)"rootType");
                for (String url : this.receiver$0.getUrls(rootType)) {
                    if (!Intrinsics.areEqual((Object)this.$oldRoot, (Object)url)) continue;
                    this.receiver$0.removeRoot(url, rootType);
                    this.receiver$0.addRoot(this.$newRoot, rootType);
                }
            }
            {
                this.receiver$0 = modifiableModel;
                this.$oldRoot = string;
                this.$newRoot = string2;
                super(1);
            }
        };
        OrderRootType orderRootType = OrderRootType.CLASSES;
        Intrinsics.checkExpressionValueIsNotNull((Object)orderRootType, (String)"OrderRootType.CLASSES");
        replaceInRootType$.invoke(orderRootType);
        OrderRootType orderRootType2 = OrderRootType.SOURCES;
        Intrinsics.checkExpressionValueIsNotNull((Object)orderRootType2, (String)"OrderRootType.SOURCES");
        replaceInRootType$.invoke(orderRootType2);
    }

    @Nullable
    public static final Module getModule(@NotNull VirtualFile $receiver, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return ModuleUtilCore.findModuleForFile((VirtualFile)$receiver, (Project)project);
    }

    @Nullable
    public static final Module getModule(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return ModuleUtilCore.findModuleForPsiElement((PsiElement)$receiver);
    }
}

