/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesManager;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0007J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/util/ProjectRootsUtil;", "", "()V", "isInContent", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "includeProjectSource", "includeLibrarySource", "includeLibraryClasses", "includeScriptDependencies", "fileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "element", "Lcom/intellij/psi/PsiElement;", "isInProjectOrLibSource", "isInProjectOrLibraryClassFile", "isInProjectOrLibraryContent", "isInProjectSource", "isLibraryClassFile", "isLibraryFile", "isLibrarySourceFile", "isProjectSourceFile", "idea-core"})
public final class ProjectRootsUtil {
    public static final ProjectRootsUtil INSTANCE;

    @JvmStatic
    public static final boolean isInContent(@NotNull Project project, @NotNull VirtualFile file2, boolean includeProjectSource, boolean includeLibrarySource, boolean includeLibraryClasses, boolean includeScriptDependencies, @NotNull ProjectFileIndex fileIndex) {
        ScriptDependenciesManager scriptConfigurationManager;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)fileIndex, (String)"fileIndex");
        if (includeProjectSource && ProjectRootsUtilKt.isInSourceContentWithoutInjected((FileIndex)fileIndex, file2)) {
            return true;
        }
        if (!includeLibraryClasses && !includeLibrarySource) {
            return false;
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(file2.getName());
        boolean canContainClassFiles = Intrinsics.areEqual((Object)fileType, (Object)ArchiveFileType.INSTANCE) || file2.isDirectory();
        FileType fileType2 = fileType;
        Intrinsics.checkExpressionValueIsNotNull((Object)fileType2, (String)"fileType");
        boolean isBinary = ProjectRootsUtilKt.isKotlinBinary(fileType2);
        ScriptDependenciesManager scriptDependenciesManager = scriptConfigurationManager = includeScriptDependencies ? ScriptDependenciesManager.Companion.getInstance(project) : null;
        if (includeLibraryClasses && (isBinary || canContainClassFiles)) {
            if (fileIndex.isInLibraryClasses(file2)) {
                return true;
            }
            ScriptDependenciesManager scriptDependenciesManager2 = scriptConfigurationManager;
            if (scriptDependenciesManager2 != null && (scriptDependenciesManager2 = scriptDependenciesManager2.getAllScriptsClasspathScope()) != null) {
                if (scriptDependenciesManager2.contains(file2)) {
                    return true;
                }
            }
        }
        if (includeLibrarySource && !isBinary) {
            if (fileIndex.isInLibrarySource(file2)) {
                return true;
            }
            ScriptDependenciesManager scriptDependenciesManager3 = scriptConfigurationManager;
            if (scriptDependenciesManager3 != null && (scriptDependenciesManager3 = scriptDependenciesManager3.getAllLibrarySourcesScope()) != null) {
                if (scriptDependenciesManager3.contains(file2)) {
                    return true;
                }
            }
        }
        return false;
    }

    @JvmStatic
    public static /* bridge */ /* synthetic */ boolean isInContent$default(Project project, VirtualFile virtualFile2, boolean bl, boolean bl2, boolean bl3, boolean bl4, ProjectFileIndex projectFileIndex, int n, Object object) {
        if ((n & 0x40) != 0) {
            ProjectFileIndex projectFileIndex2 = ProjectFileIndex.SERVICE.getInstance((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)projectFileIndex2, (String)"ProjectFileIndex.SERVICE.getInstance(project)");
            projectFileIndex = projectFileIndex2;
        }
        return ProjectRootsUtil.isInContent(project, virtualFile2, bl, bl2, bl3, bl4, projectFileIndex);
    }

    @JvmStatic
    public static final boolean isInContent(@NotNull PsiElement element3, boolean includeProjectSource, boolean includeLibrarySource, boolean includeLibraryClasses, boolean includeScriptDependencies) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(element3, includeProjectSource, includeLibrarySource, includeLibraryClasses, includeScriptDependencies){
            final /* synthetic */ PsiElement $element;
            final /* synthetic */ boolean $includeProjectSource;
            final /* synthetic */ boolean $includeLibrarySource;
            final /* synthetic */ boolean $includeLibraryClasses;
            final /* synthetic */ boolean $includeScriptDependencies;

            public final boolean invoke() {
                Project project;
                Object object;
                PsiElement psiElement2 = this.$element;
                if (psiElement2 instanceof PsiDirectory) {
                    object = ((PsiDirectory)this.$element).getVirtualFile();
                } else {
                    PsiFile psiFile = this.$element.getContainingFile();
                    object = psiFile != null ? psiFile.getVirtualFile() : null;
                }
                if (object == null) {
                    return false;
                }
                VirtualFile virtualFile2 = object;
                Project project2 = project = this.$element.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                return ProjectRootsUtil.isInContent$default(project2, virtualFile2, this.$includeProjectSource, this.$includeLibrarySource, this.$includeLibraryClasses, this.$includeScriptDependencies, null, 64, null);
            }
            {
                this.$element = psiElement2;
                this.$includeProjectSource = bl;
                this.$includeLibrarySource = bl2;
                this.$includeLibraryClasses = bl3;
                this.$includeScriptDependencies = bl4;
                super(0);
            }
        });
    }

    @JvmStatic
    public static final boolean isInProjectSource(@NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return ProjectRootsUtil.isInContent(element3, true, false, false, false);
    }

    @JvmStatic
    public static final boolean isProjectSourceFile(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return ProjectRootsUtil.isInContent$default(project, file2, true, false, false, false, null, 64, null);
    }

    @JvmStatic
    public static final boolean isInProjectOrLibSource(@NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return ProjectRootsUtil.isInContent(element3, true, true, false, false);
    }

    @JvmStatic
    public static final boolean isInProjectOrLibraryContent(@NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return ProjectRootsUtil.isInContent(element3, true, true, true, true);
    }

    @JvmStatic
    public static final boolean isInProjectOrLibraryClassFile(@NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return ProjectRootsUtil.isInContent(element3, true, false, true, false);
    }

    @JvmStatic
    public static final boolean isLibraryClassFile(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return ProjectRootsUtil.isInContent$default(project, file2, false, false, true, true, null, 64, null);
    }

    @JvmStatic
    public static final boolean isLibrarySourceFile(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return ProjectRootsUtil.isInContent$default(project, file2, false, true, false, true, null, 64, null);
    }

    @JvmStatic
    public static final boolean isLibraryFile(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return ProjectRootsUtil.isInContent$default(project, file2, false, true, true, true, null, 64, null);
    }

    private ProjectRootsUtil() {
    }

    static {
        ProjectRootsUtil projectRootsUtil;
        INSTANCE = projectRootsUtil = new ProjectRootsUtil();
    }
}

