/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.stubindex.resolve;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Processor;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.idea.caches.PerModulePackageCacheService;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfosKt;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.stubindex.KotlinExactPackagesIndex;
import org.jetbrains.kotlin.idea.stubindex.PackageIndexUtil;
import org.jetbrains.kotlin.idea.stubindex.SubpackagesIndexService;
import org.jetbrains.kotlin.idea.stubindex.resolve.StubBasedPackageMemberDeclarationProvider;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassLikeInfo;
import org.jetbrains.kotlin.resolve.lazy.declarations.AbstractDeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.CombinedPackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.PsiBasedClassMemberDeclarationProvider;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0011H\u0002J\u0006\u0010\u0017\u001a\u00020\u0011J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0017\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010)J\u0010\u0010*\u001a\u00020'2\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\u0010\u0010+\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/idea/stubindex/resolve/PluginDeclarationProviderFactory;", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/AbstractDeclarationProviderFactory;", "project", "Lcom/intellij/openapi/project/Project;", "indexedFilesScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "nonIndexedFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "moduleInfo", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;Lorg/jetbrains/kotlin/storage/StorageManager;Ljava/util/Collection;Lorg/jetbrains/kotlin/analyzer/ModuleInfo;)V", "fileBasedDeclarationProviderFactory", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory;", "onCreationDebugInfo", "", "createPackageMemberDeclarationProvider", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/PackageMemberDeclarationProvider;", "name", "Lorg/jetbrains/kotlin/name/FqName;", "debugInfo", "debugToString", "diagnoseMissingPackageFragment", "", "fqName", "file", "diagnoseMissingPackageFragmentExactPackageIndexCorruption", "", "message", "diagnoseMissingPackageFragmentPerModulePackageCacheMiss", "diagnoseMissingPackageFragmentUnknownReason", "getClassMemberDeclarationProvider", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/ClassMemberDeclarationProvider;", "classLikeInfo", "Lorg/jetbrains/kotlin/resolve/lazy/data/KtClassLikeInfo;", "getStubBasedPackageMemberDeclarationProvider", "oldPackageExists", "", "packageFqName", "(Lorg/jetbrains/kotlin/name/FqName;)Ljava/lang/Boolean;", "packageExists", "stubBasedPackageExists", "idea-core"})
public final class PluginDeclarationProviderFactory
extends AbstractDeclarationProviderFactory {
    private final FileBasedDeclarationProviderFactory fileBasedDeclarationProviderFactory;
    private final String onCreationDebugInfo;
    private final Project project;
    private final GlobalSearchScope indexedFilesScope;
    private final StorageManager storageManager;
    private final Collection<KtFile> nonIndexedFiles;
    private final ModuleInfo moduleInfo;

    @Override
    @NotNull
    public ClassMemberDeclarationProvider getClassMemberDeclarationProvider(@NotNull KtClassLikeInfo classLikeInfo) {
        Intrinsics.checkParameterIsNotNull((Object)classLikeInfo, (String)"classLikeInfo");
        return new PsiBasedClassMemberDeclarationProvider(this.storageManager, classLikeInfo);
    }

    @Override
    @Nullable
    protected PackageMemberDeclarationProvider createPackageMemberDeclarationProvider(@NotNull FqName name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        PackageMemberDeclarationProvider fileBasedProvider = this.fileBasedDeclarationProviderFactory.getPackageMemberDeclarationProvider(name2);
        PackageMemberDeclarationProvider stubBasedProvider = this.getStubBasedPackageMemberDeclarationProvider(name2);
        return fileBasedProvider == null && stubBasedProvider == null ? null : (fileBasedProvider == null ? stubBasedProvider : (stubBasedProvider == null ? fileBasedProvider : (PackageMemberDeclarationProvider)new CombinedPackageMemberDeclarationProvider(CollectionsKt.listOf((Object[])new PackageMemberDeclarationProvider[]{stubBasedProvider, fileBasedProvider}))));
    }

    @Override
    public boolean packageExists(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        return this.fileBasedDeclarationProviderFactory.packageExists(fqName2) || this.stubBasedPackageExists(fqName2);
    }

    private final boolean stubBasedPackageExists(FqName name2) {
        boolean bl;
        block6: {
            Object object;
            ModuleInfo moduleInfo = this.moduleInfo;
            if (!(moduleInfo instanceof IdeaModuleInfo)) {
                moduleInfo = null;
            }
            if ((object = (IdeaModuleInfo)moduleInfo) != null && (object = IdeaModuleInfosKt.projectSourceModules((IdeaModuleInfo)object)) != null) {
                Iterable $receiver$iv = (Iterable)object;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        ModuleSourceInfo it = (ModuleSourceInfo)element$iv;
                        if (!PerModulePackageCacheService.Companion.getInstance(this.project).packageExists(name2, it)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final PackageMemberDeclarationProvider getStubBasedPackageMemberDeclarationProvider(FqName name2) {
        if (!this.stubBasedPackageExists(name2)) {
            return null;
        }
        return new StubBasedPackageMemberDeclarationProvider(name2, this.project, this.indexedFilesScope);
    }

    private final Void diagnoseMissingPackageFragmentExactPackageIndexCorruption(String message2) {
        throw (Throwable)new IllegalStateException("KotlinExactPackageIndex seems corrupted.\n" + message2);
    }

    private final Void diagnoseMissingPackageFragmentPerModulePackageCacheMiss(String message2) {
        throw (Throwable)new IllegalStateException("PerModulePackageCache miss.\n" + message2);
    }

    private final Void diagnoseMissingPackageFragmentUnknownReason(String message2) {
        throw (Throwable)new IllegalStateException(message2);
    }

    @Override
    public void diagnoseMissingPackageFragment(@NotNull FqName fqName2, @Nullable KtFile file2) {
        boolean scopeNotEmptyAndContainsFile;
        String string;
        Boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        SubpackagesIndexService.SubpackagesIndex subpackagesIndex = SubpackagesIndexService.Companion.getInstance(this.project);
        ModuleInfo moduleInfo = this.moduleInfo;
        if (!(moduleInfo instanceof ModuleSourceInfo)) {
            moduleInfo = null;
        }
        ModuleSourceInfo moduleSourceInfo = (ModuleSourceInfo)moduleInfo;
        boolean packageExists = PackageIndexUtil.packageExists(fqName2, this.indexedFilesScope, this.project);
        boolean spiPackageExists = subpackagesIndex.packageExists(fqName2);
        Boolean oldPackageExists2 = this.oldPackageExists(fqName2);
        ModuleSourceInfo moduleSourceInfo2 = moduleSourceInfo;
        if (moduleSourceInfo2 != null) {
            ModuleSourceInfo moduleSourceInfo3;
            ModuleSourceInfo it = moduleSourceInfo3 = moduleSourceInfo2;
            bl = ((PerModulePackageCacheService)ServiceManager.getService((Project)this.project, PerModulePackageCacheService.class)).packageExists(fqName2, it);
        } else {
            bl = null;
        }
        Boolean cachedPackageExists = bl;
        ModuleSourceInfo moduleSourceInfo4 = moduleSourceInfo;
        Long moduleModificationCount = moduleSourceInfo4 != null && (moduleSourceInfo4 = moduleSourceInfo4.createModificationTracker()) != null ? Long.valueOf(moduleSourceInfo4.getModificationCount()) : null;
        StringBuilder stringBuilder = new StringBuilder().append("\n                packageExists = ").append(packageExists).append(", cachedPackageExists = ").append(cachedPackageExists).append(",\n                oldPackageExists = ").append(oldPackageExists2).append(",\n                SPI.packageExists = ").append(spiPackageExists).append(", SPI = ").append(subpackagesIndex).append(",\n                OOCB count = ");
        PsiManager psiManager = PsiManager.getInstance((Project)this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"PsiManager.getInstance(project)");
        PsiModificationTracker psiModificationTracker = psiManager.getModificationTracker();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiModificationTracker, (String)"PsiManager.getInstance(p\u2026ject).modificationTracker");
        String common = StringsKt.trimIndent((String)stringBuilder.append(psiModificationTracker.getOutOfCodeBlockModificationCount()).append("\n                moduleModificationCount = ").append(moduleModificationCount).append("\n            ").toString());
        if (file2 != null) {
            VirtualFile virtualFile2 = file2.getVirtualFile();
            boolean inScope = this.indexedFilesScope.contains(virtualFile2);
            FqName packageFqName = file2.getPackageFqName();
            KtPackageDirective ktPackageDirective = file2.getPackageDirective();
            string = StringsKt.trimMargin$default((String)("\n                |Cannot find package fragment '" + fqName2 + "' for file " + file2.getName() + ", file package = '" + packageFqName + "':\n                |vFile: " + virtualFile2 + ",\n                |nonIndexedFiles = " + this.nonIndexedFiles + ", isNonIndexed = " + this.nonIndexedFiles.contains(file2) + ",\n                |scope = " + this.indexedFilesScope + ", isInScope = " + inScope + ",\n                |" + common + ",\n                |packageFqNameByTree = '" + file2.getPackageFqNameByTree() + "', packageDirectiveText = '" + (ktPackageDirective != null ? ktPackageDirective.getText() : null) + "'\n            "), null, (int)1, null);
        } else {
            string = StringsKt.trimMargin$default((String)("\n                |Cannot find package fragment '" + fqName2 + "' for unspecified file:\n                |nonIndexedFiles = " + this.nonIndexedFiles + ",\n                |scope = " + this.indexedFilesScope + ",\n                |" + common + "\n            "), null, (int)1, null);
        }
        String message2 = string;
        boolean bl2 = scopeNotEmptyAndContainsFile = Intrinsics.areEqual((Object)this.indexedFilesScope, (Object)GlobalSearchScope.EMPTY_SCOPE) ^ true && (file2 == null || this.indexedFilesScope.contains(file2.getVirtualFile()));
        if (scopeNotEmptyAndContainsFile && !packageExists && Intrinsics.areEqual((Object)oldPackageExists2, (Object)false)) {
            Void void_ = this.diagnoseMissingPackageFragmentExactPackageIndexCorruption(message2);
            throw null;
        }
        if (scopeNotEmptyAndContainsFile && packageExists && Intrinsics.areEqual((Object)cachedPackageExists, (Object)false)) {
            Void void_ = this.diagnoseMissingPackageFragmentPerModulePackageCacheMiss(message2);
            throw null;
        }
        Void void_ = this.diagnoseMissingPackageFragmentUnknownReason(message2);
        throw null;
    }

    @NotNull
    public final String debugToString() {
        return "PluginDeclarationProviderFactory\nOn failure:\n" + this.debugInfo() + "On creation:\n" + this.onCreationDebugInfo;
    }

    /*
     * WARNING - void declaration
     */
    private final Boolean oldPackageExists(FqName packageFqName) {
        Object object;
        try {
            void result2;
            object = new Ref.BooleanRef();
            object.element = false;
            StubIndex stubIndex = StubIndex.getInstance();
            KotlinExactPackagesIndex kotlinExactPackagesIndex = KotlinExactPackagesIndex.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinExactPackagesIndex), (String)"KotlinExactPackagesIndex.getInstance()");
            stubIndex.processElements(kotlinExactPackagesIndex.getKey(), (Object)packageFqName.asString(), this.project, this.indexedFilesScope, KtFile.class, (Processor)new Processor<KtFile>((Ref.BooleanRef)result2){
                final /* synthetic */ Ref.BooleanRef $result;

                public final boolean process(KtFile it) {
                    this.$result.element = true;
                    return false;
                }
                {
                    this.$result = booleanRef;
                }
            });
            object = result2.element;
        }
        catch (Throwable e) {
            object = null;
        }
        return object;
    }

    private final String debugInfo() {
        StringBuilder stringBuilder;
        if (this.nonIndexedFiles.isEmpty()) {
            return "-no synthetic files-\n";
        }
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        Iterable $receiver$iv = this.nonIndexedFiles;
        for (Object element$iv : $receiver$iv) {
            KtFile it = (KtFile)element$iv;
            $receiver.append(it.getName());
            $receiver.append(" isPhysical=" + it.isPhysical());
            $receiver.append(" modStamp=" + it.getModificationStamp());
            StringsKt.appendln((StringBuilder)$receiver);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public PluginDeclarationProviderFactory(@NotNull Project project, @NotNull GlobalSearchScope indexedFilesScope, @NotNull StorageManager storageManager, @NotNull Collection<? extends KtFile> nonIndexedFiles, @NotNull ModuleInfo moduleInfo) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)indexedFilesScope, (String)"indexedFilesScope");
        Intrinsics.checkParameterIsNotNull((Object)storageManager, (String)"storageManager");
        Intrinsics.checkParameterIsNotNull(nonIndexedFiles, (String)"nonIndexedFiles");
        Intrinsics.checkParameterIsNotNull((Object)moduleInfo, (String)"moduleInfo");
        super(storageManager);
        this.project = project;
        this.indexedFilesScope = indexedFilesScope;
        this.storageManager = storageManager;
        this.nonIndexedFiles = nonIndexedFiles;
        this.moduleInfo = moduleInfo;
        this.fileBasedDeclarationProviderFactory = new FileBasedDeclarationProviderFactory(this.storageManager, this.nonIndexedFiles);
        this.onCreationDebugInfo = this.debugInfo();
    }
}

