/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.ideaExtensions;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.util.JavaResolutionUtils;
import org.jetbrains.kotlin.idea.search.SearchUtilKt;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.synthetic.JavaSyntheticPropertiesScope;
import org.jetbrains.kotlin.synthetic.JavaSyntheticPropertiesScopeKt;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0018\u0010\b\u001a\u0014\u0012\u0006\b\u0000\u0012\u00020\u00020\tj\b\u0012\u0004\u0012\u00020\u0002`\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinPropertyAccessorsReferenceSearcher;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/PsiReference;", "Lcom/intellij/psi/search/searches/MethodReferencesSearch$SearchParameters;", "()V", "processQuery", "", "queryParameters", "consumer", "Lcom/intellij/util/Processor;", "Lorg/jetbrains/kotlin/compatibility/ExecutorProcessor;", "propertyName", "", "method", "Lcom/intellij/psi/PsiMethod;", "idea"})
public final class KotlinPropertyAccessorsReferenceSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer2) {
        Intrinsics.checkParameterIsNotNull((Object)queryParameters, (String)"queryParameters");
        Intrinsics.checkParameterIsNotNull(consumer2, (String)"consumer");
        PsiMethod method = queryParameters.getMethod();
        SearchScope searchScope2 = queryParameters.getEffectiveSearchScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)searchScope2, (String)"queryParameters.effectiveSearchScope");
        SearchScope onlyKotlinFiles = SearchUtilKt.restrictToKotlinSources(searchScope2);
        if (Intrinsics.areEqual((Object)onlyKotlinFiles, (Object)GlobalSearchScope.EMPTY_SCOPE)) {
            return;
        }
        PsiMethod psiMethod = method;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"method");
        String string = this.propertyName(psiMethod);
        if (string == null) {
            return;
        }
        String propertyName = string;
        SearchRequestCollector searchRequestCollector = queryParameters.getOptimizer();
        if (searchRequestCollector == null) {
            Intrinsics.throwNpe();
        }
        searchRequestCollector.searchWord(propertyName, onlyKotlinFiles, (short)1, true, (PsiElement)method);
    }

    private final String propertyName(PsiMethod method) {
        PsiNamedElement unwrapped = LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)method);
        if (unwrapped instanceof KtProperty) {
            return unwrapped.getName();
        }
        String string = method.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name");
        if (!JavaSyntheticPropertiesScopeKt.canBePropertyAccessor(string)) {
            return null;
        }
        FunctionDescriptor functionDescriptor2 = JavaResolutionUtils.getJavaMethodDescriptor(method);
        if (functionDescriptor2 == null) {
            return null;
        }
        FunctionDescriptor functionDescriptor3 = functionDescriptor2;
        JavaSyntheticPropertiesScope syntheticExtensionsScope = new JavaSyntheticPropertiesScope(new LockBasedStorageManager(), LookupTracker.DO_NOTHING.INSTANCE);
        SyntheticJavaPropertyDescriptor syntheticJavaPropertyDescriptor = SyntheticJavaPropertyDescriptor.Companion.findByGetterOrSetter(functionDescriptor3, syntheticExtensionsScope);
        if (syntheticJavaPropertyDescriptor == null) {
            return null;
        }
        SyntheticJavaPropertyDescriptor property2 = syntheticJavaPropertyDescriptor;
        return property2.getName().asString();
    }

    public KotlinPropertyAccessorsReferenceSearcher() {
        super(true);
    }
}

