/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.ideaExtensions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.caches.lightClasses.KtFakeLightClass;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchKt;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0018\u0010\b\u001a\u0014\u0012\u0006\b\u0000\u0012\u00020\u00020\tj\b\u0012\u0004\u0012\u00020\u0002`\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher;", "Lcom/intellij/util/QueryExecutor;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/psi/search/searches/DefinitionsScopedSearch$SearchParameters;", "()V", "execute", "", "queryParameters", "consumer", "Lcom/intellij/util/Processor;", "Lorg/jetbrains/kotlin/compatibility/ExecutorProcessor;", "Companion", "idea"})
public final class KotlinDefinitionsSearcher
implements QueryExecutor<PsiElement, DefinitionsScopedSearch.SearchParameters> {
    public static final Companion Companion = new Companion(null);

    public boolean execute(@NotNull DefinitionsScopedSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiElement> consumer2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)queryParameters, (String)"queryParameters");
        Intrinsics.checkParameterIsNotNull(consumer2, (String)"consumer");
        Processor consumer3 = KotlinDefinitionsSearcher.Companion.skipDelegatedMethodsConsumer((Processor<? super PsiElement>)consumer2);
        PsiElement element3 = queryParameters.getElement();
        SearchScope scope2 = queryParameters.getScope();
        PsiElement psiElement2 = element3;
        if (psiElement2 instanceof KtClass) {
            PsiElement psiElement3 = element3;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"element");
            bl = KotlinDefinitionsSearcher.Companion.processClassImplementations((KtClass)psiElement3, (Processor<PsiElement>)consumer3) && KotlinDefinitionsSearcher.Companion.processActualDeclarations((KtDeclaration)element3, (Processor<PsiElement>)consumer3);
        } else if (psiElement2 instanceof KtLightClass) {
            SearchScope useScope2 = (SearchScope)ApplicationUtilsKt.runReadAction((Function0)new Function0<SearchScope>(element3){
                final /* synthetic */ PsiElement $element;

                @NotNull
                public final SearchScope invoke() {
                    PsiElement psiElement2 = this.$element;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element");
                    return ((KtLightClass)psiElement2).getUseScope();
                }
                {
                    this.$element = psiElement2;
                    super(0);
                }
            });
            if (useScope2 instanceof LocalSearchScope) {
                PsiElement psiElement4 = element3;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"element");
                bl = KotlinDefinitionsSearcher.Companion.processLightClassLocalImplementations((KtLightClass)psiElement4, (LocalSearchScope)useScope2, (Processor<PsiElement>)consumer3);
            } else {
                bl = true;
            }
        } else if (psiElement2 instanceof KtNamedFunction || psiElement2 instanceof KtSecondaryConstructor) {
            PsiElement psiElement5 = element3;
            if (psiElement5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
            }
            KtFunction ktFunction = (KtFunction)psiElement5;
            SearchScope searchScope2 = scope2;
            Intrinsics.checkExpressionValueIsNotNull((Object)searchScope2, (String)"scope");
            bl = KotlinDefinitionsSearcher.Companion.processFunctionImplementations(ktFunction, searchScope2, (Processor<PsiElement>)consumer3) && KotlinDefinitionsSearcher.Companion.processActualDeclarations((KtDeclaration)element3, (Processor<PsiElement>)consumer3);
        } else if (psiElement2 instanceof KtProperty) {
            PsiElement psiElement6 = element3;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement6, (String)"element");
            KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)psiElement6;
            SearchScope searchScope3 = scope2;
            Intrinsics.checkExpressionValueIsNotNull((Object)searchScope3, (String)"scope");
            bl = KotlinDefinitionsSearcher.Companion.processPropertyImplementations(ktNamedDeclaration, searchScope3, (Processor<PsiElement>)consumer3) && KotlinDefinitionsSearcher.Companion.processActualDeclarations((KtDeclaration)element3, (Processor<PsiElement>)consumer3);
        } else if (psiElement2 instanceof KtParameter) {
            PsiElement psiElement7 = element3;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement7, (String)"element");
            if (KotlinDefinitionsSearcher.Companion.isFieldParameter((KtParameter)psiElement7)) {
                KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)element3;
                SearchScope searchScope4 = scope2;
                Intrinsics.checkExpressionValueIsNotNull((Object)searchScope4, (String)"scope");
                bl = KotlinDefinitionsSearcher.Companion.processPropertyImplementations(ktNamedDeclaration, searchScope4, (Processor<PsiElement>)consumer3) && KotlinDefinitionsSearcher.Companion.processActualDeclarations((KtDeclaration)element3, (Processor<PsiElement>)consumer3);
            } else {
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eH\u0002J\u001e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eH\u0002J&\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eH\u0002J&\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eH\u0002J&\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eH\u0002J*\u0010\u001e\u001a\u00020\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eJ(\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u0018\u0010#\u001a\u0014\u0012\u0006\b\u0000\u0012\u00020\u00060\u000ej\b\u0012\u0004\u0012\u00020\u0006`$H\u0002\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher$Companion;", "", "()V", "isDelegated", "", "element", "Lcom/intellij/psi/PsiElement;", "isFieldParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "processActualDeclarations", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "consumer", "Lcom/intellij/util/Processor;", "processClassImplementations", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "processFunctionImplementations", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "scope", "Lcom/intellij/psi/search/SearchScope;", "processLightClassLocalImplementations", "psiClass", "Lorg/jetbrains/kotlin/asJava/classes/KtLightClass;", "searchScope", "Lcom/intellij/psi/search/LocalSearchScope;", "processPropertyImplementations", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "processPropertyImplementationsMethods", "accessors", "", "Lcom/intellij/psi/PsiMethod;", "skipDelegatedMethodsConsumer", "baseConsumer", "Lorg/jetbrains/kotlin/compatibility/ExecutorProcessor;", "idea"})
    public static final class Companion {
        private final Processor<PsiElement> skipDelegatedMethodsConsumer(Processor<? super PsiElement> baseConsumer) {
            return (Processor)new Processor<PsiElement>(baseConsumer){
                final /* synthetic */ Processor $baseConsumer;

                public final boolean process(PsiElement element3) {
                    PsiElement psiElement2 = element3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element");
                    if (org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinDefinitionsSearcher$Companion.access$isDelegated(KotlinDefinitionsSearcher.Companion, psiElement2)) {
                        return true;
                    }
                    return this.$baseConsumer.process((Object)element3);
                }
                {
                    this.$baseConsumer = processor2;
                }
            };
        }

        private final boolean isDelegated(PsiElement element3) {
            return element3 instanceof KtLightMethod && ((KtLightMethod)element3).isDelegated();
        }

        private final boolean isFieldParameter(KtParameter parameter) {
            return (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(parameter){
                final /* synthetic */ KtParameter $parameter;

                public final boolean invoke() {
                    return KtPsiUtil.getClassIfParameterIsProperty(this.$parameter) != null;
                }
                {
                    this.$parameter = ktParameter;
                    super(0);
                }
            });
        }

        private final boolean processClassImplementations(KtClass klass2, Processor<PsiElement> consumer2) {
            KtLightClass psiClass2 = (KtLightClass)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtLightClass>(klass2){
                final /* synthetic */ KtClass $klass;

                @NotNull
                public final KtLightClass invoke() {
                    KtLightClass ktLightClass = LightClassUtilsKt.toLightClass(this.$klass);
                    if (ktLightClass == null) {
                        ktLightClass = new KtFakeLightClass(this.$klass);
                    }
                    return ktLightClass;
                }
                {
                    this.$klass = ktClass2;
                    super(0);
                }
            });
            SearchScope searchScope2 = (SearchScope)ApplicationUtilsKt.runReadAction((Function0)new Function0<SearchScope>(psiClass2){
                final /* synthetic */ KtLightClass $psiClass;

                @NotNull
                public final SearchScope invoke() {
                    return this.$psiClass.getUseScope();
                }
                {
                    this.$psiClass = ktLightClass;
                    super(0);
                }
            });
            if (searchScope2 instanceof LocalSearchScope) {
                return this.processLightClassLocalImplementations(psiClass2, (LocalSearchScope)searchScope2, consumer2);
            }
            return ContainerUtil.process((Iterable)((Iterable)ClassInheritorsSearch.search((PsiClass)psiClass2, (boolean)true)), consumer2);
        }

        /*
         * WARNING - void declaration
         */
        private final boolean processLightClassLocalImplementations(KtLightClass psiClass2, LocalSearchScope searchScope2, Processor<PsiElement> consumer2) {
            void $receiver$iv;
            PsiElement[] psiElementArray = searchScope2.getScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElementArray, (String)"searchScope.scope");
            PsiElement[] psiElementArray2 = psiElementArray;
            Collection destination$iv = new HashSet();
            int n = ((void)$receiver$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv;
                void var10_9 = item$iv = $receiver$iv[i];
                Collection collection = destination$iv;
                void v1 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                PsiFile psiFile = v1.getContainingFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"it.containingFile");
                VirtualFile virtualFile2 = psiFile.getVirtualFile();
                collection.add(virtualFile2);
            }
            HashSet virtualFiles = (HashSet)destination$iv;
            GlobalSearchScope globalScope = GlobalSearchScope.filesScope((Project)psiClass2.getProject(), (Collection)virtualFiles);
            return ContainerUtil.process((Iterable)((Iterable)ClassInheritorsSearch.search((PsiClass)psiClass2, (SearchScope)((SearchScope)globalScope), (boolean)true)), (Processor)((Processor)new Processor<PsiClass>(searchScope2, consumer2){
                final /* synthetic */ LocalSearchScope $searchScope;
                final /* synthetic */ Processor $consumer;

                public final boolean process(PsiClass candidate) {
                    PsiClass psiClass2 = candidate;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiClass2, (String)"candidate");
                    PsiElement psiElement2 = LightClassUtilsKt.getUnwrapped((PsiElement)psiClass2);
                    if (psiElement2 == null) {
                        psiElement2 = (PsiElement)candidate;
                    }
                    PsiElement candidateOrigin = psiElement2;
                    SearchScope searchScope2 = (SearchScope)this.$searchScope;
                    PsiElement psiElement3 = candidateOrigin;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"candidateOrigin");
                    return PsiUtilsKt.contains(searchScope2, psiElement3) ? this.$consumer.process((Object)candidate) : true;
                }
                {
                    this.$searchScope = localSearchScope;
                    this.$consumer = processor2;
                }
            }));
        }

        private final boolean processFunctionImplementations(KtFunction function2, SearchScope scope2, Processor<PsiElement> consumer2) {
            return (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(function2, scope2, consumer2){
                final /* synthetic */ KtFunction $function;
                final /* synthetic */ SearchScope $scope;
                final /* synthetic */ Processor $consumer;

                public final boolean invoke() {
                    PsiMethod psiMethod = (PsiMethod)CollectionsKt.firstOrNull(OverridersSearchKt.toPossiblyFakeLightMethods(this.$function));
                    return psiMethod != null ? OverridersSearchKt.forEachImplementation(psiMethod, this.$scope, (Function1<? super PsiElement, Boolean>)((Function1)new Function1<PsiElement, Boolean>(this.$consumer){

                        public final boolean invoke(PsiElement p1) {
                            return ((Processor)this.receiver).process((Object)p1);
                        }

                        public final KDeclarationContainer getOwner() {
                            return Reflection.getOrCreateKotlinClass(Processor.class);
                        }

                        public final String getName() {
                            return "process";
                        }

                        public final String getSignature() {
                            return "process(Ljava/lang/Object;)Z";
                        }
                    })) : true;
                }
                {
                    this.$function = ktFunction;
                    this.$scope = searchScope2;
                    this.$consumer = processor2;
                    super(0);
                }
            });
        }

        private final boolean processPropertyImplementations(KtNamedDeclaration declaration2, SearchScope scope2, Processor<PsiElement> consumer2) {
            return (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(declaration2, scope2, consumer2){
                final /* synthetic */ KtNamedDeclaration $declaration;
                final /* synthetic */ SearchScope $scope;
                final /* synthetic */ Processor $consumer;

                public final boolean invoke() {
                    return KotlinDefinitionsSearcher.Companion.processPropertyImplementationsMethods((Iterable<? extends PsiMethod>)OverridersSearchKt.toPossiblyFakeLightMethods(this.$declaration), this.$scope, (Processor<PsiElement>)this.$consumer);
                }
                {
                    this.$declaration = ktNamedDeclaration;
                    this.$scope = searchScope2;
                    this.$consumer = processor2;
                    super(0);
                }
            });
        }

        private final boolean processActualDeclarations(KtDeclaration declaration2, Processor<PsiElement> consumer2) {
            return (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(declaration2, consumer2){
                final /* synthetic */ KtDeclaration $declaration;
                final /* synthetic */ Processor $consumer;

                /*
                 * WARNING - void declaration
                 */
                public final boolean invoke() {
                    boolean bl;
                    block5: {
                        if (!ExpectActualUtilKt.isExpectDeclaration(this.$declaration)) {
                            bl = true;
                        } else {
                            void $receiver$iv;
                            Iterable iterable = ExpectActualUtilKt.actualsForExpected$default(this.$declaration, null, 1, null);
                            Processor processor2 = this.$consumer;
                            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                                bl = true;
                            } else {
                                for (T element$iv : $receiver$iv) {
                                    PsiElement p1 = (PsiElement)element$iv;
                                    if (processor2.process((Object)p1)) continue;
                                    bl = false;
                                    break block5;
                                }
                                bl = true;
                            }
                        }
                    }
                    return bl;
                }
                {
                    this.$declaration = ktDeclaration;
                    this.$consumer = processor2;
                    super(0);
                }
            });
        }

        public final boolean processPropertyImplementationsMethods(@NotNull Iterable<? extends PsiMethod> accessors, @NotNull SearchScope scope2, @NotNull Processor<PsiElement> consumer2) {
            boolean bl;
            block3: {
                Intrinsics.checkParameterIsNotNull(accessors, (String)"accessors");
                Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
                Intrinsics.checkParameterIsNotNull(consumer2, (String)"consumer");
                Iterable<? extends PsiMethod> $receiver$iv = accessors;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (PsiMethod psiMethod : $receiver$iv) {
                        PsiMethod method = psiMethod;
                        if (OverridersSearchKt.forEachOverridingMethod(method, scope2, (Function1<? super PsiMethod, Boolean>)((Function1)new Function1<PsiMethod, Boolean>(scope2, consumer2){
                            final /* synthetic */ SearchScope $scope$inlined;
                            final /* synthetic */ Processor $consumer$inlined;
                            {
                                this.$scope$inlined = searchScope2;
                                this.$consumer$inlined = processor2;
                                super(1);
                            }

                            public final boolean invoke(@NotNull PsiMethod implementation) {
                                Intrinsics.checkParameterIsNotNull((Object)implementation, (String)"implementation");
                                if (org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinDefinitionsSearcher$Companion.access$isDelegated(KotlinDefinitionsSearcher.Companion, (PsiElement)implementation)) {
                                    return true;
                                }
                                PsiElement elementToProcess = (PsiElement)ApplicationUtilsKt.runReadAction((Function0)new Function0<PsiElement>(implementation){
                                    final /* synthetic */ PsiMethod $implementation;
                                    {
                                        this.$implementation = psiMethod;
                                        super(0);
                                    }

                                    public final PsiElement invoke() {
                                        PsiMethod psiMethod = this.$implementation;
                                        if (!(psiMethod instanceof KtLightMethod)) {
                                            psiMethod = null;
                                        }
                                        KtLightMethod ktLightMethod = (KtLightMethod)psiMethod;
                                        KtDeclaration mirrorElement = ktLightMethod != null ? (KtDeclaration)ktLightMethod.getKotlinOrigin() : null;
                                        KtDeclaration ktDeclaration = mirrorElement;
                                        return ktDeclaration instanceof KtProperty || ktDeclaration instanceof KtParameter ? (PsiElement)mirrorElement : (ktDeclaration instanceof KtPropertyAccessor ? (((KtPropertyAccessor)mirrorElement).getParent() instanceof KtProperty ? ((KtPropertyAccessor)mirrorElement).getParent() : (PsiElement)this.$implementation) : (PsiElement)this.$implementation);
                                    }
                                });
                                return this.$consumer$inlined.process((Object)elementToProcess);
                            }
                        }))) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$isDelegated(Companion $this, @NotNull PsiElement element3) {
            return $this.isDelegated(element3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

