/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.ImpreciseResolveResult;
import org.jetbrains.kotlin.idea.search.PsiBasedClassResolver;
import org.jetbrains.kotlin.idea.search.PsiBasedClassResolverKt;
import org.jetbrains.kotlin.idea.search.SearchUtilKt;
import org.jetbrains.kotlin.idea.stubindex.KotlinTypeAliasShortNameIndex;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 #2\u00020\u0001:\u0002#$B\u000f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006J,\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0014\u0010!\u001a\u00020\u0014*\u00020\u00142\u0006\u0010\"\u001a\u00020\u0014H\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/search/PsiBasedClassResolver;", "", "target", "Lcom/intellij/psi/PsiClass;", "(Lcom/intellij/psi/PsiClass;)V", "targetClassFqName", "", "(Ljava/lang/String;)V", "conflictingPackages", "", "forceAmbiguity", "", "forceAmbiguityForNonAnnotations", "packagesWithTypeAliases", "targetPackage", "targetShortName", "addConflict", "", "fqName", "analyzeSingleImport", "Lorg/jetbrains/kotlin/idea/search/PsiBasedClassResolver$Result;", "result", "importedFqName", "Lorg/jetbrains/kotlin/name/FqName;", "isAllUnder", "aliasName", "canBeTargetReference", "Lorg/jetbrains/kotlin/asJava/ImpreciseResolveResult;", "ref", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "checkQualifiedReferenceToTarget", "findPotentialClassConflicts", "findPotentialTypeAliasConflicts", "changeTo", "newResult", "Companion", "Result", "idea-core"})
public final class PsiBasedClassResolver {
    private final String targetShortName;
    private final String targetPackage;
    private final List<String> conflictingPackages;
    private final List<String> packagesWithTypeAliases;
    private boolean forceAmbiguity;
    private boolean forceAmbiguityForNonAnnotations;
    private final String targetClassFqName;
    @NotNull
    private static final AtomicInteger attempts;
    @NotNull
    private static final AtomicInteger trueHits;
    @NotNull
    private static final AtomicInteger falseHits;
    private static final Key<CachedValue<PsiBasedClassResolver>> PSI_BASED_CLASS_RESOLVER_KEY;
    public static final Companion Companion;

    private final void findPotentialClassConflicts(PsiClass target) {
        PsiShortNamesCache psiShortNamesCache = PsiShortNamesCache.getInstance((Project)target.getProject());
        Project project = target.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"target.project");
        PsiClass[] candidates2 = psiShortNamesCache.getClassesByName(this.targetShortName, SearchUtilKt.allScope(project));
        int n = candidates2.length;
        for (int i = 0; i < n; ++i) {
            PsiClass candidate;
            PsiClass psiClass2 = candidate = candidates2[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)psiClass2, (String)"candidate");
            if (psiClass2.getContainingClass() != null && !candidate.hasModifierProperty("private")) {
                if (candidate.isAnnotationType()) {
                    this.forceAmbiguity = true;
                    break;
                }
                this.forceAmbiguityForNonAnnotations = true;
                break;
            }
            if (Intrinsics.areEqual((Object)candidate.getQualifiedName(), (Object)target.getQualifiedName())) {
                PsiElement psiElement2 = candidate.getNavigationElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"candidate.navigationElement");
                PsiFile psiFile = psiElement2.getContainingFile();
                PsiElement psiElement3 = target.getNavigationElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"target.navigationElement");
                if (!(Intrinsics.areEqual((Object)psiFile, (Object)psiElement3.getContainingFile()) ^ true)) continue;
                this.forceAmbiguity = true;
                break;
            }
            String string = candidate.getQualifiedName();
            if (string == null || (string = StringsKt.substringBeforeLast((String)string, (char)'.', (String)"")) == null) continue;
            String string2 = string;
            String candidatePackage = string2;
            if (Intrinsics.areEqual((Object)candidatePackage, (Object)"")) {
                this.forceAmbiguity = true;
                continue;
            }
            this.conflictingPackages.add(candidatePackage);
        }
    }

    private final void findPotentialTypeAliasConflicts(PsiClass target) {
        KotlinTypeAliasShortNameIndex kotlinTypeAliasShortNameIndex = KotlinTypeAliasShortNameIndex.getInstance();
        Project project = target.getProject();
        Project project2 = target.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"target.project");
        Collection<KtTypeAlias> candidates2 = kotlinTypeAliasShortNameIndex.get(this.targetShortName, project, SearchUtilKt.allScope(project2));
        Iterator<KtTypeAlias> iterator2 = candidates2.iterator();
        while (iterator2.hasNext()) {
            KtTypeAlias candidate;
            KtTypeAlias ktTypeAlias = candidate = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeAlias, (String)"candidate");
            String string = ktTypeAlias.getContainingKtFile().getPackageFqName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"candidate.containingKtFi\u2026.packageFqName.asString()");
            this.packagesWithTypeAliases.add(string);
        }
    }

    public final void addConflict(@NotNull String fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        this.conflictingPackages.add(StringsKt.substringBeforeLast$default((String)fqName2, (char)'.', null, (int)2, null));
    }

    @NotNull
    public final ImpreciseResolveResult canBeTargetReference(@NotNull KtSimpleNameExpression ref) {
        Object $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)ref, (String)"ref");
        attempts.incrementAndGet();
        if (Intrinsics.areEqual((Object)ref.getReferencedName(), (Object)this.targetShortName) ^ true) {
            return ImpreciseResolveResult.UNSURE;
        }
        PsiElement $receiver$iv = (PsiElement)ref;
        KtUserType ktUserType2 = (KtUserType)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtUserType.class, (boolean)true);
        if (ktUserType2 == null) {
            return ImpreciseResolveResult.UNSURE;
        }
        KtUserType userType2 = ktUserType2;
        if (this.forceAmbiguityForNonAnnotations) {
            $receiver$iv = (PsiElement)userType2;
            Function1 branch$iv = canBeTargetReference.1.INSTANCE;
            boolean strict$iv = false;
            $receiver$iv$iv = $receiver$iv;
            PsiElement psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv$iv, KtAnnotationEntry.class, (boolean)strict$iv);
            if ((psiElement2 != null ? PsiUtilsKt.getIfChildIsInBranch(psiElement2, $receiver$iv, branch$iv) : null) == null) {
                return ImpreciseResolveResult.UNSURE;
            }
        }
        if (this.forceAmbiguity) {
            return ImpreciseResolveResult.UNSURE;
        }
        Result qualifiedCheckResult = this.checkQualifiedReferenceToTarget(ref);
        if (qualifiedCheckResult != null) {
            return qualifiedCheckResult.getReturnValue();
        }
        KtFile file2 = ref.getContainingKtFile();
        Result result2 = Result.NothingFound;
        String filePackage = file2.getPackageFqName().asString();
        $receiver$iv$iv = filePackage;
        if (Intrinsics.areEqual((Object)$receiver$iv$iv, (Object)this.targetPackage)) {
            result2 = this.changeTo(result2, Result.Found);
        } else if (this.conflictingPackages.contains($receiver$iv$iv)) {
            result2 = this.changeTo(result2, Result.FoundOther);
        } else if (this.packagesWithTypeAliases.contains($receiver$iv$iv)) {
            return ImpreciseResolveResult.UNSURE;
        }
        KtFile ktFile = file2;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"file");
        for (ImportPath importPath : PsiBasedClassResolverKt.access$getDefaultImports(ktFile)) {
            Name name2 = importPath.getAlias();
            if ((result2 = this.analyzeSingleImport(result2, importPath.getFqName(), importPath.isAllUnder(), name2 != null ? name2.asString() : null)) != Result.Ambiguity) continue;
            return ImpreciseResolveResult.UNSURE;
        }
        for (KtImportDirective importDirective : file2.getImportDirectives()) {
            if ((result2 = this.analyzeSingleImport(result2, importDirective.getImportedFqName(), importDirective.isAllUnder(), importDirective.getAliasName())) != Result.Ambiguity) continue;
            return ImpreciseResolveResult.UNSURE;
        }
        if (result2.getReturnValue() == ImpreciseResolveResult.MATCH) {
            trueHits.incrementAndGet();
        } else if (result2.getReturnValue() == ImpreciseResolveResult.NO_MATCH) {
            falseHits.incrementAndGet();
        }
        return result2.getReturnValue();
    }

    private final Result analyzeSingleImport(Result result2, FqName importedFqName, boolean isAllUnder, String aliasName) {
        if (!isAllUnder) {
            FqName fqName2 = importedFqName;
            if (Intrinsics.areEqual((Object)(fqName2 != null ? fqName2.asString() : null), (Object)this.targetClassFqName) && (aliasName == null || Intrinsics.areEqual((Object)aliasName, (Object)this.targetShortName))) {
                return this.changeTo(result2, Result.Found);
            }
            Object object = importedFqName;
            if (Intrinsics.areEqual((Object)(object != null && (object = ((FqName)object).shortName()) != null ? ((Name)object).asString() : null), (Object)this.targetShortName) && this.conflictingPackages.contains(importedFqName.parent().asString()) && aliasName == null) {
                return this.changeTo(result2, Result.FoundOther);
            }
            Object object2 = importedFqName;
            if (Intrinsics.areEqual((Object)(object2 != null && (object2 = ((FqName)object2).shortName()) != null ? ((Name)object2).asString() : null), (Object)this.targetShortName) && this.packagesWithTypeAliases.contains(importedFqName.parent().asString()) && aliasName == null) {
                return Result.Ambiguity;
            }
            if (Intrinsics.areEqual((Object)aliasName, (Object)this.targetShortName)) {
                return this.changeTo(result2, Result.FoundOther);
            }
        } else {
            FqName fqName3 = importedFqName;
            if (Intrinsics.areEqual((Object)(fqName3 != null ? fqName3.asString() : null), (Object)this.targetPackage)) {
                return this.changeTo(result2, Result.Found);
            }
            FqName fqName4 = importedFqName;
            if (CollectionsKt.contains((Iterable)this.conflictingPackages, (Object)(fqName4 != null ? fqName4.asString() : null))) {
                return this.changeTo(result2, Result.FoundOther);
            }
            FqName fqName5 = importedFqName;
            if (CollectionsKt.contains((Iterable)this.packagesWithTypeAliases, (Object)(fqName5 != null ? fqName5.asString() : null))) {
                return Result.Ambiguity;
            }
        }
        return result2;
    }

    private final Result checkQualifiedReferenceToTarget(KtSimpleNameExpression ref) {
        KtUserType qualifier;
        PsiElement psiElement2 = ref.getParent();
        if (!(psiElement2 instanceof KtUserType)) {
            psiElement2 = null;
        }
        KtUserType ktUserType2 = (KtUserType)psiElement2;
        KtUserType ktUserType3 = qualifier = ktUserType2 != null ? ktUserType2.getQualifier() : null;
        if (qualifier != null) {
            if (Intrinsics.areEqual((Object)qualifier.getText(), (Object)this.targetPackage)) {
                return Result.Ambiguity;
            }
            return Result.FoundOther;
        }
        return null;
    }

    private final Result changeTo(@NotNull Result $receiver, Result newResult2) {
        if ($receiver == Result.NothingFound || $receiver.getReturnValue() == newResult2.getReturnValue()) {
            return newResult2;
        }
        return Result.Ambiguity;
    }

    public PsiBasedClassResolver(@NotNull String targetClassFqName) {
        List list2;
        Intrinsics.checkParameterIsNotNull((Object)targetClassFqName, (String)"targetClassFqName");
        this.targetClassFqName = targetClassFqName;
        this.targetShortName = StringsKt.substringAfterLast$default((String)this.targetClassFqName, (char)'.', null, (int)2, null);
        this.targetPackage = StringsKt.substringBeforeLast((String)this.targetClassFqName, (char)'.', (String)"");
        PsiBasedClassResolver psiBasedClassResolver = this;
        psiBasedClassResolver.conflictingPackages = list2 = (List)new ArrayList();
        psiBasedClassResolver = this;
        psiBasedClassResolver.packagesWithTypeAliases = list2 = (List)new ArrayList();
    }

    private PsiBasedClassResolver(final PsiClass target) {
        CharSequence charSequence;
        String string = target.getQualifiedName();
        if (string == null) {
            string = "";
        }
        this(string);
        if (target.getQualifiedName() == null || target.getContainingClass() != null || (charSequence = (CharSequence)this.targetPackage).length() == 0) {
            this.forceAmbiguity = true;
            return;
        }
        ApplicationUtilsKt.runReadAction((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.findPotentialClassConflicts(target);
                this.findPotentialTypeAliasConflicts(target);
            }
        });
    }

    static {
        Companion = new Companion(null);
        attempts = new AtomicInteger();
        trueHits = new AtomicInteger();
        falseHits = new AtomicInteger();
        PSI_BASED_CLASS_RESOLVER_KEY = new Key("PsiBasedClassResolver");
    }

    public /* synthetic */ PsiBasedClassResolver(@NotNull PsiClass target, DefaultConstructorMarker $constructor_marker) {
        this(target);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/search/PsiBasedClassResolver$Result;", "", "returnValue", "Lorg/jetbrains/kotlin/asJava/ImpreciseResolveResult;", "(Ljava/lang/String;ILorg/jetbrains/kotlin/asJava/ImpreciseResolveResult;)V", "getReturnValue", "()Lorg/jetbrains/kotlin/asJava/ImpreciseResolveResult;", "NothingFound", "Found", "FoundOther", "Ambiguity", "idea-core"})
    public static final class Result
    extends Enum<Result> {
        public static final /* enum */ Result NothingFound;
        public static final /* enum */ Result Found;
        public static final /* enum */ Result FoundOther;
        public static final /* enum */ Result Ambiguity;
        private static final /* synthetic */ Result[] $VALUES;
        @NotNull
        private final ImpreciseResolveResult returnValue;

        static {
            Result[] resultArray = new Result[4];
            Result[] resultArray2 = resultArray;
            resultArray[0] = NothingFound = new Result(ImpreciseResolveResult.NO_MATCH);
            resultArray[1] = Found = new Result(ImpreciseResolveResult.MATCH);
            resultArray[2] = FoundOther = new Result(ImpreciseResolveResult.NO_MATCH);
            resultArray[3] = Ambiguity = new Result(ImpreciseResolveResult.UNSURE);
            $VALUES = resultArray;
        }

        @NotNull
        public final ImpreciseResolveResult getReturnValue() {
            return this.returnValue;
        }

        protected Result(ImpreciseResolveResult returnValue) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)returnValue), (String)"returnValue");
            this.returnValue = returnValue;
        }

        public static Result[] values() {
            return (Result[])$VALUES.clone();
        }

        public static Result valueOf(String string) {
            return Enum.valueOf(Result.class, string);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0016\u0010\r\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/search/PsiBasedClassResolver$Companion;", "", "()V", "PSI_BASED_CLASS_RESOLVER_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "Lorg/jetbrains/kotlin/idea/search/PsiBasedClassResolver;", "attempts", "Ljava/util/concurrent/atomic/AtomicInteger;", "getAttempts", "()Ljava/util/concurrent/atomic/AtomicInteger;", "falseHits", "getFalseHits", "trueHits", "getTrueHits", "getInstance", "target", "Lcom/intellij/psi/PsiClass;", "idea-core"})
    public static final class Companion {
        @NotNull
        public final AtomicInteger getAttempts() {
            return attempts;
        }

        @NotNull
        public final AtomicInteger getTrueHits() {
            return trueHits;
        }

        @NotNull
        public final AtomicInteger getFalseHits() {
            return falseHits;
        }

        @NotNull
        public final PsiBasedClassResolver getInstance(@NotNull PsiClass target) {
            Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
            CachedValue cachedValue2 = (CachedValue)target.getUserData(PSI_BASED_CLASS_RESOLVER_KEY);
            if (cachedValue2 != null) {
                CachedValue cachedValue3;
                CachedValue it;
                CachedValue cachedValue4 = it = (cachedValue3 = cachedValue2);
                Intrinsics.checkExpressionValueIsNotNull((Object)cachedValue4, (String)"it");
                Object object = cachedValue4.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.value");
                return (PsiBasedClassResolver)object;
            }
            CachedValue cachedValue5 = CachedValuesManager.getManager((Project)target.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<PsiBasedClassResolver>(target){
                final /* synthetic */ PsiClass $target;

                @NotNull
                public final CachedValueProvider.Result<PsiBasedClassResolver> compute() {
                    return new CachedValueProvider.Result((Object)new PsiBasedClassResolver(this.$target, null), new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
                }
                {
                    this.$target = psiClass2;
                }
            }, false);
            target.putUserData(PSI_BASED_CLASS_RESOLVER_KEY, (Object)cachedValue5);
            CachedValue cachedValue6 = cachedValue5;
            Intrinsics.checkExpressionValueIsNotNull((Object)cachedValue6, (String)"cachedValue");
            Object object = cachedValue6.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"cachedValue.value");
            return (PsiBasedClassResolver)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

