/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.ui;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.components.panels.HorizontalLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchFileLanguageProvider;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.actions.ClearScratchAction;
import org.jetbrains.kotlin.idea.scratch.actions.RunScratchAction;
import org.jetbrains.kotlin.idea.scratch.ui.ScratchFileAttributesKt;
import org.jetbrains.kotlin.idea.scratch.ui.ScratchPanelConfig;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\r\u001a\u00020\u000e2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000e0\u0010J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u000eH\u0016J\b\u0010\u0019\u001a\u0004\u0018\u00010\u0012J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001bJ\u000e\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001bJ\u000e\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0012J\u000e\u0010!\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchTopPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "scratchFile", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "(Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;)V", "isMakeBeforeRunCheckbox", "Ljavax/swing/JCheckBox;", "isReplCheckbox", "moduleChooser", "Lcom/intellij/application/options/ModulesComboBox;", "getScratchFile", "()Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "addModuleListener", "", "f", "Lkotlin/Function2;", "Lcom/intellij/psi/PsiFile;", "Lcom/intellij/openapi/module/Module;", "createActionsToolbar", "Ljavax/swing/JComponent;", "createModuleChooser", "project", "Lcom/intellij/openapi/project/Project;", "dispose", "getModule", "isMakeBeforeRun", "", "isRepl", "setMakeBeforeRun", "isSelected", "setModule", "module", "setReplMode", "Companion", "idea-jvm"})
public final class ScratchTopPanel
extends JPanel
implements Disposable {
    private final ModulesComboBox moduleChooser;
    private final JCheckBox isReplCheckbox;
    private final JCheckBox isMakeBeforeRunCheckbox;
    @NotNull
    private final ScratchFile scratchFile;
    public static final Companion Companion = new Companion(null);

    public void dispose() {
        ScratchUtilsKt.removeScratchPanel(this.scratchFile.getEditor(), this);
    }

    @Nullable
    public final Module getModule() {
        return this.moduleChooser.getSelectedModule();
    }

    public final void setModule(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        this.moduleChooser.setSelectedModule(module);
    }

    public final void addModuleListener(@NotNull Function2<? super PsiFile, ? super Module, Unit> f) {
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        this.moduleChooser.addActionListener(new ActionListener(this, f){
            final /* synthetic */ ScratchTopPanel this$0;
            final /* synthetic */ Function2 $f;

            public final void actionPerformed(ActionEvent it) {
                Module selectedModule = ScratchTopPanel.access$getModuleChooser$p(this.this$0).getSelectedModule();
                PsiFile psiFile = this.this$0.getScratchFile().getPsiFile();
                if (selectedModule != null && psiFile != null) {
                    this.$f.invoke((Object)psiFile, (Object)selectedModule);
                }
            }
            {
                this.this$0 = scratchTopPanel;
                this.$f = function2;
            }
        });
    }

    public final boolean isRepl() {
        return this.isReplCheckbox.isSelected();
    }

    public final boolean isMakeBeforeRun() {
        return this.isMakeBeforeRunCheckbox.isSelected();
    }

    public final void setReplMode(boolean isSelected) {
        this.isReplCheckbox.setSelected(isSelected);
    }

    public final void setMakeBeforeRun(boolean isSelected) {
        this.isMakeBeforeRunCheckbox.setSelected(isSelected);
    }

    private final JComponent createActionsToolbar() {
        DefaultActionGroup defaultActionGroup;
        DefaultActionGroup $receiver = defaultActionGroup = new DefaultActionGroup();
        $receiver.add((AnAction)new RunScratchAction(this));
        $receiver.addSeparator();
        $receiver.add((AnAction)new ClearScratchAction(this));
        DefaultActionGroup toolbarGroup = defaultActionGroup;
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)toolbarGroup, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)actionToolbar, (String)"ActionManager.getInstanc\u2026LBAR, toolbarGroup, true)");
        JComponent jComponent = actionToolbar.getComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"ActionManager.getInstanc\u2026barGroup, true).component");
        return jComponent;
    }

    private final ModulesComboBox createModuleChooser(Project project) {
        ModulesComboBox modulesComboBox;
        ModulesComboBox $receiver = modulesComboBox = new ModulesComboBox();
        $receiver.fillModules(project);
        return modulesComboBox;
    }

    @NotNull
    public final ScratchFile getScratchFile() {
        return this.scratchFile;
    }

    private ScratchTopPanel(ScratchFile scratchFile) {
        super((LayoutManager)new HorizontalLayout(5));
        Object object;
        this.scratchFile = scratchFile;
        this.add(this.createActionsToolbar());
        this.moduleChooser = this.createModuleChooser(this.scratchFile.getProject());
        this.add(new JLabel("Use classpath of module"));
        this.add((Component)this.moduleChooser);
        this.add(new JSeparator(1));
        this.isReplCheckbox = new JCheckBox("Use REPL", false);
        this.add(this.isReplCheckbox);
        this.isReplCheckbox.addItemListener(new ItemListener(){

            @Override
            public final void itemStateChanged(ItemEvent it) {
                block1: {
                    PsiFile psiFile = this.getScratchFile().getPsiFile();
                    if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) break block1;
                    PsiFile psiFile2 = psiFile;
                    PsiFile $receiver = psiFile2;
                    ScratchPanelConfig scratchPanelConfig2 = ScratchFileAttributesKt.getScratchPanelConfig((VirtualFile)$receiver);
                    if (scratchPanelConfig2 == null) {
                        scratchPanelConfig2 = new ScratchPanelConfig(false, false, 3, null);
                    }
                    ScratchFileAttributesKt.setScratchPanelConfig((VirtualFile)$receiver, ScratchPanelConfig.copy$default(scratchPanelConfig2, isReplCheckbox.isSelected(), false, 2, null));
                }
            }
        });
        this.add(new JSeparator(1));
        this.isMakeBeforeRunCheckbox = new JCheckBox("Make before Run", false);
        this.add(this.isMakeBeforeRunCheckbox);
        this.isMakeBeforeRunCheckbox.addItemListener(new ItemListener(){

            @Override
            public final void itemStateChanged(ItemEvent it) {
                block1: {
                    PsiFile psiFile = this.getScratchFile().getPsiFile();
                    if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) break block1;
                    PsiFile psiFile2 = psiFile;
                    PsiFile $receiver = psiFile2;
                    ScratchPanelConfig scratchPanelConfig2 = ScratchFileAttributesKt.getScratchPanelConfig((VirtualFile)$receiver);
                    if (scratchPanelConfig2 == null) {
                        scratchPanelConfig2 = new ScratchPanelConfig(false, false, 3, null);
                    }
                    ScratchFileAttributesKt.setScratchPanelConfig((VirtualFile)$receiver, ScratchPanelConfig.copy$default(scratchPanelConfig2, false, isMakeBeforeRunCheckbox.isSelected(), 1, null));
                }
            }
        });
        this.add(new JSeparator(1));
        Object object2 = this.scratchFile.getPsiFile();
        if (object2 == null || (object2 = object2.getVirtualFile()) == null || (object2 = ScratchFileAttributesKt.getScratchPanelConfig((VirtualFile)object2)) == null) {
            object2 = new ScratchPanelConfig(false, false, 3, null);
        }
        Object it = object = object2;
        this.isReplCheckbox.setSelected(((ScratchPanelConfig)it).isRepl());
        this.isMakeBeforeRunCheckbox.setSelected(((ScratchPanelConfig)it).isMakeBeforeRun());
    }

    @NotNull
    public static final /* synthetic */ ModulesComboBox access$getModuleChooser$p(ScratchTopPanel $this) {
        return $this.moduleChooser;
    }

    public /* synthetic */ ScratchTopPanel(@NotNull ScratchFile scratchFile, DefaultConstructorMarker $constructor_marker) {
        this(scratchFile);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchTopPanel$Companion;", "", "()V", "createPanel", "", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "editor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "idea-jvm"})
    public static final class Companion {
        public final void createPanel(@NotNull Project project, @NotNull VirtualFile virtualFile2, @NotNull TextEditor editor) {
            PsiFile psiFile;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)virtualFile2, (String)"virtualFile");
            Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
            PsiFile psiFile2 = PsiManager.getInstance((Project)project).findFile(virtualFile2);
            if (psiFile2 == null) {
                return;
            }
            PsiFile psiFile3 = psiFile = psiFile2;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile3, (String)"psiFile");
            Language language = psiFile3.getLanguage();
            Intrinsics.checkExpressionValueIsNotNull((Object)language, (String)"psiFile.language");
            Object object = ScratchFileLanguageProvider.Companion.get(language);
            if (object == null || (object = ((ScratchFileLanguageProvider)object).createFile(project, editor)) == null) {
                return;
            }
            Object scratchFile = object;
            ScratchUtilsKt.addScratchPanel(editor, new ScratchTopPanel((ScratchFile)scratchFile, null));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

