/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.output;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutput;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputHandlerAdapter;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputType;
import org.jetbrains.kotlin.idea.scratch.output.ScratchToolWindowFactory;
import org.jetbrains.kotlin.idea.scratch.output.ToolWindowScratchOutputHandler;
import org.jetbrains.kotlin.idea.scratch.output.ToolWindowScratchOutputHandler$WhenMappings;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J)\u0010\u0017\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0017\u0010\u0018\u001a\u0013\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00040\u0019\u00a2\u0006\u0002\b\u001bH\u0002J$\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\r2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0014\u0010\u001d\u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001e*\u00020 H\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/output/ToolWindowScratchOutputHandler;", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputHandlerAdapter;", "()V", "clear", "", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "createToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "project", "Lcom/intellij/openapi/project/Project;", "error", "message", "", "getLineInfo", "psiFile", "Lcom/intellij/psi/PsiFile;", "expression", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "getToolWindow", "handle", "output", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutput;", "printToConsole", "print", "Lkotlin/Function1;", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "Lkotlin/ExtensionFunctionType;", "testPrint", "convert", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputType;", "idea-jvm"})
public final class ToolWindowScratchOutputHandler
extends ScratchOutputHandlerAdapter {
    public static final ToolWindowScratchOutputHandler INSTANCE;

    @Override
    public void handle(@NotNull ScratchFile file2, @NotNull ScratchExpression expression2, @NotNull ScratchOutput output) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            this.testPrint(file2, output.getText(), expression2);
            return;
        }
        this.printToConsole(file2.getProject(), (Function1<? super ConsoleViewImpl, Unit>)((Function1)new Function1<ConsoleViewImpl, Unit>(file2, expression2, output){
            final /* synthetic */ ScratchFile $file;
            final /* synthetic */ ScratchExpression $expression;
            final /* synthetic */ ScratchOutput $output;

            public final void invoke(@NotNull ConsoleViewImpl $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                PsiFile psiFile = this.$file.getPsiFile();
                if (psiFile != null) {
                    $receiver.printHyperlink(ToolWindowScratchOutputHandler.access$getLineInfo(ToolWindowScratchOutputHandler.INSTANCE, psiFile, this.$expression), (HyperlinkInfo)new OpenFileHyperlinkInfo($receiver.getProject(), psiFile.getVirtualFile(), this.$expression.getLineStart()));
                    $receiver.print(" ", ConsoleViewContentType.NORMAL_OUTPUT);
                }
                $receiver.print(this.$output.getText(), ToolWindowScratchOutputHandler.access$convert(ToolWindowScratchOutputHandler.INSTANCE, this.$output.getType()));
            }
            {
                this.$file = scratchFile;
                this.$expression = scratchExpression;
                this.$output = scratchOutput;
                super(1);
            }
        }));
    }

    @Override
    public void error(@NotNull ScratchFile file2, @NotNull String message2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            ToolWindowScratchOutputHandler.testPrint$default(this, file2, message2, null, 4, null);
            return;
        }
        this.printToConsole(file2.getProject(), (Function1<? super ConsoleViewImpl, Unit>)((Function1)new Function1<ConsoleViewImpl, Unit>(message2){
            final /* synthetic */ String $message;

            public final void invoke(@NotNull ConsoleViewImpl $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                $receiver.print(this.$message, ConsoleViewContentType.ERROR_OUTPUT);
            }
            {
                this.$message = string;
                super(1);
            }
        }));
    }

    private final void printToConsole(Project project, Function1<? super ConsoleViewImpl, Unit> print2) {
        ApplicationManager.getApplication().invokeLater(new Runnable(project, print2){
            final /* synthetic */ Project $project;
            final /* synthetic */ Function1 $print;

            public final void run() {
                ToolWindow toolWindow = ToolWindowScratchOutputHandler.access$getToolWindow(ToolWindowScratchOutputHandler.INSTANCE, this.$project);
                if (toolWindow == null) {
                    toolWindow = ToolWindowScratchOutputHandler.access$createToolWindow(ToolWindowScratchOutputHandler.INSTANCE, this.$project);
                }
                ToolWindow toolWindow2 = toolWindow;
                ContentManager contentManager = toolWindow2.getContentManager();
                Intrinsics.checkExpressionValueIsNotNull((Object)contentManager, (String)"toolWindow.contentManager");
                Content[] contents = contentManager.getContents();
                int n = contents.length;
                for (int i = 0; i < n; ++i) {
                    Content content2;
                    Content content3 = content2 = contents[i];
                    Intrinsics.checkExpressionValueIsNotNull((Object)content3, (String)"content");
                    JComponent component = content3.getComponent();
                    if (!(component instanceof ConsoleViewImpl)) continue;
                    this.$print.invoke((Object)component);
                    ((ConsoleViewImpl)component).print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
                }
                toolWindow2.setAvailable(true, null);
                toolWindow2.show(null);
            }
            {
                this.$project = project;
                this.$print = function1;
            }
        });
    }

    @Override
    public void clear(@NotNull ScratchFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(file2){
            final /* synthetic */ ScratchFile $file;

            public final void run() {
                ToolWindow toolWindow = ToolWindowScratchOutputHandler.access$getToolWindow(ToolWindowScratchOutputHandler.INSTANCE, this.$file.getProject());
                if (toolWindow == null) {
                    return;
                }
                ToolWindow toolWindow2 = toolWindow;
                ContentManager contentManager = toolWindow2.getContentManager();
                Intrinsics.checkExpressionValueIsNotNull((Object)contentManager, (String)"toolWindow.contentManager");
                Content[] contents = contentManager.getContents();
                int n = contents.length;
                for (int i = 0; i < n; ++i) {
                    Content content2;
                    Content content3 = content2 = contents[i];
                    Intrinsics.checkExpressionValueIsNotNull((Object)content3, (String)"content");
                    JComponent component = content3.getComponent();
                    if (!(component instanceof ConsoleViewImpl)) continue;
                    ((ConsoleViewImpl)component).clear();
                }
                toolWindow2.setAvailable(false, null);
                toolWindow2.hide(null);
            }
            {
                this.$file = scratchFile;
            }
        });
    }

    private final String getLineInfo(PsiFile psiFile, ScratchExpression expression2) {
        return psiFile.getName() + ':' + (expression2.getLineStart() + 1);
    }

    private final ConsoleViewContentType convert(@NotNull ScratchOutputType $receiver) {
        ConsoleViewContentType consoleViewContentType;
        switch (ToolWindowScratchOutputHandler$WhenMappings.$EnumSwitchMapping$0[$receiver.ordinal()]) {
            case 1: {
                consoleViewContentType = ConsoleViewContentType.SYSTEM_OUTPUT;
                break;
            }
            case 2: {
                consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
                break;
            }
            case 3: {
                consoleViewContentType = ConsoleViewContentType.ERROR_OUTPUT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return consoleViewContentType;
    }

    private final ToolWindow getToolWindow(Project project) {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        return toolWindowManager.getToolWindow("Scratch Output");
    }

    private final ToolWindow createToolWindow(Project project) {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        toolWindowManager.registerToolWindow("Scratch Output", true, ToolWindowAnchor.BOTTOM);
        ToolWindow window = toolWindowManager.getToolWindow("Scratch Output");
        ScratchToolWindowFactory scratchToolWindowFactory = new ScratchToolWindowFactory();
        ToolWindow toolWindow = window;
        Intrinsics.checkExpressionValueIsNotNull((Object)toolWindow, (String)"window");
        scratchToolWindowFactory.createToolWindowContent(project, toolWindow);
        return window;
    }

    private final void testPrint(ScratchFile file2, String output, ScratchExpression expression2) {
        ApplicationManager.getApplication().invokeLater(new Runnable(file2, expression2, output){
            final /* synthetic */ ScratchFile $file;
            final /* synthetic */ ScratchExpression $expression;
            final /* synthetic */ String $output;

            public final void run() {
                WriteCommandAction.runWriteCommandAction((Project)this.$file.getProject(), (Runnable)new Runnable(this){
                    final /* synthetic */ testPrint.1 this$0;

                    public final void run() {
                        Object object;
                        StringBuilder stringBuilder;
                        KtPsiFactory ktPsiFactory;
                        PsiFile psiFile;
                        PsiFile psiFile2;
                        block5: {
                            block4: {
                                PsiFile psiFile3 = this.this$0.$file.getPsiFile();
                                if (psiFile3 == null) {
                                    Intrinsics.throwNpe();
                                }
                                psiFile = psiFile2 = psiFile3;
                                ktPsiFactory = new KtPsiFactory(this.this$0.$file.getProject(), false, 2, null);
                                stringBuilder = new StringBuilder().append("/** ");
                                object = this.this$0.$expression;
                                if (object == null) break block4;
                                ScratchExpression scratchExpression = object;
                                StringBuilder stringBuilder2 = stringBuilder;
                                KtPsiFactory ktPsiFactory2 = ktPsiFactory;
                                PsiFile psiFile4 = psiFile;
                                ScratchExpression it = scratchExpression;
                                String string = ToolWindowScratchOutputHandler.access$getLineInfo(ToolWindowScratchOutputHandler.INSTANCE, psiFile2, this.this$0.$expression) + " ";
                                psiFile = psiFile4;
                                ktPsiFactory = ktPsiFactory2;
                                stringBuilder = stringBuilder2;
                                object = string;
                                if (object != null) break block5;
                            }
                            object = "";
                        }
                        psiFile.addAfter((PsiElement)ktPsiFactory.createComment(stringBuilder.append((String)object).append(this.this$0.$output).append(" */").toString()), psiFile2.getLastChild());
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$file = scratchFile;
                this.$expression = scratchExpression;
                this.$output = string;
            }
        });
    }

    static /* bridge */ /* synthetic */ void testPrint$default(ToolWindowScratchOutputHandler toolWindowScratchOutputHandler, ScratchFile scratchFile, String string, ScratchExpression scratchExpression, int n, Object object) {
        if ((n & 4) != 0) {
            scratchExpression = null;
        }
        toolWindowScratchOutputHandler.testPrint(scratchFile, string, scratchExpression);
    }

    private ToolWindowScratchOutputHandler() {
    }

    static {
        ToolWindowScratchOutputHandler toolWindowScratchOutputHandler;
        INSTANCE = toolWindowScratchOutputHandler = new ToolWindowScratchOutputHandler();
    }

    @NotNull
    public static final /* synthetic */ String access$getLineInfo(ToolWindowScratchOutputHandler $this, @NotNull PsiFile psiFile, @NotNull ScratchExpression expression2) {
        return $this.getLineInfo(psiFile, expression2);
    }

    public static final /* synthetic */ ConsoleViewContentType access$convert(ToolWindowScratchOutputHandler $this, @NotNull ScratchOutputType $receiver) {
        return $this.convert($receiver);
    }

    @Nullable
    public static final /* synthetic */ ToolWindow access$getToolWindow(ToolWindowScratchOutputHandler $this, @NotNull Project project) {
        return $this.getToolWindow(project);
    }

    @NotNull
    public static final /* synthetic */ ToolWindow access$createToolWindow(ToolWindowScratchOutputHandler $this, @NotNull Project project) {
        return $this.createToolWindow(project);
    }
}

