/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.output;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.Colors;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.scratch.output.InlayScratchFileRenderer$WhenMappings;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eH\u0016J\b\u0010\u0018\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/output/InlayScratchFileRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "text", "", "outputType", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputType;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputType;)V", "getText", "()Ljava/lang/String;", "calcWidthInPixels", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "getAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "getFontInfo", "Lcom/intellij/openapi/editor/impl/FontInfo;", "paint", "", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "textAttributes", "toString", "Companion", "idea-jvm"})
public final class InlayScratchFileRenderer
implements EditorCustomElementRenderer {
    @NotNull
    private final String text;
    private final ScratchOutputType outputType;
    private static final TextAttributes normalAttributes;
    private static final TextAttributes errorAttributes;
    private static final Color userOutputColor;
    private static final TextAttributes userOutputAttributes;
    public static final Companion Companion;

    private final FontInfo getFontInfo(Editor editor) {
        EditorColorsScheme colorsScheme;
        EditorColorsScheme editorColorsScheme = colorsScheme = editor.getColorsScheme();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsScheme, (String)"colorsScheme");
        FontPreferences fontPreferences = editorColorsScheme.getFontPreferences();
        TextAttributes attributes = this.getAttributes();
        int fontStyle = attributes.getFontType();
        FontInfo fontInfo = ComplementaryFontsRegistry.getFontAbleToDisplay((int)97, (int)fontStyle, (FontPreferences)fontPreferences, (FontRenderContext)FontInfo.getFontRenderContext((Component)editor.getContentComponent()));
        Intrinsics.checkExpressionValueIsNotNull((Object)fontInfo, (String)"ComplementaryFontsRegist\u2026ntentComponent)\n        )");
        return fontInfo;
    }

    public int calcWidthInPixels(@NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        FontInfo fontInfo = this.getFontInfo(editor);
        return fontInfo.fontMetrics().stringWidth(this.text);
    }

    public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        Intrinsics.checkParameterIsNotNull((Object)textAttributes, (String)"textAttributes");
        TextAttributes attributes = this.getAttributes();
        Color color = attributes.getForegroundColor();
        if (color == null) {
            return;
        }
        Color fgColor = color;
        g.setColor(fgColor);
        FontInfo fontInfo = this.getFontInfo(editor);
        g.setFont(fontInfo.getFont());
        FontMetrics metrics = fontInfo.fontMetrics();
        int n = r.x;
        int n2 = r.y;
        FontMetrics fontMetrics = metrics;
        Intrinsics.checkExpressionValueIsNotNull((Object)fontMetrics, (String)"metrics");
        g.drawString(this.text, n, n2 + fontMetrics.getAscent());
    }

    private final TextAttributes getAttributes() {
        TextAttributes textAttributes;
        switch (InlayScratchFileRenderer$WhenMappings.$EnumSwitchMapping$0[this.outputType.ordinal()]) {
            case 1: {
                textAttributes = userOutputAttributes;
                break;
            }
            case 2: {
                textAttributes = normalAttributes;
                break;
            }
            case 3: {
                textAttributes = errorAttributes;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return textAttributes;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        String string;
        StringBuilder stringBuilder;
        String string2;
        block3: {
            void $receiver$iv;
            string2 = this.text;
            stringBuilder = new StringBuilder();
            int n = 0;
            int n2 = $receiver$iv.length();
            while (n < n2) {
                void index$iv;
                char it = $receiver$iv.charAt((int)index$iv);
                if (!CharsKt.isWhitespace((char)it)) {
                    void var4_6 = $receiver$iv;
                    int n3 = 0;
                    String string3 = var4_6.substring(n3, (int)index$iv);
                    string = string3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    break block3;
                }
                ++index$iv;
            }
            string = string2;
        }
        String string4 = string;
        string2 = this.text;
        stringBuilder = stringBuilder.append(string4).append(this.outputType.name()).append(": ");
        String string5 = string2;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        string4 = ((Object)StringsKt.trim((CharSequence)string5)).toString();
        return stringBuilder.append(string4).toString();
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public InlayScratchFileRenderer(@NotNull String text2, @NotNull ScratchOutputType outputType) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)((Object)outputType), (String)"outputType");
        this.text = text2;
        this.outputType = outputType;
    }

    static {
        Companion = new Companion(null);
        normalAttributes = new TextAttributes((Color)JBColor.GRAY, null, null, null, 2);
        errorAttributes = new TextAttributes((Color)new JBColor(Colors.DARK_RED, Colors.DARK_RED), null, null, null, 2);
        userOutputColor = new Color(0x5C5CFF);
        userOutputAttributes = new TextAttributes((Color)new JBColor(userOutputColor, userOutputColor), null, null, null, 2);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/output/InlayScratchFileRenderer$Companion;", "", "()V", "errorAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "normalAttributes", "userOutputAttributes", "userOutputColor", "Ljava/awt/Color;", "idea-jvm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

