/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.actions;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchFileLanguageProvider;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.actions.RunScratchAction;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputHandler;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputHandlerAdapter;
import org.jetbrains.kotlin.idea.scratch.ui.ScratchTopPanel;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/actions/RunScratchAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "scratchPanel", "Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchTopPanel;", "(Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchTopPanel;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "idea-jvm"})
public final class RunScratchAction
extends AnAction {
    private final ScratchTopPanel scratchPanel;

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        ScratchFile scratchFile = this.scratchPanel.getScratchFile();
        PsiFile psiFile = scratchFile.getPsiFile();
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        boolean isMakeBeforeRun = this.scratchPanel.isMakeBeforeRun();
        boolean isRepl = this.scratchPanel.isRepl();
        Language language = psiFile2.getLanguage();
        Intrinsics.checkExpressionValueIsNotNull((Object)language, (String)"psiFile.language");
        ScratchFileLanguageProvider scratchFileLanguageProvider = ScratchFileLanguageProvider.Companion.get(language);
        if (scratchFileLanguageProvider == null) {
            return;
        }
        ScratchFileLanguageProvider provider2 = scratchFileLanguageProvider;
        ScratchOutputHandler handler2 = provider2.getOutputHandler();
        handler2.onStart(scratchFile);
        Logger logger = ScratchUtilsKt.getLOG();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
        ScratchUtilsKt.printDebugMessage(logger, "Run Action: isMakeBeforeRun = " + isMakeBeforeRun + ", isRepl = " + isRepl);
        Module module = this.scratchPanel.getModule();
        if (module == null) {
            handler2.error(scratchFile, "Module should be selected");
            handler2.onFinish(scratchFile);
            return;
        }
        Function0<Unit> executeScratch$ = new Function0<Unit>(isRepl, provider2, scratchFile, handler2, psiFile2, e){
            final /* synthetic */ boolean $isRepl;
            final /* synthetic */ ScratchFileLanguageProvider $provider;
            final /* synthetic */ ScratchFile $scratchFile;
            final /* synthetic */ ScratchOutputHandler $handler;
            final /* synthetic */ PsiFile $psiFile;
            final /* synthetic */ AnActionEvent $e;

            public final void invoke() {
                ScratchExecutor executor;
                ScratchExecutor scratchExecutor = executor = this.$isRepl ? this.$provider.createReplExecutor(this.$scratchFile) : this.$provider.createCompilingExecutor(this.$scratchFile);
                if (executor == null) {
                    this.$handler.error(this.$scratchFile, "Couldn't run " + this.$psiFile.getName());
                    this.$handler.onFinish(this.$scratchFile);
                    return;
                }
                Presentation presentation = this.$e.getPresentation();
                Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
                presentation.setEnabled(false);
                executor.addOutputHandler(this.$handler);
                executor.addOutputHandler(new ScratchOutputHandlerAdapter(this){
                    final /* synthetic */ actionPerformed.1 this$0;

                    public void onFinish(@NotNull ScratchFile file2) {
                        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                        Presentation presentation = this.this$0.$e.getPresentation();
                        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
                        presentation.setEnabled(true);
                    }
                    {
                        this.this$0 = $outer;
                    }
                });
                try {
                    executor.execute();
                }
                catch (Throwable ex) {
                    this.$handler.error(this.$scratchFile, "Exception occurs during Run Scratch Action");
                    this.$handler.onFinish(this.$scratchFile);
                    Presentation presentation2 = this.$e.getPresentation();
                    Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"e.presentation");
                    presentation2.setEnabled(true);
                    ScratchUtilsKt.getLOG().error(ex);
                }
            }
            {
                this.$isRepl = bl;
                this.$provider = scratchFileLanguageProvider;
                this.$scratchFile = scratchFile;
                this.$handler = scratchOutputHandler;
                this.$psiFile = psiFile;
                this.$e = anActionEvent;
                super(0);
            }
        };
        if (isMakeBeforeRun) {
            CompilerManager.getInstance((Project)project2).make(module, new CompileStatusNotification(handler2, scratchFile, module, project2, executeScratch$){
                final /* synthetic */ ScratchOutputHandler $handler;
                final /* synthetic */ ScratchFile $scratchFile;
                final /* synthetic */ Module $module;
                final /* synthetic */ Project $project;
                final /* synthetic */ actionPerformed.1 $executeScratch$1;

                public final void finished(boolean aborted, int errors, int $noName_2, CompileContext $noName_3) {
                    if (aborted || errors > 0) {
                        this.$handler.error(this.$scratchFile, "There were compilation errors in module " + this.$module.getName());
                    }
                    if (DumbService.isDumb((Project)this.$project)) {
                        DumbService.getInstance((Project)this.$project).smartInvokeLater(new Runnable(this){
                            final /* synthetic */ actionPerformed.2 this$0;

                            public final void run() {
                                this.this$0.$executeScratch$1.invoke();
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    } else {
                        this.$executeScratch$1.invoke();
                    }
                }
                {
                    this.$handler = scratchOutputHandler;
                    this.$scratchFile = scratchFile;
                    this.$module = module;
                    this.$project = project;
                    this.$executeScratch$1 = var5_5;
                }
            });
        } else {
            executeScratch$.invoke();
        }
    }

    public RunScratchAction(@NotNull ScratchTopPanel scratchPanel) {
        Intrinsics.checkParameterIsNotNull((Object)scratchPanel, (String)"scratchPanel");
        super(KotlinBundle.message("scratch.run.button", new Object[0]), KotlinBundle.message("scratch.run.button", new Object[0]), AllIcons.Actions.Execute);
        this.scratchPanel = scratchPanel;
    }
}

