/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.idea.project.TargetPlatformDetector;
import org.jetbrains.kotlin.idea.run.KotlinRunConfiguration;
import org.jetbrains.kotlin.idea.run.KotlinRunConfigurationProducer;
import org.jetbrains.kotlin.idea.run.KotlinRunConfigurationProducerKt;
import org.jetbrains.kotlin.idea.run.KotlinRunConfigurationType;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J&\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/run/KotlinRunConfigurationProducer;", "Lcom/intellij/execution/actions/RunConfigurationProducer;", "Lorg/jetbrains/kotlin/idea/run/KotlinRunConfiguration;", "()V", "getEntryPointContainer", "Lorg/jetbrains/kotlin/psi/KtDeclarationContainer;", "location", "Lcom/intellij/execution/Location;", "isConfigurationFromContext", "", "configuration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "Companion", "idea-jvm"})
public final class KotlinRunConfigurationProducer
extends RunConfigurationProducer<KotlinRunConfiguration> {
    public static final Companion Companion = new Companion(null);

    protected boolean setupConfigurationFromContext(@NotNull KotlinRunConfiguration configuration2, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Location location2;
        Intrinsics.checkParameterIsNotNull((Object)((Object)configuration2), (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(sourceElement, (String)"sourceElement");
        Location location3 = context.getLocation();
        if (location3 == null) {
            return false;
        }
        Location location4 = location2 = location3;
        Intrinsics.checkExpressionValueIsNotNull((Object)location4, (String)"location");
        Module module = location4.getModule();
        if (module == null) {
            return false;
        }
        Module module2 = module;
        KtDeclarationContainer container2 = this.getEntryPointContainer(location2);
        String string = Companion.getStartClassFqName(container2);
        if (string == null) {
            return false;
        }
        String startClassFQName = string;
        configuration2.setModule(module2);
        configuration2.setRunClass(startClassFQName);
        configuration2.setGeneratedName();
        return true;
    }

    private final KtDeclarationContainer getEntryPointContainer(Location<?> location2) {
        PsiElement locationElement;
        if (location2 == null) {
            return null;
        }
        DumbService dumbService = DumbService.getInstance((Project)location2.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)dumbService, (String)"DumbService.getInstance(location.project)");
        if (dumbService.isDumb()) {
            return null;
        }
        Module module = location2.getModule();
        if (module == null) {
            return null;
        }
        Module module2 = module;
        if (!(TargetPlatformDetector.getPlatform(module2) instanceof JvmPlatform)) {
            Module module3 = module2;
            Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"module");
            if (KotlinRunConfigurationProducerKt.findJvmImplementationModule(module3) == null) {
                return null;
            }
        }
        PsiElement psiElement2 = locationElement = location2.getPsiElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"locationElement");
        return Companion.getEntryPointContainer(psiElement2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConfigurationFromContext(@NotNull KotlinRunConfiguration configuration2, @NotNull ConfigurationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)configuration2), (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String string = Companion.getStartClassFqName(this.getEntryPointContainer(context.getLocation()));
        if (string == null) return false;
        String startClassFQName = string;
        if (!Intrinsics.areEqual((Object)configuration2.getRunClass(), (Object)startClassFQName)) return false;
        Module module = context.getModule();
        JavaRunConfigurationModule javaRunConfigurationModule = (JavaRunConfigurationModule)configuration2.getConfigurationModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)javaRunConfigurationModule, (String)"configuration.configurationModule");
        if (!Intrinsics.areEqual((Object)module, (Object)javaRunConfigurationModule.getModule())) return false;
        return true;
    }

    public KotlinRunConfigurationProducer() {
        super((ConfigurationType)KotlinRunConfigurationType.getInstance());
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0004J\u0016\u0010\n\u001a\u0004\u0018\u00010\u0004*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/run/KotlinRunConfigurationProducer$Companion;", "", "()V", "getEntryPointContainer", "Lorg/jetbrains/kotlin/psi/KtDeclarationContainer;", "locationElement", "Lcom/intellij/psi/PsiElement;", "getStartClassFqName", "", "container", "declarationContainer", "strict", "", "idea-jvm"})
    public static final class Companion {
        @Nullable
        public final KtDeclarationContainer getEntryPointContainer(@NotNull PsiElement locationElement) {
            Intrinsics.checkParameterIsNotNull((Object)locationElement, (String)"locationElement");
            PsiFile psiFile = locationElement.getContainingFile();
            if (!(psiFile instanceof KtFile) || !ProjectRootsUtil.isInProjectOrLibSource((PsiElement)psiFile)) {
                return null;
            }
            MainFunctionDetector mainFunctionDetector2 = new MainFunctionDetector((Function1<? super KtNamedFunction, ? extends FunctionDescriptor>)((Function1)getEntryPointContainer.mainFunctionDetector.1.INSTANCE));
            KtDeclarationContainer currentElement = this.declarationContainer(locationElement, false);
            while (currentElement != null) {
                KtDeclarationContainer entryPointContainer = currentElement;
                if (entryPointContainer instanceof KtClass) {
                    entryPointContainer = (KtDeclarationContainer)CollectionsKt.singleOrNull(((KtClass)entryPointContainer).getCompanionObjects());
                }
                if (entryPointContainer != null) {
                    List<KtDeclaration> list2 = entryPointContainer.getDeclarations();
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"entryPointContainer.declarations");
                    if (mainFunctionDetector2.hasMain(list2)) {
                        return entryPointContainer;
                    }
                }
                currentElement = this.declarationContainer((PsiElement)currentElement, true);
            }
            return null;
        }

        @Nullable
        public final String getStartClassFqName(@Nullable KtDeclarationContainer container2) {
            String string;
            KtDeclarationContainer ktDeclarationContainer = container2;
            if (ktDeclarationContainer == null) {
                string = null;
            } else if (ktDeclarationContainer instanceof KtFile) {
                string = JvmFileClassUtilKt.getJavaFileFacadeFqName((KtFile)container2).asString();
            } else if (ktDeclarationContainer instanceof KtClassOrObject) {
                if (!((KtClassOrObject)container2).isValid()) {
                    string = null;
                } else if (container2 instanceof KtObjectDeclaration && ((KtObjectDeclaration)container2).isCompanion()) {
                    Object $receiver$iv;
                    PsiElement psiElement2 = (PsiElement)container2;
                    boolean strict$iv = true;
                    KtClass containerClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtClass.class, (boolean)strict$iv);
                    Object object = containerClass;
                    if (object != null && (object = LightClassUtilsKt.toLightClass(object)) != null) {
                        Object it = $receiver$iv = object;
                        string = ClassUtil.getJVMClassName((PsiClass)((PsiClass)it));
                    } else {
                        string = null;
                    }
                } else {
                    KtLightClass ktLightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)container2);
                    if (ktLightClass != null) {
                        KtLightClass ktLightClass2;
                        KtLightClass it = ktLightClass2 = ktLightClass;
                        string = ClassUtil.getJVMClassName((PsiClass)it);
                    } else {
                        string = null;
                    }
                }
            } else {
                KtDeclarationContainer ktDeclarationContainer2 = container2;
                if (ktDeclarationContainer2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiElement");
                }
                throw (Throwable)new IllegalArgumentException("Invalid entry-point container: " + ((PsiElement)ktDeclarationContainer2).getText());
            }
            return string;
        }

        private final KtDeclarationContainer declarationContainer(@NotNull PsiElement $receiver, boolean strict) {
            PsiElement element3 = strict ? PsiTreeUtil.getParentOfType((PsiElement)$receiver, (Class[])new Class[]{KtClassOrObject.class, KtFile.class}) : PsiTreeUtil.getNonStrictParentOfType((PsiElement)$receiver, (Class[])new Class[]{KtClassOrObject.class, KtFile.class});
            return (KtDeclarationContainer)element3;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

