/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.references;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.MultiRangeReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.references.KtSimpleReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001cB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0013H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/references/KtArrayAccessReference;", "Lorg/jetbrains/kotlin/idea/references/KtSimpleReference;", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "Lcom/intellij/psi/MultiRangeReference;", "expression", "(Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;)V", "resolvesByNames", "", "Lorg/jetbrains/kotlin/name/Name;", "getResolvesByNames", "()Ljava/util/Collection;", "canRename", "", "getBracketRange", "Lcom/intellij/openapi/util/TextRange;", "bracketToken", "Lorg/jetbrains/kotlin/lexer/KtToken;", "getRangeInElement", "getRanges", "", "getTargetDescriptors", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "handleElementRename", "Lcom/intellij/psi/PsiElement;", "newElementName", "", "Companion", "idea-core"})
public final class KtArrayAccessReference
extends KtSimpleReference<KtArrayAccessExpression>
implements MultiRangeReference {
    private static final ArrayList<Name> NAMES;
    public static final Companion Companion;

    @Override
    @NotNull
    public Collection<Name> getResolvesByNames() {
        ArrayList<Name> arrayList = NAMES;
        Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"NAMES");
        return arrayList;
    }

    @NotNull
    public TextRange getRangeInElement() {
        KtArrayAccessExpression ktArrayAccessExpression = (KtArrayAccessExpression)this.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktArrayAccessExpression, (String)"element");
        TextRange textRange = ktArrayAccessExpression.getTextRange();
        KtArrayAccessExpression ktArrayAccessExpression2 = (KtArrayAccessExpression)this.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktArrayAccessExpression2, (String)"element");
        return textRange.shiftRight(-ktArrayAccessExpression2.getTextOffset());
    }

    @Override
    @NotNull
    protected Collection<DeclarationDescriptor> getTargetDescriptors(@NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ResolvedCall resolvedCall2 = (ResolvedCall)context.get(BindingContext.INDEXED_LVALUE_GET, this.getExpression());
        FunctionDescriptor getFunctionDescriptor = resolvedCall2 != null ? (FunctionDescriptor)resolvedCall2.getCandidateDescriptor() : null;
        ResolvedCall resolvedCall3 = (ResolvedCall)context.get(BindingContext.INDEXED_LVALUE_SET, this.getExpression());
        FunctionDescriptor setFunctionDescriptor = resolvedCall3 != null ? (FunctionDescriptor)resolvedCall3.getCandidateDescriptor() : null;
        return CollectionsKt.listOfNotNull((Object[])new FunctionDescriptor[]{getFunctionDescriptor, setFunctionDescriptor});
    }

    private final TextRange getBracketRange(KtToken bracketToken) {
        KtContainerNode ktContainerNode = ((KtArrayAccessExpression)this.getExpression()).getIndicesNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktContainerNode, (String)"expression.indicesNode");
        ASTNode aSTNode = ktContainerNode.getNode().findChildByType((IElementType)bracketToken);
        return aSTNode != null && (aSTNode = aSTNode.getTextRange()) != null ? aSTNode.shiftRight(-((KtArrayAccessExpression)this.getExpression()).getTextOffset()) : null;
    }

    @NotNull
    public List<TextRange> getRanges() {
        Object[] objectArray = new TextRange[2];
        KtSingleValueToken ktSingleValueToken = KtTokens.LBRACKET;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken), (String)"KtTokens.LBRACKET");
        objectArray[0] = this.getBracketRange(ktSingleValueToken);
        KtSingleValueToken ktSingleValueToken2 = KtTokens.RBRACKET;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken2), (String)"KtTokens.RBRACKET");
        objectArray[1] = this.getBracketRange(ktSingleValueToken2);
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    @Override
    public boolean canRename() {
        return true;
    }

    @Override
    @Nullable
    public PsiElement handleElementRename(@Nullable String newElementName) {
        KtArrayAccessExpression arrayAccessExpression2 = (KtArrayAccessExpression)this.getExpression();
        if (Intrinsics.areEqual((Object)OperatorNameConventions.INVOKE.asString(), (Object)newElementName)) {
            KtExpression fullCallExpression;
            KtCallExpression callExpression2;
            Object object;
            Project project = arrayAccessExpression2.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"arrayAccessExpression.project");
            KtExpression replacement2 = CreateByPatternKt.buildExpression$default(new KtPsiFactory(project, false, 2, null), false, (Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(arrayAccessExpression2){
                final /* synthetic */ KtArrayAccessExpression $arrayAccessExpression;

                public final void invoke(@NotNull BuilderByPattern<KtExpression> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    KtExpression arrayExpression = this.$arrayAccessExpression.getArrayExpression();
                    if (arrayExpression instanceof KtQualifiedExpression) {
                        $receiver.appendExpression(((KtQualifiedExpression)arrayExpression).getReceiverExpression());
                        String string = ((KtQualifiedExpression)arrayExpression).getOperationSign().getValue();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"arrayExpression.operationSign.value");
                        $receiver.appendFixedText(string);
                        $receiver.appendExpression(((KtQualifiedExpression)arrayExpression).getSelectorExpression());
                    } else {
                        $receiver.appendExpression(arrayExpression);
                    }
                    $receiver.appendFixedText("(");
                    List<KtExpression> list2 = this.$arrayAccessExpression.getIndexExpressions();
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"arrayAccessExpression.indexExpressions");
                    $receiver.appendExpressions((Iterable<KtExpression>)list2, ",");
                    $receiver.appendFixedText(")");
                }
                {
                    this.$arrayAccessExpression = ktArrayAccessExpression;
                    super(1);
                }
            }, 1, null);
            PsiElement $receiver$iv = (PsiElement)arrayAccessExpression2;
            PsiElement result$iv = $receiver$iv.replace((PsiElement)replacement2);
            if (result$iv instanceof KtExpression) {
                object = result$iv;
            } else {
                PsiElement psiElement2 = result$iv;
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                }
                object = ((KtParenthesizedExpression)psiElement2).getExpression();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
            }
            if ((callExpression2 = KtPsiUtilKt.getPossiblyQualifiedCallExpression(fullCallExpression = (KtExpression)object)) != null && PsiModificationUtilsKt.canMoveLambdaOutsideParentheses(callExpression2)) {
                PsiModificationUtilsKt.moveFunctionLiteralOutsideParentheses(callExpression2);
            }
            return (PsiElement)fullCallExpression;
        }
        return (PsiElement)ReferenceUtilKt.renameImplicitConventionalCall(this, newElementName);
    }

    public KtArrayAccessReference(@NotNull KtArrayAccessExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        super((KtReferenceExpression)expression2);
    }

    static {
        Companion = new Companion(null);
        NAMES = Lists.newArrayList((Object[])new Name[]{OperatorNameConventions.GET, OperatorNameConventions.SET});
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/references/KtArrayAccessReference$Companion;", "", "()V", "NAMES", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/name/Name;", "kotlin.jvm.PlatformType", "idea-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

