/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.ui;

import com.intellij.ide.util.AbstractTreeClassChooserDialog;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.projectView.KtClassOrObjectTreeNode;
import org.jetbrains.kotlin.idea.projectView.KtFileTreeNode;
import org.jetbrains.kotlin.idea.search.SearchUtilKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J.\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/ui/KotlinFileChooserDialog;", "Lcom/intellij/ide/util/AbstractTreeClassChooserDialog;", "Lorg/jetbrains/kotlin/psi/KtFile;", "title", "", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "createChooseByNameModel", "Lcom/intellij/ide/util/gotoByName/GotoFileModel;", "getClassesByName", "", "name", "checkBoxState", "", "pattern", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getSelectedFromTreeUserObject", "node", "Ljavax/swing/tree/DefaultMutableTreeNode;", "idea"})
public final class KotlinFileChooserDialog
extends AbstractTreeClassChooserDialog<KtFile> {
    @Nullable
    protected KtFile getSelectedFromTreeUserObject(@NotNull DefaultMutableTreeNode node) {
        KtFile ktFile;
        Object userObject;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Object object = userObject = node.getUserObject();
        if (object instanceof KtFileTreeNode) {
            ktFile = ((KtFileTreeNode)((Object)userObject)).getKtFile();
        } else if (object instanceof KtClassOrObjectTreeNode) {
            KtFile containingFile;
            KtClassOrObject ktClassOrObject = (KtClassOrObject)((KtClassOrObjectTreeNode)((Object)userObject)).getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktClassOrObject, (String)"userObject.value");
            KtFile ktFile2 = containingFile = ktClassOrObject.getContainingKtFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFile2, (String)"containingFile");
            ktFile = ktFile2.getDeclarations().size() == 1 ? containingFile : null;
        } else {
            ktFile = null;
        }
        return ktFile;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<KtFile> getClassesByName(@NotNull String name2, boolean checkBoxState, @NotNull String pattern, @NotNull GlobalSearchScope searchScope2) {
        void $receiver$iv$iv;
        PsiFile[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
        Intrinsics.checkParameterIsNotNull((Object)searchScope2, (String)"searchScope");
        PsiFile[] psiFileArray = FilenameIndex.getFilesByName((Project)this.getProject(), (String)name2, (GlobalSearchScope)searchScope2);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFileArray, (String)"FilenameIndex.getFilesBy\u2026oject, name, searchScope)");
        PsiFile[] psiFileArray2 = $receiver$iv = psiFileArray;
        Collection destination$iv$iv = new ArrayList();
        for (void element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof KtFile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected GotoFileModel createChooseByNameModel() {
        return new GotoFileModel(this.getProject());
    }

    public KotlinFileChooserDialog(@NotNull String title, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        super(title, project, SearchUtilKt.restrictToKotlinSources(SearchUtilKt.projectScope(project)), KtFile.class, null, null, null, false, false);
    }
}

