/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesImpl;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.MoveFilesUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsHandler;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsHandlerKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.KotlinAwareMoveFilesOrDirectoriesDialog;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.KotlinSelectNestedClassRefactoringDialog;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.MoveKotlinNestedClassesDialog;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.MoveKotlinTopLevelDeclarationsDialog;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\tJ/\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u000bJ9\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012JC\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016J\u001f\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0002\u0010\u0018J'\u0010\u0019\u001a\u00020\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u00072\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0002\u0010\u001cJ6\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\f\u0010\u0003\u001a\u00020\u0004*\u00020#H\u0002\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/MoveKotlinDeclarationsHandler;", "Lcom/intellij/refactoring/move/MoveHandlerDelegate;", "()V", "canMove", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "targetContainer", "([Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;)Z", "editorMode", "([Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Z)Z", "doMove", "", "project", "Lcom/intellij/openapi/project/Project;", "callback", "Lcom/intellij/refactoring/move/MoveCallback;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/refactoring/move/MoveCallback;)V", "doMoveWithCheck", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/refactoring/move/MoveCallback;Lcom/intellij/openapi/editor/Editor;)Z", "getUniqueContainer", "([Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "isValidTarget", "psiElement", "sources", "(Lcom/intellij/psi/PsiElement;[Lcom/intellij/psi/PsiElement;)Z", "tryToMove", "element", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "reference", "Lcom/intellij/psi/PsiReference;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "idea"})
public final class MoveKotlinDeclarationsHandler
extends MoveHandlerDelegate {
    private final PsiElement getUniqueContainer(PsiElement[] elements2) {
        boolean bl;
        block2: {
            for (PsiElement element$iv : elements2) {
                PsiElement it = element$iv;
                if (!(!(it.getParent() instanceof KtFile))) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        Function1 getContainer2 = bl ? (Function1)getUniqueContainer.getContainer.2.INSTANCE : (Function1)getUniqueContainer.getContainer.3.INSTANCE;
        PsiElement[] $receiver$iv = elements2;
        Collection destination$iv = new LinkedHashSet();
        for (PsiElement element$iv$iv : $receiver$iv) {
            Object object;
            PsiElement element$iv = element$iv$iv;
            if (getContainer2.invoke((Object)element$iv) == null) continue;
            Object it$iv = object;
            destination$iv.add(it$iv);
        }
        return (PsiElement)CollectionsKt.singleOrNull((Iterable)destination$iv);
    }

    private final boolean canMove(@NotNull KtNamedDeclaration $receiver) {
        return $receiver instanceof KtClassOrObject ? !((KtClassOrObject)$receiver).isLocal() : $receiver.getParent() instanceof KtFile;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean doMoveWithCheck(Project project, PsiElement[] elements2, PsiElement targetContainer, MoveCallback callback2, Editor editor) {
        boolean bl;
        LinkedHashSet elementsToSearch;
        PsiElement container2;
        block36: {
            boolean bl2;
            block35: {
                boolean bl3;
                block34: {
                    boolean bl4;
                    block33: {
                        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, (Collection)ArraysKt.toList((Object[])elements2), (boolean)true)) {
                            return false;
                        }
                        container2 = this.getUniqueContainer((PsiElement[])elements2);
                        if (container2 == null) {
                            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"All declarations must belong to the same directory or class", (String)MoveKotlinDeclarationsHandlerKt.access$getMOVE_DECLARATIONS$p(), null);
                            return false;
                        }
                        PsiElement psiElement2 = elements2;
                        Iterator destination$iv = new LinkedHashSet();
                        for (PsiElement element$iv : psiElement2) {
                            Iterable iterable;
                            PsiElement it = element$iv;
                            PsiElement psiElement3 = it;
                            if (psiElement3 instanceof KtNamedDeclaration) {
                                iterable = CollectionsKt.listOf((Object)it);
                            } else if (psiElement3 instanceof KtFile) {
                                void $receiver$iv$iv;
                                Iterable $receiver$iv2;
                                Iterable iterable2 = $receiver$iv2 = (Iterable)((KtFile)it).getDeclarations();
                                Collection destination$iv$iv = new ArrayList();
                                for (Object element$iv$iv : $receiver$iv$iv) {
                                    if (!(element$iv$iv instanceof KtNamedDeclaration)) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                iterable = (List)destination$iv$iv;
                            } else {
                                iterable = CollectionsKt.emptyList();
                            }
                            Iterable list$iv = iterable;
                            CollectionsKt.addAll((Collection)((Object)destination$iv), (Iterable)list$iv);
                        }
                        elementsToSearch = (LinkedHashSet)((Object)destination$iv);
                        Iterable iterable = elementsToSearch;
                        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                            bl4 = false;
                        } else {
                            for (Object element$iv : iterable) {
                                KtNamedDeclaration it = (KtNamedDeclaration)element$iv;
                                if (!(it instanceof KtObjectDeclaration && ((KtObjectDeclaration)it).isCompanion())) continue;
                                bl4 = true;
                                break block33;
                            }
                            bl4 = false;
                        }
                    }
                    if (bl4) {
                        String string = RefactoringBundle.getCannotRefactorMessage((String)"Move declaration is not supported for companion objects");
                        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)string, (String)MoveKotlinDeclarationsHandlerKt.access$getMOVE_DECLARATIONS$p(), null);
                        return true;
                    }
                    Iterable iterable = elementsToSearch;
                    if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : iterable) {
                            KtNamedDeclaration it = (KtNamedDeclaration)element$iv;
                            if (!(!this.canMove(it))) continue;
                            bl3 = true;
                            break block34;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) {
                    String string = RefactoringBundle.getCannotRefactorMessage((String)"Move declaration is only supported for top-level declarations and nested classes");
                    CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)string, (String)MoveKotlinDeclarationsHandlerKt.access$getMOVE_DECLARATIONS$p(), null);
                    return true;
                }
                Iterable iterable = elementsToSearch;
                if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : iterable) {
                        KtNamedDeclaration it = (KtNamedDeclaration)element$iv;
                        if (!(it instanceof KtEnumEntry)) continue;
                        bl2 = true;
                        break block35;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                String string = RefactoringBundle.getCannotRefactorMessage((String)"Move declaration is not supported for enum entries");
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)string, (String)MoveKotlinDeclarationsHandlerKt.access$getMOVE_DECLARATIONS$p(), null);
                return true;
            }
            for (PsiElement element$iv : elements2) {
                PsiElement it = element$iv;
                if (it instanceof KtFile) continue;
                bl = false;
                break block36;
            }
            bl = true;
        }
        if (bl) {
            PsiElement psiElement4 = targetContainer instanceof PsiPackage || targetContainer instanceof PsiDirectory ? targetContainer : (container2 instanceof PsiPackage || container2 instanceof PsiDirectory ? container2 : null);
            PsiDirectory initialTargetDirectory = MoveFilesOrDirectoriesUtil.resolveToDirectory((Project)project, (PsiElement)psiElement4);
            KotlinAwareMoveFilesOrDirectoriesDialog dialog2 = new KotlinAwareMoveFilesOrDirectoriesDialog(project, (Function1<? super KotlinAwareMoveFilesOrDirectoriesDialog, Unit>)((Function1)new Function1<KotlinAwareMoveFilesOrDirectoriesDialog, Unit>(project, (PsiElement[])elements2, initialTargetDirectory, callback2){
                final /* synthetic */ Project $project;
                final /* synthetic */ PsiElement[] $elements;
                final /* synthetic */ PsiDirectory $initialTargetDirectory;
                final /* synthetic */ MoveCallback $callback;

                public final void invoke(@Nullable KotlinAwareMoveFilesOrDirectoriesDialog it) {
                    MoveFilesUtilKt.invokeMoveFilesOrDirectoriesRefactoring(it, this.$project, this.$elements, this.$initialTargetDirectory, this.$callback);
                }
                {
                    this.$project = project;
                    this.$elements = psiElementArray;
                    this.$initialTargetDirectory = psiDirectory;
                    this.$callback = moveCallback;
                    super(1);
                }
            }));
            dialog2.setData((PsiElement[])elements2, initialTargetDirectory, "refactoring.moveFile");
            dialog2.show();
            return true;
        }
        PsiElement psiElement5 = container2;
        if (psiElement5 instanceof PsiDirectory || psiElement5 instanceof PsiPackage || psiElement5 instanceof KtFile) {
            String targetPackageName = MoveClassesOrPackagesImpl.getInitialTargetPackageName((PsiElement)targetContainer, (PsiElement[])elements2);
            PsiDirectory targetDirectory2 = targetContainer != null ? MoveClassesOrPackagesImpl.getInitialTargetDirectory((PsiElement)targetContainer, (PsiElement[])elements2) : null;
            JavaRefactoringSettings javaRefactoringSettings = JavaRefactoringSettings.getInstance();
            if (javaRefactoringSettings == null) {
                Intrinsics.throwNpe();
            }
            boolean searchInComments = javaRefactoringSettings.MOVE_SEARCH_IN_COMMENTS;
            JavaRefactoringSettings javaRefactoringSettings2 = JavaRefactoringSettings.getInstance();
            if (javaRefactoringSettings2 == null) {
                Intrinsics.throwNpe();
            }
            boolean searchInText = javaRefactoringSettings2.MOVE_SEARCH_FOR_TEXT;
            PsiElement psiElement6 = targetContainer;
            if (!(psiElement6 instanceof KtFile)) {
                psiElement6 = null;
            }
            KtFile targetFile = (KtFile)psiElement6;
            boolean moveToPackage = !(targetContainer instanceof KtFile);
            new MoveKotlinTopLevelDeclarationsDialog(project, elementsToSearch, targetPackageName, targetDirectory2, targetFile, moveToPackage, searchInComments, searchInText, callback2).show();
        } else if (psiElement5 instanceof KtClassOrObject) {
            if (elementsToSearch.size() > 1) {
                void $receiver$iv$iv;
                void $receiver$iv;
                if (!(targetContainer instanceof KtClassOrObject)) {
                    String message3 = RefactoringBundle.getCannotRefactorMessage((String)"Moving multiple nested classes to top-level is not supported");
                    CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message3, (String)MoveKotlinDeclarationsHandlerKt.access$getMOVE_DECLARATIONS$p(), null);
                    return true;
                }
                Iterable message3 = elementsToSearch;
                Project project2 = project;
                void targetDirectory2 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    if (!(element$iv$iv instanceof KtClassOrObject)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list2 = (List)destination$iv$iv;
                MoveCallback moveCallback = callback2;
                KtClassOrObject ktClassOrObject = (KtClassOrObject)targetContainer;
                KtClassOrObject ktClassOrObject2 = (KtClassOrObject)container2;
                List list3 = list2;
                Project project3 = project2;
                new MoveKotlinNestedClassesDialog(project3, list3, ktClassOrObject2, ktClassOrObject, moveCallback).show();
                return true;
            }
            Object object = CollectionsKt.first((Iterable)elementsToSearch);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
            }
            KotlinSelectNestedClassRefactoringDialog.Companion.chooseNestedClassRefactoring((KtClassOrObject)object, targetContainer);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected container: " + PsiUtilsKt.getElementTextWithContext(container2))));
        }
        return true;
    }

    private final boolean canMove(PsiElement[] elements2, PsiElement targetContainer, boolean editorMode) {
        boolean bl;
        block12: {
            if (targetContainer != null && !this.isValidTarget(targetContainer, elements2)) {
                return false;
            }
            PsiElement psiElement2 = this.getUniqueContainer(elements2);
            if (psiElement2 == null) {
                return false;
            }
            PsiElement container2 = psiElement2;
            if (container2 instanceof KtClassOrObject && targetContainer != null && !(targetContainer instanceof KtClassOrObject) && elements2.length > 1) {
                return false;
            }
            for (PsiElement element$iv : elements2) {
                boolean bl2;
                PsiElement e = element$iv;
                if (e instanceof KtClass || e instanceof KtObjectDeclaration && !((KtObjectDeclaration)e).isObjectLiteral() || e instanceof KtNamedFunction || e instanceof KtProperty || e instanceof KtTypeAlias) {
                    bl2 = (editorMode || this.canMove((KtNamedDeclaration)e)) && KotlinRefactoringUtilKt.canRefactor(e);
                } else if (e instanceof KtFile) {
                    boolean bl3;
                    block11: {
                        Iterable $receiver$iv = ((KtFile)e).getDeclarations();
                        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $receiver$iv) {
                                KtDeclaration it = (KtDeclaration)element$iv2;
                                if (!(it instanceof KtNamedDeclaration)) continue;
                                bl3 = true;
                                break block11;
                            }
                            bl3 = false;
                        }
                    }
                    bl2 = bl3 && KotlinRefactoringUtilKt.canRefactor(e);
                } else {
                    bl2 = false;
                }
                if (bl2) continue;
                bl = false;
                break block12;
            }
            bl = true;
        }
        return bl;
    }

    public boolean canMove(@NotNull PsiElement[] elements2, @Nullable PsiElement targetContainer) {
        Intrinsics.checkParameterIsNotNull((Object)elements2, (String)"elements");
        return this.canMove(elements2, targetContainer, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValidTarget(@Nullable PsiElement psiElement2, @NotNull PsiElement[] sources) {
        Intrinsics.checkParameterIsNotNull((Object)sources, (String)"sources");
        if (psiElement2 instanceof PsiPackage) return true;
        if (psiElement2 instanceof PsiDirectory) {
            if (PackageUtilsKt.getPackage((PsiDirectory)psiElement2) != null) return true;
        }
        if (psiElement2 instanceof KtFile) return true;
        if (!(psiElement2 instanceof KtClassOrObject)) return false;
        if (((KtClassOrObject)psiElement2).hasModifier(KtTokens.ANNOTATION_KEYWORD)) return false;
        PsiElement[] $receiver$iv = sources;
        int n = $receiver$iv.length;
        int n2 = 0;
        while (n2 < n) {
            PsiElement element$iv = $receiver$iv[n2];
            PsiElement it = element$iv;
            if (it.getParent() instanceof KtFile) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void doMove(@NotNull Project project, @NotNull PsiElement[] elements2, @Nullable PsiElement targetContainer, @Nullable MoveCallback callback2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)elements2, (String)"elements");
        this.doMoveWithCheck(project, elements2, targetContainer, callback2, null);
    }

    public boolean tryToMove(@NotNull PsiElement element3, @NotNull Project project, @Nullable DataContext dataContext, @Nullable PsiReference reference2, @Nullable Editor editor) {
        PsiElement psiElement2;
        PsiElement[] psiElementArray;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        PsiElement psiElement3 = LightClassUtilsKt.getUnwrapped(element3);
        if (psiElement3 != null) {
            PsiElement psiElement4;
            PsiElement it = psiElement4 = psiElement3;
            PsiElement[] psiElementArray2 = new PsiElement[1];
            psiElementArray = psiElementArray2;
            psiElementArray2[0] = it;
        } else {
            psiElementArray = PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] elementsToMove2 = psiElementArray;
        DataContext dataContext2 = dataContext;
        if (dataContext2 != null) {
            DataContext dataContext3;
            DataContext dataContext4 = dataContext3 = dataContext2;
            psiElement2 = (PsiElement)LangDataKeys.TARGET_PSI_ELEMENT.getData(dataContext4);
        } else {
            psiElement2 = null;
        }
        PsiElement targetContainer = psiElement2;
        Intrinsics.checkExpressionValueIsNotNull((Object)elementsToMove2, (String)"elementsToMove");
        return this.canMove(elementsToMove2, targetContainer, true) && this.doMoveWithCheck(project, elementsToMove2, targetContainer, null, editor);
    }
}

